/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.execute;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CancelledSQLException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.execute.ConnectionWrapper;
import oracle.javatools.db.execute.StatementWrapper;
import oracle.javatools.util.Holder;

public class QueryWrapper
extends StatementWrapper {
    private ResultSet m_rs;
    private List<Object> m_params;
    private boolean m_msgFormat;
    private String m_dbName;

    private QueryWrapper() {
        super((String)null, (Connection)null, (String[])null);
    }

    public QueryWrapper(Database database, String string) {
        this(database, string, (List)null);
    }

    public QueryWrapper(Database database, String string, Object ... objectArray) {
        super(database, string);
        this.setParams(objectArray);
    }

    public QueryWrapper(String string, Connection connection, String string2, Object ... objectArray) {
        super(string, connection, string2);
        this.setParams(objectArray);
    }

    public QueryWrapper(Database database, String string, List list) {
        super(database, string);
        this.setParams(list);
    }

    @Override
    public void setContextObject(DBObject dBObject) {
        DBObjectID dBObjectID;
        super.setContextObject(dBObject);
        if (dBObject != null && (dBObjectID = dBObject.getID()) instanceof BaseObjectID) {
            this.setDatabaseName(((BaseObjectID)dBObjectID).getDatabaseName());
        }
    }

    private void setParams(Object ... objectArray) {
        this.setParams(objectArray == null ? null : Arrays.asList(objectArray));
    }

    private void setParams(List list) {
        this.m_params = list;
        String string = this.getStatementString();
        boolean bl = this.m_msgFormat = string.indexOf("{0}") >= 0;
        if (!(!this.m_msgFormat && string.indexOf("?") < 0 || this.m_params != null && this.m_params.size() >= 1)) {
            throw new IllegalArgumentException("query expects parameters, none given.");
        }
    }

    public final void setDatabaseName(String string) {
        this.m_dbName = string;
    }

    public final String getDatabaseName() {
        return this.m_dbName;
    }

    @Override
    protected Statement createStatment() throws SQLException {
        return this.getConnection().prepareStatement(this.getQuery());
    }

    @Override
    public String getStatementTextForLog() {
        return this.getQuery();
    }

    protected String getQuery() {
        if (this.m_msgFormat && this.m_params != null) {
            return MessageFormat.format(this.getStatementString(), this.m_params.toArray());
        }
        return this.getStatementString();
    }

    private String getStatementString() {
        return this.getStatementStrings()[0];
    }

    protected List<Object> getParameters() {
        if (!this.m_msgFormat && this.m_params != null) {
            return this.m_params;
        }
        return Collections.emptyList();
    }

    @Override
    public final boolean execute() throws DBException {
        throw new UnsupportedOperationException("Use executeQuery to execute a QueryWrapper.");
    }

    public String executeSingleCellQuery() throws DBException {
        final Holder holder = new Holder();
        this.executeQuery(new QueryRunnable(){

            @Override
            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    if (resultSet.next()) {
                        holder.set((Object)resultSet.getString(1));
                    }
                }
                catch (SQLException sQLException) {
                    QueryWrapper.this.throwDBException(sQLException);
                }
            }
        });
        return (String)holder.get();
    }

    public void executeQuery(int n, QueryRunnable queryRunnable) throws DBException {
        this.doExecute(new QueryExecutionRunnable(this, queryRunnable, n));
    }

    private ResultSet executeQueryImpl(int n) throws SQLException {
        PreparedStatement preparedStatement = (PreparedStatement)this.getStatement();
        List<Object> list = this.getParameters();
        Object[] objectArray = null;
        if (list != null && list.size() > 0) {
            objectArray = new Object[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                objectArray[i] = this.convertParam(list.get(i));
                if (this.m_msgFormat) continue;
                if (objectArray[i] instanceof String) {
                    preparedStatement.setString(i + 1, (String)objectArray[i]);
                    continue;
                }
                if (objectArray[i] instanceof Date) {
                    preparedStatement.setDate(i + 1, (Date)objectArray[i]);
                    continue;
                }
                if (objectArray[i] instanceof Integer) {
                    preparedStatement.setInt(i + 1, (Integer)objectArray[i]);
                    continue;
                }
                preparedStatement.setObject(i + 1, objectArray[i]);
            }
        }
        if (n > 0) {
            try {
                preparedStatement.setFetchSize(n);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.sqlTrace(this.getConnectionName(), this.getQuery(), objectArray);
        return preparedStatement.executeQuery();
    }

    public void executeQuery(QueryRunnable queryRunnable) throws DBException {
        this.executeQuery(0, queryRunnable);
    }

    private Object convertParam(Object object) {
        if (object instanceof DBObject) {
            return AbstractDBObjectProvider.convertObject((DBObject)object);
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append(this.convertParam(objectArray[i]));
                if (i >= objectArray.length - 1) continue;
                stringBuffer.append(", ");
            }
            return stringBuffer.toString();
        }
        return object;
    }

    @Override
    public void close() {
        if (this.m_rs != null) {
            try {
                this.m_rs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.close();
    }

    public static QueryWrapper union(QueryWrapper ... queryWrapperArray) {
        return new UnionQueryWrapper(queryWrapperArray);
    }

    @FunctionalInterface
    public static interface QueryRunnable {
        public void processResultSet(ResultSet var1) throws DBException, SQLException;
    }

    private static class UnionQueryWrapper
    extends QueryWrapper {
        private static final String UNION_ALL = " UNION ALL\n";
        private QueryWrapper[] m_wrappers;
        private String m_bigQuery;
        private List m_allParams;

        private UnionQueryWrapper(QueryWrapper ... queryWrapperArray) {
            if (queryWrapperArray == null || queryWrapperArray.length < 1) {
                throw new IllegalArgumentException("Nothing to UNION");
            }
            this.m_wrappers = queryWrapperArray;
            super.setDatabase(this.m_wrappers[0].getDatabase());
        }

        @Override
        protected String getQuery() {
            if (this.m_bigQuery == null) {
                this.processWrappers();
            }
            return this.m_bigQuery;
        }

        protected List getParameters() {
            if (this.m_allParams == null) {
                this.processWrappers();
            }
            return this.m_allParams;
        }

        private void processWrappers() {
            this.m_allParams = new ArrayList();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.m_wrappers.length; ++i) {
                this.m_wrappers[i].setDatabaseName(this.getDatabaseName());
                stringBuffer.append(this.m_wrappers[i].getQuery());
                this.m_allParams.addAll(this.m_wrappers[i].getParameters());
                if (i + 1 >= this.m_wrappers.length) continue;
                stringBuffer.append(UNION_ALL);
            }
            this.m_bigQuery = stringBuffer.toString();
        }
    }

    class QueryExecutionRunnable<T extends QueryRunnable>
    extends StatementWrapper.ExecutionRunnable {
        private int m_fetchSize;
        private T m_run;
        final /* synthetic */ QueryWrapper this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        QueryExecutionRunnable(T t, int n2) {
            this.this$0 = (QueryWrapper)n;
            super((StatementWrapper)n);
            this.m_run = t;
            this.m_fetchSize = n2;
        }

        protected T getRunnable() {
            return this.m_run;
        }

        protected void processResultSet(ResultSet resultSet) throws DBException {
            if (this.m_run != null) {
                try {
                    this.m_run.processResultSet(resultSet);
                }
                catch (SQLException sQLException) {
                    this.this$0.throwDBException(sQLException);
                }
            }
        }

        protected void prepareStatement() throws DBException {
        }

        public final Object runImpl() throws DBException {
            Database database = this.this$0.getDatabase();
            if (database == null) {
                try {
                    this.doRunImpl();
                }
                catch (SQLException sQLException) {
                    this.this$0.throwDBException(sQLException);
                }
            } else {
                ConnectionWrapper connectionWrapper = new ConnectionWrapper(database, this.this$0.getStatementTextForLog());
                connectionWrapper.run(new ConnectionWrapper.SQLRunnable(connectionWrapper){

                    @Override
                    public void run() throws SQLException, DBException {
                        QueryExecutionRunnable.this.doRunImpl();
                    }
                });
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doRunImpl() throws SQLException, DBException {
            try {
                ResultSet resultSet;
                this.this$0.setExecuting(true);
                this.prepareStatement();
                if (this.this$0.m_rs != null) {
                    throw new IllegalStateException("Query already executing");
                }
                final ResultSet resultSet2 = this.this$0.executeQueryImpl(this.m_fetchSize);
                this.this$0.m_rs = resultSet2;
                try {
                    Class<?> clazz = resultSet2.getClass();
                    resultSet = (ResultSet)Proxy.newProxyInstance(clazz.getClassLoader(), DBUtil.getAllInterfaces(clazz), new InvocationHandler(){

                        @Override
                        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                            if (QueryExecutionRunnable.this.this$0.isCancelled() || Thread.currentThread().isInterrupted()) {
                                for (Class<?> clazz : method.getExceptionTypes()) {
                                    if (!SQLException.class.equals(clazz)) continue;
                                    throw new CancelledSQLException();
                                }
                            }
                            try {
                                return method.invoke((Object)resultSet2, objectArray);
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                throw invocationTargetException.getCause();
                            }
                        }
                    });
                }
                catch (Throwable throwable) {
                    this.this$0.getLogger().log(DBLog.getExceptionLogLevel(), throwable.getMessage(), throwable);
                    resultSet = resultSet2;
                }
                this.processResultSet(resultSet);
            }
            finally {
                this.this$0.close();
                this.this$0.setExecuting(false);
            }
        }
    }
}

