/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.internal;

import oracle.javatools.db.DBLog;
import oracle.javatools.db.internal.DBCore;
import oracle.javatools.util.deferred.Thunk;

public class ClassThunk<T>
extends Thunk<T> {
    private final String m_className;
    private final ClassLoader m_classLoader;
    private final Class<T> m_apiClass;
    private final T m_instance;

    public ClassThunk(String string, ClassLoader classLoader, Class<T> clazz) {
        this.m_className = string;
        this.m_classLoader = classLoader;
        this.m_apiClass = clazz;
        this.m_instance = null;
    }

    public ClassThunk(T t) {
        this.m_apiClass = t.getClass();
        this.m_className = this.m_apiClass.getName();
        this.m_classLoader = this.m_apiClass.getClassLoader();
        this.m_instance = t;
    }

    public String getClassName() {
        return this.m_className;
    }

    protected T compute() {
        T t = this.m_instance;
        if (t == null) {
            try {
                ClassLoader classLoader = this.m_classLoader == null ? DBCore.getImplClassLoader() : this.m_classLoader;
                Class<?> clazz = classLoader.loadClass(this.m_className);
                t = this.m_apiClass.cast(clazz.newInstance());
            }
            catch (Exception exception) {
                DBLog.getLogger(this.m_apiClass).log(DBLog.getExceptionLogLevel(), "Cannot create " + this.m_className + " as a " + this.m_apiClass.getSimpleName(), exception);
            }
        }
        return t;
    }
}

