/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.math.BigInteger;
import oracle.javatools.db.AbstractChildBuildableObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Index;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleTablespaceProperties;
import oracle.javatools.db.property.NumberProperty;
import oracle.javatools.db.property.PropertyKey;
import oracle.javatools.db.property.References;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.refactoring.CascadeAction;
import oracle.javatools.util.ModelUtil;

public class OracleStorageProperties
extends AbstractChildBuildableObject {
    public static final String TYPE = "OracleStorageProperties";
    @PropertyKey(value=OracleStorageProperties.class, childOf={Table.class, MaterializedView.class, MaterializedViewLog.class, Index.class, OracleTablespaceProperties.class}, provider=OracleDatabase.class)
    public static final String KEY = "OracleStorageProperties";
    @PropertyKey(value=OracleStorageProperties.class, childOf={MaterializedView.class}, provider=OracleDatabase.class)
    public static final String MV_INDEX_KEY = "MatViewIndexStorageProperties";

    @Override
    public String getType() {
        return "OracleStorageProperties";
    }

    public void setTablespaceID(DBObjectID dBObjectID) {
        this.setProperty("tablespaceID", dBObjectID);
    }

    @References(value=Tablespace.class, cascade=CascadeAction.UPDATE)
    public DBObjectID getTablespaceID() {
        return (DBObjectID)this.getProperty("tablespaceID");
    }

    @Deprecated
    @Transient
    public void setTablespace(String string) {
        ReferenceID referenceID = null;
        if (ModelUtil.hasLength((String)string)) {
            referenceID = new ReferenceID("TABLESPACE", (Schema)null, string);
        }
        this.setTablespaceID(referenceID);
    }

    @Deprecated
    public String getTablespace() {
        DBObjectID dBObjectID = this.getTablespaceID();
        return dBObjectID == null ? null : DBUtil.getDBObjectName(dBObjectID);
    }

    public void setPercentFree(Integer n) {
        this.setProperty("percentFree", n);
    }

    public Integer getPercentFree() {
        return (Integer)this.getProperty("percentFree");
    }

    public void setPercentUsed(Integer n) {
        this.setProperty("percentUsed", n);
    }

    public Integer getPercentUsed() {
        return (Integer)this.getProperty("percentUsed");
    }

    public void setInitrans(Integer n) {
        this.setProperty("initrans", n);
    }

    public Integer getInitrans() {
        return (Integer)this.getProperty("initrans");
    }

    public void setMaxtrans(Integer n) {
        this.setProperty("maxtrans", n);
    }

    public Integer getMaxtrans() {
        return (Integer)this.getProperty("maxtrans");
    }

    public void setInitialExtent(BigInteger bigInteger) {
        this.setProperty("initialExtent", bigInteger);
    }

    @NumberProperty(physicalSize=true)
    public BigInteger getInitialExtent() {
        return (BigInteger)this.getProperty("initialExtent");
    }

    public void setNextExtent(BigInteger bigInteger) {
        this.setProperty("nextExtent", bigInteger);
    }

    @NumberProperty(physicalSize=true)
    public BigInteger getNextExtent() {
        return (BigInteger)this.getProperty("nextExtent");
    }

    public void setMinExtent(BigInteger bigInteger) {
        this.setProperty("minExtent", bigInteger);
    }

    @NumberProperty(physicalSize=true)
    public BigInteger getMinExtent() {
        return (BigInteger)this.getProperty("minExtent");
    }

    public void setMaxExtent(BigInteger bigInteger) {
        this.setProperty("maxExtent", bigInteger);
    }

    @NumberProperty(physicalSize=true, unlimited=true)
    public BigInteger getMaxExtent() {
        return (BigInteger)this.getProperty("maxExtent");
    }

    public void setPercentIncrease(Integer n) {
        this.setProperty("percentIncrease", n);
    }

    public Integer getPercentIncrease() {
        return (Integer)this.getProperty("percentIncrease");
    }

    public void setLogging(Boolean bl) {
        this.setProperty("logging", bl);
    }

    public Boolean getLogging() {
        return (Boolean)this.getProperty("logging");
    }

    public void setFreelists(Integer n) {
        this.setProperty("freelists", n);
    }

    public Integer getFreelists() {
        return (Integer)this.getProperty("freelists");
    }

    public void setFreelistGroups(Integer n) {
        this.setProperty("freelistGroups", n);
    }

    public Integer getFreelistGroups() {
        return (Integer)this.getProperty("freelistGroups");
    }

    public void setBufferMode(BufferModes bufferModes) {
        this.setProperty("bufferMode", (Object)bufferModes);
    }

    public BufferModes getBufferMode() {
        return (BufferModes)((Object)this.getProperty("bufferMode"));
    }

    public static enum BufferModes {
        DEFAULT,
        KEEP,
        RECYCLE;

    }
}

