/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.property.PropertyKey;

public class OracleTableProperties
extends AbstractChildDBObject {
    public static final String TYPE = "OracleTableProperties";
    @PropertyKey(value=OracleTableProperties.class, childOf={Table.class, TablePartition.class}, provider=OracleDatabase.class)
    public static final String KEY = "OracleTableProperties";

    @Override
    public String getType() {
        return "OracleTableProperties";
    }

    public void setTableCompression(OracleTableCompression oracleTableCompression) {
        this.setProperty("tableCompression", (Object)oracleTableCompression);
    }

    public OracleTableCompression getTableCompression() {
        return (OracleTableCompression)((Object)this.getProperty("tableCompression"));
    }

    public void setParallelDegree(Integer n) {
        this.setProperty("parallelDegree", n);
    }

    public Integer getParallelDegree() {
        return (Integer)this.getProperty("parallelDegree");
    }

    public static OracleTableProperties findOrCreateOracleTableProperties(DBObject dBObject) {
        OracleTableProperties oracleTableProperties = (OracleTableProperties)dBObject.getProperty("OracleTableProperties");
        if (oracleTableProperties == null) {
            oracleTableProperties = new OracleTableProperties();
            dBObject.setProperty("OracleTableProperties", oracleTableProperties);
        }
        return oracleTableProperties;
    }

    public static enum OracleTableCompression {
        NOCOMPRESS("NOCOMPRESS"),
        COMPRESS("COMPRESS"),
        ROW_STORE_COMPRESS_ADVANCED("ROW STORE COMPRESS ADVANCED"),
        COMPRESS_FOR_ALL_OPERATIONS("COMPRESS FOR ALL OPERATIONS"),
        COMPRESS_FOR_DIRECT_LOAD_OPERATIONS("COMPRESS FOR DIRECT_LOAD OPERATIONS"),
        COMPRESS_FOR_OLTP("COMPRESS FOR OLTP"),
        COMPRESS_FOR_ARCHIVE_LOW("COMPRESS FOR ARCHIVE LOW"),
        COMPRESS_FOR_ARCHIVE_HIGH("COMPRESS FOR ARCHIVE HIGH"),
        COMPRESS_FOR_QUERY_LOW("COMPRESS FOR QUERY LOW"),
        COMPRESS_FOR_QUERY_HIGH("COMPRESS FOR QUERY HIGH"),
        COLUMN_STORE_COMPRESS_ROW_LEVEL_LOCKING("COLUMN STORE COMPRESS ROW LEVEL LOCKING"),
        COLUMN_STORE_COMPRESS_FOR_ARCHIVE_LOW_ROW_LEVEL_LOCKING("COLUMN STORE COMPRESS FOR ARCHIVE LOW ROW LEVEL LOCKING"),
        COLUMN_STORE_COMPRESS_FOR_ARCHIVE_HIGH_ROW_LEVEL_LOCKING("COLUMN STORE COMPRESS FOR ARCHIVE HIGH ROW LEVEL LOCKING"),
        COLUMN_STORE_COMPRESS_FOR_QUERY_LOW_ROW_LEVEL_LOCKING("COLUMN STORE COMPRESS FOR QUERY LOW ROW LEVEL LOCKING"),
        COLUMN_STORE_COMPRESS_FOR_QUERY_HIGH_ROW_LEVEL_LOCKING("COLUMN STORE COMPRESS FOR QUERY HIGH ROW LEVEL LOCKING");

        private String m_value;

        private OracleTableCompression(String string2) {
            this.m_value = string2;
        }

        public String getValue() {
            return this.m_value;
        }

        public String toString() {
            return this.getValue();
        }

        public static OracleTableCompression migrateFrom(Object object) {
            String string;
            OracleTableCompression oracleTableCompression = null;
            if (object instanceof Boolean) {
                Boolean bl = (Boolean)object;
                if (bl != null) {
                    oracleTableCompression = bl.equals(Boolean.TRUE) ? COMPRESS : NOCOMPRESS;
                }
            } else if (object instanceof String && (string = (String)object) != null) {
                oracleTableCompression = string.toUpperCase().equals(COMPRESS.toString()) ? COMPRESS : NOCOMPRESS;
            }
            return oracleTableCompression;
        }

        public static Boolean convertToBoolean(OracleTableCompression oracleTableCompression) {
            Boolean bl = null;
            if (oracleTableCompression != null) {
                bl = oracleTableCompression == NOCOMPRESS ? Boolean.FALSE : Boolean.TRUE;
            }
            return bl;
        }
    }
}

