/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.ddl;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ddl.DDLType;
import oracle.javatools.db.ora.ddl.OracleStatementType;

public class OracleDDLType
extends DDLType<OracleDDLType> {
    private static Map<OracleStatementType, OracleDDLType> s_types = new HashMap<OracleStatementType, OracleDDLType>();
    private static String[] s_promptActions = new String[]{"CREATE OR REPLACE", "CREATE", "DROP", "ALTER", "UNDELETE"};
    private static final String PROMPT = "PROMPT";
    private static final String PROMPT_SIMPLE = "PROMPT {0} {1} ''{2}''";
    private static final String PROMPT_WITH_PAR = "PROMPT ON ''{3}'' ''{4}''";
    private final OracleStatementType m_type;

    private OracleDDLType(OracleStatementType oracleStatementType) {
        this.m_type = oracleStatementType;
    }

    @Override
    public String getTerminator() {
        return this.m_type.getTerminator();
    }

    @Override
    public Boolean getDependencySortPreference() {
        switch (this.m_type) {
            case DROP: {
                return false;
            }
            case TAB: {
                return true;
            }
        }
        return null;
    }

    @Override
    public boolean ensureUnique() {
        switch (this.m_type) {
            case SPOOLON: 
            case SPOOLOFF: 
            case SET_SQLBLANKLINES_ON: {
                return true;
            }
        }
        return false;
    }

    private String getPromptAction(String string) {
        for (String string2 : s_promptActions) {
            if (!string.trim().toLowerCase().startsWith(string2.toLowerCase())) continue;
            return string2;
        }
        return null;
    }

    @Override
    public String createPrompt(DBObject dBObject, String string) {
        String string2;
        if (!string.trim().startsWith(PROMPT) && (string2 = this.getPromptAction(string)) != null) {
            if (dBObject instanceof SchemaObject) {
                return this.getPrompt(string2, dBObject, null);
            }
            if (dBObject != null) {
                return this.getPrompt(string2, dBObject, DBUtil.getSchemaObject(dBObject));
            }
        }
        return null;
    }

    private String getPrompt(String string, DBObject dBObject, SchemaObject schemaObject) {
        if (schemaObject == null) {
            return MessageFormat.format(PROMPT_SIMPLE, string.toLowerCase(), dBObject.getType().toLowerCase(), dBObject.getName());
        }
        return MessageFormat.format(PROMPT_WITH_PAR, string.toLowerCase(), dBObject.getType().toLowerCase(), dBObject.getName(), schemaObject.getType().toLowerCase(), schemaObject.getName());
    }

    @Override
    public int compareTo(OracleDDLType oracleDDLType) {
        return this.m_type.compareTo(oracleDDLType.m_type);
    }

    public static OracleDDLType getDDLType(String string) {
        return OracleDDLType.getDDLType(OracleStatementType.valueOf(string));
    }

    public static OracleDDLType getDDLType(OracleStatementType oracleStatementType) {
        if (oracleStatementType == null) {
            throw new NullPointerException("must have a valid type");
        }
        OracleDDLType oracleDDLType = s_types.get((Object)oracleStatementType);
        if (oracleDDLType == null) {
            oracleDDLType = new OracleDDLType(oracleStatementType);
            s_types.put(oracleStatementType, oracleDDLType);
        }
        return oracleDDLType;
    }
}

