/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.refactoring;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.CascadeManager;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.refactoring.CascadeAction;
import oracle.javatools.util.ModelUtil;

public abstract class CascadeWorker<T extends DBObject> {
    private final DBObjectProvider m_pro;

    public CascadeWorker(DBObjectProvider dBObjectProvider) {
        this.m_pro = dBObjectProvider;
    }

    protected final DBObjectProvider getProvider() {
        return this.m_pro;
    }

    protected final Logger getLogger() {
        return DBLog.getLogger(this);
    }

    public CascadeAction cascadeDelete(DBObject dBObject, T t) throws DBException {
        if (!(t instanceof SystemObject)) {
            throw new IllegalStateException("shouldn't cascade directly to child objects");
        }
        return this.cascadeDelete(dBObject.getID(), (DBObject)t, t);
    }

    protected final CascadeAction cascadeDelete(DBObjectID dBObjectID, DBObject dBObject, T t) throws DBException {
        CascadeAction cascadeAction = CascadeAction.NONE;
        Map<PropertyInfo, Object> map = this.getProvider().getCascadeManager().findPropertyReferences(dBObject, dBObjectID);
        if (map != null && !map.isEmpty()) {
            for (PropertyInfo propertyInfo : map.keySet()) {
                CancelledException.checkInterrupt();
                CascadeAction cascadeAction2 = this.removeReference(dBObjectID, dBObject, propertyInfo);
                if (cascadeAction2.compareTo(cascadeAction) <= 0) continue;
                cascadeAction = cascadeAction2;
            }
        }
        for (DBObject dBObject2 : dBObject.getOwnedObjects()) {
            CancelledException.checkInterrupt();
            CascadeAction cascadeAction3 = this.cascadeDelete(dBObjectID, dBObject2, t);
            if (cascadeAction3 == CascadeAction.DELETE) {
                dBObject.removeOwnedObject(dBObject2);
                cascadeAction = CascadeAction.UPDATE;
                continue;
            }
            if (cascadeAction3 != CascadeAction.UPDATE) continue;
            cascadeAction = cascadeAction3;
        }
        return cascadeAction;
    }

    protected CascadeAction removeReference(DBObjectID dBObjectID, DBObject dBObject, PropertyInfo propertyInfo) throws DBException {
        CascadeAction cascadeAction = propertyInfo.getCascadeAction();
        if (cascadeAction.compareTo(CascadeAction.NONE) > 0) {
            DBObjectID[] dBObjectIDArray = null;
            Class<?> clazz = propertyInfo.getPropertyClass();
            if (clazz.isArray()) {
                DBObjectID[] dBObjectIDArray2 = (DBObjectID[])propertyInfo.getPropertyValue(dBObject);
                ArrayList<DBObjectID> arrayList = new ArrayList<DBObjectID>();
                for (DBObjectID dBObjectID2 : dBObjectIDArray2) {
                    if (dBObjectID.equals(dBObjectID2, true)) continue;
                    arrayList.add(dBObjectID2);
                }
                int n = arrayList.size();
                DBObjectID[] dBObjectIDArray3 = dBObjectIDArray = n > 0 ? arrayList.toArray(new DBObjectID[n]) : null;
            }
            if (dBObjectIDArray != null || cascadeAction != CascadeAction.DELETE) {
                try {
                    propertyInfo.setPropertyValue(dBObject, dBObjectIDArray);
                    cascadeAction = CascadeAction.UPDATE;
                }
                catch (Exception exception) {
                    this.getLogger().log(DBLog.getExceptionLogLevel(), "Couldn't cascade delete", exception);
                }
            }
        }
        return cascadeAction;
    }

    public CascadeAction cascadeUpdate(Difference difference, T t) throws DBException {
        CascadeAction cascadeAction = CascadeAction.NONE;
        if (!difference.isSame()) {
            for (Difference difference2 : difference.getChildren()) {
                CascadeAction cascadeAction2;
                CancelledException.checkInterrupt();
                if (difference2.isSame() || (cascadeAction2 = this.cascadePropertyChange(difference, difference2.getPropertyName(), difference2.getOriginalObject(), difference2.getUpdatedObject(), t)).compareTo(cascadeAction) <= 0) continue;
                cascadeAction = cascadeAction2;
            }
        }
        return cascadeAction;
    }

    protected CascadeAction cascadePropertyChange(Difference difference, String string, Object object, Object object2, T t) throws DBException {
        CascadeAction cascadeAction = CascadeAction.NONE;
        if ("name".equals(string) || "schema".equals(string)) {
            DBObject dBObject = (DBObject)difference.getOriginalObject();
            DBObject dBObject2 = (DBObject)difference.getUpdatedObject();
            DBObjectID dBObjectID = dBObject.getID();
            DBObjectID dBObjectID2 = dBObject2.getID();
            if (this.replaceReferences((DBObject)t, dBObjectID, dBObject.getName(), dBObject2.getName(), this.getSchemaName(dBObject), this.getSchemaName(dBObject2))) {
                cascadeAction = CascadeAction.UPDATE;
            }
        }
        return cascadeAction;
    }

    private String getSchemaName(DBObject dBObject) {
        Schema schema = DBUtil.getSchema(dBObject);
        return schema == null ? null : schema.getName();
    }

    private boolean replaceReferences(DBObject dBObject, DBObjectID dBObjectID, String string, String string2, String string3, String string4) throws DBException {
        boolean bl = false;
        CascadeManager cascadeManager = this.getProvider().getCascadeManager();
        Map<PropertyInfo, Object> map = cascadeManager.findPropertyReferences(dBObject, dBObjectID);
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                CancelledException.checkInterrupt();
                PropertyInfo propertyInfo = (PropertyInfo)entry.getKey();
                String object = propertyInfo.getPropertyName();
                Object v = entry.getValue();
                boolean bl2 = false;
                BaseObjectID baseObjectID = null;
                if (v instanceof BaseObjectID) {
                    baseObjectID = this.copyAndFixIfNecessary((BaseObjectID)v, dBObjectID.getType(), string, string2, string3, string4);
                    bl2 = baseObjectID != null;
                } else if (v instanceof DBObjectID[]) {
                    DBObjectID[] dBObjectIDArray = (DBObjectID[])v;
                    for (int i = 0; i < dBObjectIDArray.length; ++i) {
                        BaseObjectID baseObjectID2;
                        DBObjectID dBObjectID2 = dBObjectIDArray[i];
                        if (!(dBObjectID2 instanceof BaseObjectID) || (baseObjectID2 = this.copyAndFixIfNecessary((BaseObjectID)dBObjectID2, dBObjectID.getType(), string, string2, string3, string4)) == null) continue;
                        bl2 = true;
                        baseObjectID = v;
                        dBObjectIDArray[i] = baseObjectID2;
                    }
                }
                if (!bl2) continue;
                dBObject.setProperty(object, baseObjectID);
                bl = true;
            }
        }
        for (DBObject dBObject2 : dBObject.getOwnedObjects()) {
            if (!this.replaceReferences(dBObject2, dBObjectID, string, string2, string3, string4)) continue;
            bl = true;
        }
        return bl;
    }

    private BaseObjectID copyAndFixIfNecessary(BaseObjectID baseObjectID, String string, String string2, String string3, String string4, String string5) {
        BaseObjectID baseObjectID2;
        BaseObjectID baseObjectID3 = null;
        if (ModelUtil.areEqual((Object)string, (Object)baseObjectID.getType()) && ModelUtil.areEqual((Object)string2, (Object)baseObjectID.getName()) && (!Metadata.getInstance().isSchemaObject(string) || ModelUtil.areEqual((Object)string4, (Object)baseObjectID.getSchemaName()))) {
            baseObjectID3 = (BaseObjectID)baseObjectID.copyTo(null);
            baseObjectID3.setName(string3);
            baseObjectID3.setSchemaName(string5);
        } else if ("DATABASE LINK".equals(string) && ModelUtil.areEqual((Object)string2, (Object)baseObjectID.getDatabaseName())) {
            baseObjectID3 = (BaseObjectID)baseObjectID.copyTo(null);
            baseObjectID3.setDatabaseName(string3);
        }
        DBObjectID dBObjectID = baseObjectID.getParent();
        if (dBObjectID instanceof BaseObjectID && (baseObjectID2 = this.copyAndFixIfNecessary((BaseObjectID)dBObjectID, string, string2, string3, string4, string5)) != null) {
            dBObjectID = baseObjectID2;
            if (baseObjectID3 == null) {
                baseObjectID3 = (BaseObjectID)baseObjectID.copyTo(null);
            }
        }
        if (baseObjectID3 != null) {
            baseObjectID3.setParent(dBObjectID);
        }
        return baseObjectID3;
    }

    public Set<String> getCascadeProperties() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("name");
        hashSet.add("schema");
        return hashSet;
    }
}

