/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.logging.Level;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.sql.AbstractProviderUsageSQLFragment;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractSchemaObjectUsage
extends AbstractProviderUsageSQLFragment
implements DBObjectUsage {
    public AbstractSchemaObjectUsage() {
    }

    public AbstractSchemaObjectUsage(DBObjectID dBObjectID) {
        this.setObjectID(dBObjectID);
    }

    @Override
    public void setObjectID(DBObjectID dBObjectID) {
        this.setProperty("objectID", dBObjectID);
    }

    @Override
    public DBObjectID getObjectID() {
        return (DBObjectID)this.getProperty("objectID");
    }

    public void setQualified(boolean bl) {
        this.setProperty("qualified", bl);
    }

    public boolean isQualified() {
        return (Boolean)this.getProperty("qualified", false);
    }

    @Override
    public String getSQLText() {
        DBObjectID dBObjectID = this.getObjectID();
        if (dBObjectID != null) {
            Object object;
            String string = null;
            String string2 = null;
            String string3 = null;
            if (dBObjectID instanceof BaseObjectID) {
                string = ((BaseObjectID)dBObjectID).getDatabaseName();
                string2 = ((BaseObjectID)dBObjectID).getSchemaName();
                string3 = ((BaseObjectID)dBObjectID).getName();
            }
            if (!ModelUtil.hasLength(string2) || !ModelUtil.hasLength(string3)) {
                try {
                    object = (SchemaObject)dBObjectID.resolveID();
                    if (object != null) {
                        string3 = object.getName();
                        Schema schema = object.getSchema();
                        if (schema != null) {
                            string2 = schema.getName();
                            if (schema.getID() instanceof BaseObjectID) {
                                string = ((BaseObjectID)schema.getID()).getDatabaseName();
                            }
                        }
                    }
                }
                catch (DBException dBException) {
                    DBLog.getLogger(this).log(Level.WARNING, "Couldn't resolve ID for SQL: " + dBException.getMessage());
                }
            }
            object = new StringBuilder();
            if (this.shouldQualify(string2)) {
                ((StringBuilder)object).append(this.getExternalName(string2, "SCHEMA")).append(".");
            }
            ((StringBuilder)object).append(this.getExternalName(string3, "TABLE"));
            if (ModelUtil.hasLength((String)string)) {
                ((StringBuilder)object).append("@").append(string);
            }
            return ((StringBuilder)object).toString();
        }
        return null;
    }

    private boolean shouldQualify(String string) {
        Schema schema;
        DatabaseDescriptor databaseDescriptor;
        boolean bl = string == null ? false : (this.isQualified() ? true : ((databaseDescriptor = this.getDatabaseDescriptor()) != null && databaseDescriptor.areNamesEqual(string, databaseDescriptor.getPublicSchemaName(), "SCHEMA", false) ? false : (schema = DBUtil.getSchema(this)) != null && !this.areNamesEqual(schema.getName(), string, "SCHEMA", false)));
        return bl;
    }
}

