/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Relation;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.AliasFragment;
import oracle.javatools.db.sql.ArithmeticOperation;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.Function;
import oracle.javatools.db.sql.FunctionUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLFragmentExpressionBuilder;
import oracle.javatools.db.sql.SQLParseException;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.SimpleSQLFragment;
import oracle.javatools.parser.plsql.PlsqlParser;
import oracle.javatools.parser.plsql.data.PlsqlError;
import oracle.javatools.parser.plsql.data.PlsqlNode;
import oracle.javatools.parser.plsql.data.PlsqlRoot;
import oracle.javatools.parser.plsql.data.SqlExpression;
import oracle.javatools.parser.plsql.symtab.SqlColdef;
import oracle.javatools.parser.plsql.symtab.SqlOpndef;
import oracle.javatools.parser.plsql.symtab.SqlOptdef;
import oracle.javatools.parser.plsql.symtab.SqlQbcdef;
import oracle.javatools.parser.plsql.symtab.SqlSeldef;
import oracle.javatools.parser.plsql.symtab.SqlStrdef;
import oracle.javatools.parser.plsql.syntax.SqlDriver;
import oracle.javatools.util.ModelUtil;

public class ParserUtils {
    private static Collection<String> s_literals = Arrays.asList("BINARY_FLOAT_NAN", "BINARY_FLOAT_INFINITY", "BINARY_DOUBLE_NAN", "BINARY_DOUBLE_INFINITY");

    private ParserUtils() {
    }

    public static String getHexToRawString(SQLFragment sQLFragment) {
        String string = null;
        if (sQLFragment instanceof Function && "HEXTORAW".equalsIgnoreCase(((Function)sQLFragment).getFunction())) {
            string = ParserUtils.getString(((Function)sQLFragment).getArguments()[0]);
        }
        return string;
    }

    @Deprecated
    public static String getHexToRawString(PlsqlNode plsqlNode) {
        String string = null;
        if (plsqlNode instanceof SqlOptdef && ((SqlOptdef)plsqlNode).getOperatorType() == 102) {
            string = ParserUtils.getString((PlsqlNode)((SqlOptdef)plsqlNode).getOperands()[0]);
        }
        return string;
    }

    public static String getString(SQLFragment sQLFragment) {
        String string = null;
        if (ParserUtils.isConstant(sQLFragment) && sQLFragment.getSQLText().charAt(0) == '\'') {
            string = sQLFragment.getSQLText();
        }
        return string;
    }

    @Deprecated
    public static String getString(PlsqlNode plsqlNode) {
        String string = null;
        if (ParserUtils.isConstant(plsqlNode) && ((SqlStrdef)plsqlNode).getStringText().charAt(0) == '\'') {
            string = ((SqlStrdef)plsqlNode).getStringText();
        }
        return string;
    }

    public static boolean isAllowedExpression(SQLFragment sQLFragment, Collection<String> collection) {
        boolean bl;
        if (sQLFragment instanceof FunctionUsage) {
            bl = true;
        } else {
            String string = null;
            if (sQLFragment instanceof Function) {
                string = ((Function)sQLFragment).getFunction();
            } else if (sQLFragment instanceof ArithmeticOperation) {
                string = ((ArithmeticOperation)sQLFragment).getOperatorText();
            } else if (sQLFragment instanceof SimpleSQLFragment) {
                string = sQLFragment.getSQLText();
            }
            bl = collection.contains(string);
        }
        return bl;
    }

    @Deprecated
    public static boolean isAllowedExpression(PlsqlNode plsqlNode, Collection collection) {
        return plsqlNode instanceof SqlExpression && collection.contains(new Integer(((SqlExpression)plsqlNode).getOperatorType()));
    }

    @Deprecated
    public static boolean isAllowedStringType(PlsqlNode plsqlNode, Collection collection) {
        return plsqlNode instanceof SqlStrdef && collection.contains(new Integer(((SqlStrdef)plsqlNode).getStringType()));
    }

    public static boolean isConstant(SQLFragment sQLFragment) {
        boolean bl = false;
        if (sQLFragment != null && sQLFragment instanceof SimpleSQLFragment && ModelUtil.hasLength((String)sQLFragment.getSQLText())) {
            String string = sQLFragment.getSQLText().trim().toUpperCase();
            if (string.length() > 1 && (string.startsWith("'") || string.startsWith("N'") || string.startsWith("Q'") || string.startsWith("NQ'")) && string.endsWith("'")) {
                bl = true;
            } else if (string.length() > 0 && string.substring(0, 1).matches("[-+.0-9]")) {
                bl = true;
            } else if (s_literals.contains(string)) {
                bl = true;
            }
        }
        return bl;
    }

    @Deprecated
    public static boolean isConstant(PlsqlNode plsqlNode) {
        return plsqlNode instanceof SqlStrdef && ((SqlStrdef)plsqlNode).getStringType() == 0;
    }

    @Deprecated
    public static boolean isNull(PlsqlNode plsqlNode) {
        return plsqlNode instanceof SqlOpndef && ((SqlOpndef)plsqlNode).getOperandType() == 3 && ((SqlOpndef)plsqlNode).getStringType() == 8;
    }

    @Deprecated
    public static boolean isDbObjectName(PlsqlNode plsqlNode) {
        return plsqlNode instanceof SqlOpndef && (((SqlOpndef)plsqlNode).getOperandType() == 1 || ((SqlOpndef)plsqlNode).getOperandType() == 7);
    }

    public static String getConstant(SQLFragment sQLFragment) {
        return ParserUtils.isConstant(sQLFragment) ? sQLFragment.getSQLText() : null;
    }

    @Deprecated
    public static String getConstant(PlsqlNode plsqlNode) {
        return ParserUtils.isConstant(plsqlNode) ? ((SqlStrdef)plsqlNode).getStringText() : null;
    }

    public static Collection<String[]> getColumnNames(String string, SQLFragmentExpressionBuilder.ExpressionType expressionType, DBObjectProvider dBObjectProvider, Relation relation) throws SQLQueryException {
        SQLFragment sQLFragment = SQLFragmentExpressionBuilder.getExpressionOrFail(dBObjectProvider, relation, expressionType, string);
        return ParserUtils.getColumnNames(sQLFragment);
    }

    public static Collection<String[]> getColumnNames(SQLFragment sQLFragment) {
        HashSet<String[]> hashSet = new HashSet<String[]>();
        DBObject[] dBObjectArray = null;
        if (sQLFragment instanceof SQLQuery) {
            dBObjectArray = ((SQLQuery)sQLFragment).getSelectObjects();
        } else if (sQLFragment != null) {
            dBObjectArray = sQLFragment.getOwnedObjects();
        }
        if (dBObjectArray != null) {
            for (int i = 0; i < dBObjectArray.length; ++i) {
                if (null == dBObjectArray[i] || !(dBObjectArray[i] instanceof SQLFragment)) continue;
                hashSet.addAll(ParserUtils.getColumnNames((SQLFragment)dBObjectArray[i]));
            }
        }
        if (sQLFragment instanceof ColumnUsage) {
            String string;
            DBObject dBObject;
            ColumnUsage columnUsage = (ColumnUsage)sQLFragment;
            ArrayList<String> arrayList = new ArrayList<String>();
            DBObject dBObject2 = columnUsage.getParent();
            DBObject dBObject3 = dBObject = dBObject2 == null ? null : dBObject2.getParent();
            if (dBObject instanceof AliasFragment && ModelUtil.hasLength((String)(string = ((AliasFragment)dBObject).getUsableAlias()))) {
                arrayList.add(string);
            }
            if (dBObject2 instanceof AliasFragment && ModelUtil.hasLength((String)(string = ((AliasFragment)dBObject2).getUsableAlias()))) {
                arrayList.add(string);
            }
            if (ModelUtil.hasLength((String)(string = columnUsage.getColumnName()))) {
                arrayList.add(string);
            } else {
                arrayList.addAll(Arrays.asList(columnUsage.getAttributes()));
            }
            hashSet.add(arrayList.toArray(new String[arrayList.size()]));
        } else if (sQLFragment instanceof SelectObject) {
            SelectObject selectObject = (SelectObject)sQLFragment;
            hashSet.addAll(ParserUtils.getColumnNames(selectObject.getExpression()));
        }
        return hashSet;
    }

    @Deprecated
    public static Collection<String[]> getColumnNames(String string, ExpressionType expressionType) throws SQLQueryException {
        PlsqlRoot plsqlRoot = ParserUtils.parseQueryString(string, ParserUtils.getSqlDriverType(expressionType));
        ParserUtils.checkErrors(plsqlRoot, string);
        PlsqlNode[] plsqlNodeArray = plsqlRoot.getUnits();
        if (plsqlNodeArray.length != 1 || !(plsqlNodeArray[0] instanceof SqlExpression)) {
            DBLog.getLogger(ParserUtils.class).warning("SQL parser failure. Returned " + plsqlNodeArray.length + " PlsqlNode. Expecting 1 SqlExpression");
            return new HashSet<String[]>();
        }
        return ParserUtils.getColumnNames((SqlExpression)plsqlNodeArray[0]);
    }

    @Deprecated
    public static Collection<String[]> getColumnNames(SqlExpression sqlExpression) {
        SqlQbcdef sqlQbcdef;
        HashSet<String[]> hashSet = new HashSet<String[]>();
        SqlExpression[] sqlExpressionArray = sqlExpression.getOperands();
        if (sqlExpression instanceof SqlQbcdef) {
            sqlQbcdef = (SqlQbcdef)sqlExpression;
            sqlExpressionArray = sqlQbcdef.qbcsel;
        }
        if (sqlExpressionArray != null) {
            for (int i = 0; i < sqlExpressionArray.length; ++i) {
                if (null == sqlExpressionArray[i]) continue;
                hashSet.addAll(ParserUtils.getColumnNames(sqlExpressionArray[i]));
            }
        }
        if (sqlExpression instanceof SqlColdef) {
            sqlQbcdef = (SqlColdef)sqlExpression;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (ModelUtil.hasLength((String)sqlQbcdef.getColumnUserName())) {
                arrayList.add(sqlQbcdef.getColumnUserName());
            }
            if (ModelUtil.hasLength((String)sqlQbcdef.getColumnTableName())) {
                arrayList.add(sqlQbcdef.getColumnTableName());
            }
            if (ModelUtil.hasLength((String)sqlQbcdef.getColumnBaseName())) {
                arrayList.add(sqlQbcdef.getColumnBaseName());
            } else {
                arrayList.addAll(Arrays.asList(sqlQbcdef.getColumnAndAttributes()));
            }
            hashSet.add(arrayList.toArray(new String[arrayList.size()]));
        } else if (sqlExpression instanceof SqlSeldef) {
            sqlQbcdef = (SqlSeldef)sqlExpression;
            hashSet.addAll(ParserUtils.getColumnNames((SqlExpression)sqlQbcdef.getSelopn()));
        }
        return hashSet;
    }

    @Deprecated
    public static void checkErrors(PlsqlRoot plsqlRoot, String string) throws SQLQueryException {
        PlsqlError[] plsqlErrorArray = plsqlRoot.getErrors();
        SQLParseException.ParseError[] parseErrorArray = new SQLParseException.ParseError[plsqlErrorArray.length];
        for (int i = 0; i < plsqlErrorArray.length; ++i) {
            parseErrorArray[i] = new SQLParseException.ParseError(plsqlErrorArray[i].getStartOffset(), plsqlErrorArray[i].getErrorMessage());
        }
        if (plsqlErrorArray != null && plsqlErrorArray.length > 0) {
            throw new SQLParseException(parseErrorArray, string);
        }
    }

    @Deprecated
    public static PlsqlRoot parseQueryString(String string, int n) throws SQLQueryException {
        try {
            ReadTextBuffer readTextBuffer = TextBufferFactory.createReadTextBuffer((String)string);
            PlsqlParser.ParsingOptions parsingOptions = new PlsqlParser.ParsingOptions();
            parsingOptions.inputType = 16;
            SqlDriver sqlDriver = new SqlDriver();
            sqlDriver.setTextBuffer(readTextBuffer);
            return sqlDriver.qcpidrv(n);
        }
        catch (Exception exception) {
            throw new SQLQueryException(APIBundle.format("SQL_UNKNOWN_ERR", exception.getMessage()));
        }
    }

    @Deprecated
    private static final int getSqlDriverType(ExpressionType expressionType) {
        switch (expressionType) {
            case BOOLEAN: {
                return 1;
            }
            case ARITHMETIC: {
                return 2;
            }
            case SELECT_LIST: {
                return 3;
            }
        }
        return 0;
    }

    public static enum ExpressionType {
        BOOLEAN,
        ARITHMETIC,
        SELECT_LIST,
        SQL_STATEMENT;

    }
}

