/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.InvalidSQLException;

public class SQLParseException
extends InvalidSQLException {
    protected final String NEWLINE = "\n";
    protected final String SPACE = " ";
    protected final String INDICATOR = APIBundle.get("SQL_PARSE_ERROR_INDICATOR");
    private String m_message;
    private ParseError[] m_errors;

    public SQLParseException(ParseError[] parseErrorArray) {
        this(parseErrorArray, null);
    }

    public SQLParseException(ParseError[] parseErrorArray, String string) {
        super(string, (String)null);
        this.m_errors = parseErrorArray;
    }

    private String createMessage(String string, int n) {
        String string2 = null;
        if (this.m_errors != null && this.m_errors.length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(APIBundle.get("SQL_PARSE_ERR"));
            for (int i = 0; i < this.m_errors.length; ++i) {
                CharSequence charSequence;
                String string3;
                String string4;
                int n2 = this.m_errors[i].getOffset();
                stringBuilder.append("\n");
                if (string == null || n == 0) {
                    string4 = this.m_errors[i].getMessage();
                    string3 = this.getSQL();
                } else {
                    charSequence = this.m_errors[i].getSuggestions();
                    string4 = APIBundle.format("SQL_FRAGMENT_ERR", n2 -= n, charSequence);
                    string3 = string;
                }
                if (string3 != null) {
                    int n3;
                    boolean bl;
                    stringBuilder.append(APIBundle.format("SQL_PARSE_ERROR_DESC", string4));
                    stringBuilder.append("\n");
                    charSequence = new StringBuilder(string3);
                    boolean bl2 = bl = n2 >= string3.length();
                    if (bl) {
                        ((StringBuilder)charSequence).append(this.INDICATOR);
                    } else {
                        ((StringBuilder)charSequence).insert(n2, this.INDICATOR);
                    }
                    int n4 = bl ? string3.length() - 1 : n2;
                    int n5 = string3.lastIndexOf("\n", n4);
                    if (n5 < 0) {
                        n5 = 0;
                    }
                    if ((n3 = string3.indexOf("\n", n4)) < 0) {
                        n3 = string3.length();
                    }
                    stringBuilder.append(((StringBuilder)charSequence).substring(n5, n3 += this.INDICATOR.length()).trim());
                    continue;
                }
                stringBuilder.append(string4);
            }
            string2 = stringBuilder.toString();
        }
        return string2;
    }

    public String getFragmentMessage(String string, int n) {
        String string2 = this.createMessage(string, n);
        return string2;
    }

    @Override
    public String getMessage() {
        if (this.m_message == null) {
            this.m_message = this.createMessage(null, 0);
        }
        return this.m_message;
    }

    @Override
    public Integer getOffset() {
        Integer n = null;
        if (this.m_errors != null && this.m_errors.length > 0 && this.m_errors[0] != null) {
            n = this.m_errors[0].getOffset();
        }
        return n;
    }

    public void adjustOffset(int n) {
        if (this.m_errors != null && this.m_errors.length > 0) {
            for (ParseError parseError : this.m_errors) {
                if (parseError == null || parseError.m_offset < n) continue;
                ParseError parseError2 = parseError;
                parseError2.m_offset = parseError2.m_offset - n;
            }
        }
    }

    public static class ParseError {
        private int m_offset;
        private final String m_message;
        private final String m_suggestions;

        public ParseError(int n, String string, String string2) {
            this.m_suggestions = string2;
            this.m_offset = n;
            this.m_message = string;
        }

        public ParseError(int n, String string) {
            this(n, string, "");
        }

        public int getOffset() {
            return this.m_offset;
        }

        public String getMessage() {
            return this.m_message;
        }

        public String getSuggestions() {
            return this.m_suggestions;
        }
    }
}

