/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Arrays;
import java.util.Collection;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.property.Derived;
import oracle.javatools.db.property.Internal;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.TextProperty;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.GroupByObject;
import oracle.javatools.db.sql.HierarchicalQueryObject;
import oracle.javatools.db.sql.ModelObject;
import oracle.javatools.db.sql.Operation;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.SetOperator;
import oracle.javatools.db.sql.WhereObject;
import oracle.javatools.util.ModelUtil;

public class SQLQuery
extends AbstractSQLFragment {
    public static final String TYPE = "SQLQuery";
    public static final String SQL_TEMPLATE = "SELECT \n    \nFROM \n    \n";
    private static final String WITH = "WITH";

    public SQLQuery() {
        this(null);
    }

    public SQLQuery(String string) {
        this.setQueryString(string);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    protected void processPropertyChange(DBObjectChange dBObjectChange) {
        super.processPropertyChange(dBObjectChange);
        Collection<String> collection = dBObjectChange.getAllChangedProperties();
        if (!collection.contains("queryString") && !collection.contains("declarative")) {
            for (String string : collection) {
                PropertyInfo propertyInfo = PropertyHelper.findPropertyInfo(this.getClass(), string, (DBObjectProvider)null);
                if (propertyInfo == null || !propertyInfo.isDerived() || !"queryString".equals(propertyInfo.getDerivedSourceProperty())) continue;
                this.setDeclarative(true);
                this.setQueryString(null);
                break;
            }
        }
    }

    @Internal
    public boolean isDeclarative() {
        return (Boolean)this.getProperty("declarative", false);
    }

    public void setDeclarative(boolean bl) {
        this.setProperty("declarative", bl);
    }

    @TextProperty(multiLine=true)
    public String getQueryString() {
        String string = (String)this.getProperty("queryString");
        if (!ModelUtil.hasLength((String)string) && this.isDeclarative()) {
            string = this.constructQueryText();
        }
        return string;
    }

    public void setQueryString(String string) {
        this.setProperty("queryString", string);
    }

    @Deprecated
    protected void clearQueryString() {
    }

    @Derived(value="queryString")
    public SelectObject[] getSelectObjects() {
        return this.getChildSupport("selectObjects").getChildArray(SelectObject.class);
    }

    @Transient
    public void setSelectObjects(SelectObject[] selectObjectArray) {
        this.getChildSupport("selectObjects").setChildArray(selectObjectArray);
    }

    public void addSelectObject(SelectObject selectObject) {
        this.getChildSupport("selectObjects").addChild(selectObject);
    }

    public void addSelectObject(int n, SelectObject selectObject) {
        this.getChildSupport("selectObjects").addChild(n, selectObject);
    }

    public boolean removeSelectObject(SelectObject selectObject) {
        return this.getChildSupport("selectObjects").removeChild(selectObject);
    }

    public void moveSelectObject(SelectObject selectObject, int n) {
        this.getChildSupport("selectObjects").moveChild(selectObject, n);
    }

    public int indexOf(SelectObject selectObject) {
        return this.getChildSupport("selectObjects").indexOfChild(selectObject);
    }

    @Derived(value="queryString")
    public FromObject[] getFromObjects() {
        return this.getChildSupport("fromObjects").getChildArray(FromObject.class);
    }

    @Transient
    public void setFromObjects(FromObject[] fromObjectArray) {
        this.getChildSupport("fromObjects").setChildArray(fromObjectArray);
    }

    public void addFromObject(FromObject fromObject) {
        this.getChildSupport("fromObjects").addChild(fromObject);
    }

    public void addFromObject(int n, FromObject fromObject) {
        this.getChildSupport("fromObjects").addChild(n, fromObject);
    }

    public boolean removeFromObject(FromObject fromObject) {
        return this.getChildSupport("fromObjects").removeChild(fromObject);
    }

    public void moveFromObject(FromObject fromObject, int n) {
        this.getChildSupport("fromObjects").moveChild(fromObject, n);
    }

    public int indexOf(FromObject fromObject) {
        return this.getChildSupport("fromObjects").indexOfChild(fromObject);
    }

    @Derived(value="queryString")
    public OrderByObject[] getOrderByObjects() {
        return this.getChildSupport("orderByObjects").getChildArray(OrderByObject.class);
    }

    @Transient
    public void setOrderByObjects(OrderByObject[] orderByObjectArray) {
        this.getChildSupport("orderByObjects").setChildArray(orderByObjectArray);
    }

    public void addOrderByObject(OrderByObject orderByObject) {
        this.getChildSupport("orderByObjects").addChild(orderByObject);
    }

    public void addOrderByObject(int n, OrderByObject orderByObject) {
        this.getChildSupport("orderByObjects").addChild(n, orderByObject);
    }

    public boolean removeOrderByObject(OrderByObject orderByObject) {
        return this.getChildSupport("orderByObjects").removeChild(orderByObject);
    }

    public void moveOrderByObject(OrderByObject orderByObject, int n) {
        this.getChildSupport("orderByObjects").moveChild(orderByObject, n);
    }

    public int indexOf(OrderByObject orderByObject) {
        return this.getChildSupport("orderByObjects").indexOfChild(orderByObject);
    }

    @Transient
    public void setWhereObject(WhereObject whereObject) {
        this.setProperty("whereObject", whereObject);
    }

    @Derived(value="queryString")
    public WhereObject getWhereObject() {
        return (WhereObject)this.getProperty("whereObject");
    }

    @Transient
    public void setSetOperator(SetOperator setOperator) {
        this.setProperty("setOperator", setOperator);
    }

    @Derived(value="queryString")
    public SetOperator getSetOperator() {
        return (SetOperator)this.getProperty("setOperator");
    }

    @Transient
    public void setHierarchicalQueryObject(HierarchicalQueryObject hierarchicalQueryObject) {
        this.setProperty("hierarchicalQueryObject", hierarchicalQueryObject);
    }

    @Derived(value="queryString")
    public HierarchicalQueryObject getHierarchicalQueryObject() {
        return (HierarchicalQueryObject)this.getProperty("hierarchicalQueryObject");
    }

    @Transient
    public void setGroupByObject(GroupByObject groupByObject) {
        this.setProperty("groupByObject", groupByObject);
    }

    @Derived(value="queryString")
    public GroupByObject getGroupByObject() {
        return (GroupByObject)this.getProperty("groupByObject");
    }

    @Transient
    public void setModelObject(ModelObject modelObject) {
        this.setProperty("modelObject", modelObject);
    }

    @Derived(value="queryString")
    public ModelObject getModelObject() {
        return (ModelObject)this.getProperty("modelObject");
    }

    @Transient
    public void setDistinct(boolean bl) {
        this.setProperty("distinct", bl);
    }

    @Derived(value="queryString")
    public boolean isDistinct() {
        return (Boolean)this.getProperty("distinct", false);
    }

    @Transient
    public void setOrderSiblings(boolean bl) {
        this.setProperty("orderSiblings", bl);
    }

    @Derived(value="queryString")
    public boolean isOrderSiblings() {
        return (Boolean)this.getProperty("orderSiblings", false);
    }

    @Transient
    public void setDistinctSource(String string) {
        this.setProperty("distinctSource", string);
    }

    @Derived(value="queryString")
    public String getDistinctSource() {
        return (String)this.getProperty("distinctSource");
    }

    @Override
    public String getSQLText() {
        return this.getQueryString();
    }

    private void terminatePreviousLine(StringBuilder stringBuilder) {
        int n = stringBuilder.length();
        if (n > 0 && !"\n".equals(Character.valueOf(stringBuilder.charAt(n - 1)))) {
            stringBuilder.append(" ").append("\n");
        }
    }

    private String constructQueryText() {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        SetOperator setOperator = this.getSetOperator();
        if (setOperator == null) {
            ModelObject modelObject;
            GroupByObject groupByObject;
            HierarchicalQueryObject hierarchicalQueryObject;
            this.appendSelectSQL(stringBuilder);
            this.appendFromSQL(stringBuilder);
            object = this.getWhereObject();
            if (object != null) {
                this.terminatePreviousLine(stringBuilder);
                stringBuilder.append("WHERE").append(" ").append("\n");
                this.appendToBuffer(stringBuilder, ((Operation)object).getSQLText(), "    ");
            }
            if ((hierarchicalQueryObject = this.getHierarchicalQueryObject()) != null) {
                this.terminatePreviousLine(stringBuilder);
                stringBuilder.append(hierarchicalQueryObject.getSQLText());
            }
            if ((groupByObject = this.getGroupByObject()) != null) {
                this.terminatePreviousLine(stringBuilder);
                stringBuilder.append(groupByObject.getSQLText());
            }
            if ((modelObject = this.getModelObject()) != null) {
                this.terminatePreviousLine(stringBuilder);
                stringBuilder.append(modelObject.getSQLText());
            }
        } else {
            stringBuilder.append(setOperator.getSQLText());
        }
        object = this.getOrderByObjects();
        if (object != null && ((OrderByObject[])object).length > 0) {
            this.terminatePreviousLine(stringBuilder);
            stringBuilder.append(this.isOrderSiblings() ? "ORDER SIBLINGS BY" : "ORDER BY").append(" ").append("\n");
            this.appendToBuffer(stringBuilder, Arrays.asList(object), "    ");
        }
        return stringBuilder.toString();
    }

    protected void appendSelectSQL(StringBuilder stringBuilder) {
        boolean bl = true;
        for (FromObject fromObject : this.getFromObjects()) {
            if (!fromObject.isWith()) continue;
            if (bl) {
                stringBuilder.append(WITH);
                bl = false;
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append("\n");
            this.appendToBuffer(stringBuilder, fromObject.getSQLText(), "    ");
        }
        if (!bl) {
            stringBuilder.append("\n");
        }
        stringBuilder.append("SELECT").append(" ");
        String string = this.getDistinctSource();
        if (ModelUtil.hasLength((String)string)) {
            stringBuilder.append(string).append(" ");
        }
        stringBuilder.append("\n");
        SelectObject[] selectObjectArray = this.getSelectObjects();
        if (selectObjectArray.length > 0) {
            this.appendToBuffer(stringBuilder, Arrays.asList(selectObjectArray), "    ");
            stringBuilder.append(" ");
        } else {
            stringBuilder.append("    ");
        }
        stringBuilder.append("\n");
    }

    protected void appendFromSQL(StringBuilder stringBuilder) {
        stringBuilder.append("FROM");
        boolean bl = true;
        for (FromObject fromObject : this.getFromObjects()) {
            if (fromObject.isWith()) continue;
            if (!bl) {
                stringBuilder.append(",");
            }
            bl = false;
            stringBuilder.append(" ").append("\n");
            this.appendToBuffer(stringBuilder, fromObject.getSQLText(), "    ");
        }
        if (bl) {
            stringBuilder.append(" ").append("\n");
            stringBuilder.append("    ").append("\n");
        }
    }
}

