/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.javatools.db.DBObject;

public class SynchronizedBuildCache<T extends DBObject> {
    private final Collection<ObjectHolder> m_objects = new ArrayList<ObjectHolder>();
    private final Collection<BuildCacheListener<T>> m_listeners = new CopyOnWriteArrayList<BuildCacheListener<T>>();

    public boolean addBuildCacheListener(BuildCacheListener<T> buildCacheListener) {
        if (buildCacheListener != null) {
            return this.m_listeners.add(buildCacheListener);
        }
        return false;
    }

    public boolean removeBuildCacheListener(BuildCacheListener<T> buildCacheListener) {
        if (buildCacheListener != null) {
            return this.m_listeners.remove(buildCacheListener);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(T t) throws InterruptedException {
        boolean bl = false;
        if (t != null) {
            Collection<ObjectHolder> collection = this.m_objects;
            synchronized (collection) {
                long l = Thread.currentThread().getId();
                ObjectHolder objectHolder = new ObjectHolder(this, l, (DBObject)t);
                if (!this.currentThreadHoldsLock(objectHolder)) {
                    while (this.m_objects.contains(objectHolder)) {
                        this.fireWaiting(t);
                        this.m_objects.wait();
                    }
                    this.fireAdding(t);
                    bl = this.m_objects.add(objectHolder);
                } else {
                    this.fireAlreadyLocked(t);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(T t) {
        boolean bl = false;
        if (t != null) {
            Collection<ObjectHolder> collection = this.m_objects;
            synchronized (collection) {
                long l = Thread.currentThread().getId();
                bl = this.m_objects.remove(new ObjectHolder(this, l, (DBObject)t));
                this.fireRemoved(t);
                this.m_objects.notifyAll();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(T t) {
        boolean bl = false;
        if (t != null) {
            Collection<ObjectHolder> collection = this.m_objects;
            synchronized (collection) {
                for (ObjectHolder objectHolder : this.m_objects) {
                    if (objectHolder.m_payload != t) continue;
                    bl = true;
                    break;
                }
            }
        }
        return bl;
    }

    private boolean currentThreadHoldsLock(ObjectHolder objectHolder) {
        boolean bl = false;
        for (ObjectHolder objectHolder2 : this.m_objects) {
            if (objectHolder2.m_threadId != objectHolder.m_threadId || objectHolder2.m_payload != objectHolder.m_payload) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void fireWaiting(T t) {
        for (BuildCacheListener<T> buildCacheListener : this.m_listeners) {
            buildCacheListener.waiting(Thread.currentThread().getName(), t);
        }
    }

    private void fireAdding(T t) {
        for (BuildCacheListener<T> buildCacheListener : this.m_listeners) {
            buildCacheListener.addToCache(Thread.currentThread().getName(), t);
        }
    }

    private void fireAlreadyLocked(T t) {
        for (BuildCacheListener<T> buildCacheListener : this.m_listeners) {
            buildCacheListener.alreadyLocked(Thread.currentThread().getName(), t);
        }
    }

    private void fireRemoved(T t) {
        for (BuildCacheListener<T> buildCacheListener : this.m_listeners) {
            buildCacheListener.removeFromCache(Thread.currentThread().getName(), t);
        }
    }

    public static interface BuildCacheListener<C extends DBObject> {
        public void addToCache(String var1, C var2);

        public void removeFromCache(String var1, C var2);

        public void waiting(String var1, C var2);

        public void alreadyLocked(String var1, C var2);
    }

    private final class ObjectHolder {
        private final long m_threadId;
        private final T m_payload;
        final /* synthetic */ SynchronizedBuildCache this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private ObjectHolder(long l2, T t) {
            void var2_-1;
            this.this$0 = (SynchronizedBuildCache)l;
            this.m_threadId = var2_-1;
            this.m_payload = l2;
            if (this.m_payload == null) {
                throw new NullPointerException("ObjectHolder must hold an object");
            }
        }

        public boolean equals(Object object) {
            if (object instanceof ObjectHolder) {
                return ((ObjectHolder)object).m_payload == this.m_payload;
            }
            return false;
        }

        public int hashCode() {
            return this.m_payload.hashCode();
        }
    }
}

