/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.addin.wizard;

import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLStringFormatter {
    public static String processElement(Element e) {
        StringBuffer b = new StringBuffer();
        XMLStringFormatter.processElement(e, b);
        return b.toString();
    }

    public static void processElement(Element e, StringBuffer b) {
        XMLStringFormatter.processElement(e, b, 0, true);
    }

    public static void processElement(Element e, StringBuffer b, int depth, boolean addNewLines) {
        String elemName = e.getLocalName();
        if (addNewLines) {
            b.append("\n");
        }
        XMLStringFormatter._addIndent(depth, b);
        b.append("<");
        b.append(elemName);
        NamedNodeMap attrs = e.getAttributes();
        boolean hasAttrs = false;
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr a = (Attr)attrs.item(i);
            hasAttrs = true;
            b.append(" ");
            String prefix = a.getPrefix();
            if (prefix != null && !"".equals(prefix)) {
                b.append(prefix);
                b.append(":");
            }
            b.append(a.getLocalName());
            b.append("=\"");
            b.append(a.getNodeValue());
            b.append("\"");
        }
        b.append(">\n");
        for (Node n = e.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            XMLStringFormatter.processElement((Element)n, b, depth + 1, false);
        }
        XMLStringFormatter._addIndent(depth, b);
        b.append("</");
        b.append(elemName);
        b.append(">");
        if (!addNewLines) {
            b.append("\n");
        }
    }

    private static void _addIndent(int depth, StringBuffer b) {
        for (int i = 0; i < depth; ++i) {
            b.append("  ");
        }
    }
}

