/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.ceditor;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.jdev.ceditor.JDevXmlCodeEditorGui;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.task.NonDomMutationTransactionTask;
import oracle.bali.xml.util.XmlModelUtils;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorViewSelectionSetter;
import oracle.ide.ceditor.CursorListener;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.editor.BasicEditorPane;
import org.w3c.dom.Document;

class CodeEditorSelectionListener
implements CursorListener,
ActionListener {
    private CodeEditor _editor;
    private org.w3c.dom.Node _currentNode;
    private CodeEditorViewSelectionSetter _selectionSetter;
    private final JDevXmlCodeEditorGui _gui;
    private final ReadWriteLock _ideNodeLock;
    private final Timer _timer;
    private static final Logger _LOGGER = Logger.getLogger(CodeEditorSelectionListener.class.getName());
    private static final int _TIMER_DELAY = 575;

    public CodeEditorSelectionListener(JDevXmlCodeEditorGui gui) {
        this._gui = gui;
        JDevXmlContext xmlContext = (JDevXmlContext)this._gui.getGuiContext();
        XMLSourceNode xmlSourceNode = xmlContext.getIdeDocument();
        try {
            Method nodeLockMethod = Node.class.getDeclaredMethod("nodeLock", new Class[0]);
            nodeLockMethod.setAccessible(true);
            this._ideNodeLock = (ReadWriteLock)nodeLockMethod.invoke((Object)xmlSourceNode, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected exception while obtaining node lock (see chained exception)", e);
        }
        this._timer = new Timer(575, this);
        this._timer.setRepeats(false);
    }

    public void cursorUpdate(CodeEditor editor) {
        this._editor = editor;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean reschedule = CodeEditorSelectionListener.this._considerSynchronizingSelectionNow();
                if (reschedule) {
                    CodeEditorSelectionListener.this._timer.restart();
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean reschedule = this._considerSynchronizingSelectionNow();
        if (reschedule) {
            this._timer.restart();
        }
    }

    void __attachToEditor(CodeEditor editor, CodeEditorViewSelectionSetter setter) {
        if (editor != null) {
            editor.addCursorListener((CursorListener)this, true);
            this._selectionSetter = setter;
        }
    }

    void __detachFromEditor(CodeEditor editor) {
        if (editor != null) {
            editor.removeCursorListener((CursorListener)this);
            if (this._timer.isRunning()) {
                this._timer.stop();
            }
            this._selectionSetter = null;
            this._currentNode = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _considerSynchronizingSelectionNow() {
        boolean reschedule = false;
        boolean changedSelection = false;
        JDevXmlContext xmlContext = this._getContext();
        XmlModel xmlModel = xmlContext.getModel();
        DomModel domModel = xmlModel.getDomModel();
        if (domModel.getLockStatus() == 0 && this._isCodeGuiActive() && this._hasFocus(this._editor)) {
            if (!domModel.needsReparse()) {
                boolean gotLock = this._ideNodeLock.tryWriteLock();
                if (gotLock) {
                    try {
                        changedSelection = true;
                        this._synchronizeSelectionNow(xmlContext, xmlModel, domModel, this._editor);
                    }
                    finally {
                        this._ideNodeLock.writeUnlock();
                    }
                } else {
                    reschedule = true;
                }
            } else {
                reschedule = true;
            }
        }
        if (changedSelection) {
            CodeEditorViewSelectionSetter setter;
            if (this._currentNode != null && (setter = this._selectionSetter) != null) {
                setter.setSelection(new Element[]{this._getContext().createSelectionProxyElement()});
            }
        } else {
            _LOGGER.log(Level.FINER, "XML Code Editor Selection Synchronization Skipped.  Rescheduled=({0})", new Object[]{reschedule});
        }
        return reschedule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _synchronizeSelectionNow(JDevXmlContext xmlContext, final XmlModel xmlModel, final DomModel domModel, final CodeEditor editor) {
        _LOGGER.log(Level.FINER, "About to sync selection for {0}", (Object)xmlContext);
        Boolean ok = Boolean.FALSE;
        try {
            new NonDomMutationTransactionTask(){

                protected void performTask(AbstractModel ignored) {
                    org.w3c.dom.Node nodeAtPos = null;
                    int caret = editor.getCaretPosition();
                    if (caret >= 0) {
                        nodeAtPos = domModel.getNodeAtOffset(caret);
                    }
                    CodeEditorSelectionListener._log(caret, nodeAtPos, (AbstractModel)xmlModel);
                    nodeAtPos = CodeEditorSelectionListener._checkNodeDocument(xmlModel, nodeAtPos, caret);
                    if (nodeAtPos != null) {
                        xmlModel.getSelection().set(nodeAtPos);
                        CodeEditorSelectionListener.this._currentNode = nodeAtPos;
                    }
                }

                protected Logger getLogger(AbstractModel model) {
                    return _LOGGER;
                }
            }.run((AbstractModel)xmlModel);
            ok = Boolean.TRUE;
        }
        finally {
            _LOGGER.log(Level.FINER, "Sync done; ok={0}", ok);
        }
    }

    private boolean _isCodeGuiActive() {
        return this._getContext().getActiveGui() == this._gui;
    }

    private boolean _hasFocus(CodeEditor editor) {
        Window window;
        BasicEditorPane pane = editor.getFocusedEditorPane();
        if (pane != null && (window = SwingUtilities.getWindowAncestor((Component)pane)) != null) {
            boolean ok = window.isFocused() && pane.isFocusOwner();
            return ok;
        }
        return false;
    }

    private static org.w3c.dom.Node _checkNodeDocument(XmlModel baseModel, org.w3c.dom.Node nodeAtPos, int caret) {
        if (nodeAtPos != null) {
            Document baseModelDoc = baseModel.getDocument();
            Document nodeDoc = DomUtils.getOwnerDocument((org.w3c.dom.Node)nodeAtPos);
            if (nodeDoc != baseModelDoc) {
                _LOGGER.log(Level.WARNING, "nodeAtPos is not in the document! node={0} nodeDoc={1} baseModelDoc={2} caret={3}", new Object[]{XmlModelUtils.getDisplayName((AbstractModel)baseModel, (org.w3c.dom.Node)nodeAtPos), nodeDoc, baseModelDoc, new Integer(caret)});
                return null;
            }
        }
        return nodeAtPos;
    }

    private static void _log(int caret, org.w3c.dom.Node nodeAtPos, AbstractModel model) {
        _LOGGER.log(Level.FINER, "Sync: caret={0} node={1}", new Object[]{new Integer(caret), XmlModelUtils.getDisplayName((AbstractModel)model, (org.w3c.dom.Node)nodeAtPos)});
    }

    private JDevXmlContext _getContext() {
        return (JDevXmlContext)this._gui.getGuiContext();
    }
}

