/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.overviewEditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.xml.gui.jdev.StandardAsynchronousXmlVisualEditor;
import oracle.bali.xml.gui.jdev.XmlController;
import oracle.bali.xml.gui.jdev.XmlEditorController;
import oracle.bali.xml.gui.jdev.overviewEditor.OverviewEditorBundle;
import oracle.bali.xml.gui.jdev.overviewEditor.OverviewEditorPanel;
import oracle.bali.xml.model.XmlUsage;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.javatools.icons.OracleIcons;

public abstract class AbstractOverviewEditor
extends StandardAsynchronousXmlVisualEditor {
    public static final XmlUsage OVERVIEW_EDITOR_USAGE = new XmlUsage("OVERVIEW_EDITOR");
    private Toolbar _toolbar;

    public AbstractOverviewEditor() {
        super(OVERVIEW_EDITOR_USAGE);
    }

    @Override
    public HelpInfo getHelpInfo() {
        String topic;
        Component component = this.getGUI();
        if (component instanceof OverviewEditorPanel ? (topic = ((OverviewEditorPanel)component).getHelpTopicId()) == null : (topic = HelpUtils.getHelpID((Component)component)) == null) {
            return super.getHelpInfo();
        }
        return new HelpInfo(topic);
    }

    public Component getFixedTopMargin() {
        return this.getToolbar();
    }

    @Override
    public void closeImpl(boolean contentAvailable) {
        this._toolbar = null;
    }

    public Toolbar getToolbar() {
        if (this._toolbar != null) {
            return this._toolbar;
        }
        this._toolbar = new Toolbar();
        AbstractAction a = new AbstractAction("", OracleIcons.getIcon((String)"help.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpSystem.getHelpSystem().showHelp(AbstractOverviewEditor.this.getHelpInfo());
            }
        };
        a.putValue("ShortDescription", OverviewEditorBundle.get("HELP"));
        this._toolbar.setLayout((LayoutManager)new BorderLayout());
        this._toolbar.add((Component)new JButton(a), (Object)"East");
        return this._toolbar;
    }

    static {
        XmlController.registerXmlController(new XmlEditorController(OVERVIEW_EDITOR_USAGE), EditorManager.getEditorManager().getContextMenu());
    }
}

