/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.xml;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.service.HasSuppressionName;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdeveloper.audit.transform.TransformAdapter;
import oracle.jdeveloper.audit.xml.XmlModelAdapter;
import oracle.jdeveloper.audit.xml.XmlTransformAdapter;
import oracle.jdeveloper.audit.xml.XmlTransformContext;
import oracle.jdevimpl.audit.xml.XmlSuppressionAnalyzer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class CreateSuppressInstructionTransform
extends Transform
implements HasSuppressionName {
    private String suppressionName;
    private static final String TARGET = "audit";
    private static final String DIRECTIVE = "suppress";
    private static final String ID = "id";

    public CreateSuppressInstructionTransform() {
        super((TransformAdapter)new XmlTransformAdapter());
    }

    public String getSuppressionName() {
        return this.suppressionName;
    }

    public void setSuppressionName(String name) {
        this.suppressionName = name;
    }

    public boolean isApplicable(XmlTransformContext context, Node construct) {
        switch (construct.getNodeType()) {
            case 1: 
            case 9: {
                block7: for (Node node = construct.getFirstChild(); node != null; node = node.getNextSibling()) {
                    switch (node.getNodeType()) {
                        case 1: {
                            return true;
                        }
                        case 7: {
                            ProcessingInstruction pi = (ProcessingInstruction)node;
                            if (!TARGET.equals(pi.getTarget())) continue block7;
                            XmlModelAdapter model = context.getModel();
                            Location location = context.getLocation();
                            LinkedHashSet<String> ids = new LinkedHashSet<String>();
                            ArrayList<XmlSuppressionAnalyzer.ParseError> errors = new ArrayList<XmlSuppressionAnalyzer.ParseError>();
                            XmlSuppressionAnalyzer.parseAuditProcessingInstruction((ReadTextBuffer)model.getTextBuffer(), location.getOffset(), location.getLength(), ids, errors);
                            if (!ids.contains(this.suppressionName)) continue block7;
                            return false;
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }

    public void apply(XmlTransformContext context, Node construct) {
        Document document = construct.getNodeType() == 9 ? (Document)construct : construct.getOwnerDocument();
        String data = "suppress " + this.getSuppressionName();
        ProcessingInstruction pi = document.createProcessingInstruction(TARGET, data);
        construct.insertBefore(pi, construct.getFirstChild());
    }
}

