/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.util.Service;

public class Format {
    public static String singleLineComments = "singleLineComments";
    public static String kwCase = "kwCase";
    public static String idCase = "idCase";
    public static String formatThreshold = "formatThreshold";
    public static String alignTypeDecl = "alignTypeDecl";
    public static String alignNamedArgs = "alignNamedArgs";
    public static String alignAssignments = "alignAssignments";
    public static String alignEquality = "alignEquality";
    public static String identSpaces = "identSpaces";
    public static String useTab = "useTab";
    public static String breaksComma = "breaksComma";
    public static String breaksConcat = "breaksConcat";
    public static String breaksAroundLogicalConjunctions = "breaksAroundLogicalConjunctions";
    public static String breaksAfterSelect = "breaksAfterSelect";
    public static String breaksAfterFrom = "breaksAfterFrom";
    public static String breaksAfterWhere = "breaksAfterWhere";
    public static String commasPerLine = "commasPerLine";
    public static String breakOnSubqueries = "breakOnSubqueries";
    public static String breakAnsiiJoin = "breakAnsiiJoin";
    public static String breakParenCondition = "breakParenCondition";
    public static String maxCharLineSize = "maxCharLineSize";
    public static String forceLinebreaksBeforeComment = "forceLinebreaksBeforeComment";
    public static String extraLinesAfterSignificantStatements = "extraLinesAfterSignificantStatements";
    public static String breakAfterCase = "breakAfterCase";
    public static String breakAfterWhen = "breakAfterWhen";
    public static String breakAfterThen = "breakAfterThen";
    public static String breakAfterElse = "breakAfterElse";
    public static String breakAfterIf = "breakAfterIf";
    public static String breakAfterElseif = "breakAfterElsif";
    public static String breakAfterWhile = "breakAfterWhile";
    public static String spaceAroundOperators = "spaceAroundOperators";
    public static String spaceAfterCommas = "spaceAfterCommas";
    public static String spaceAroundBrackets = "spaceAroundBrackets";
    public static String formatProgramURL = "formatProgramURL";
    public static Map<String, Object> options = new HashMap<String, Object>(){

        @Override
        public Object put(String key, Object value) {
            programInstance = null;
            return super.put(key, value);
        }
    };
    public int inputPos = -1;
    public int outputPos = -1;
    static final String path = "/oracle/dbtools/app/";
    static SqlProgram programInstance;
    public boolean rethrowSyntaxError = false;
    Map<Integer, Integer> posDepths = new HashMap<Integer, Integer>();
    int commasCount = 0;
    Map<Integer, String> newlinePositions = new HashMap<Integer, String>();
    Map<String, String> casedIds = new HashMap<String, String>();
    Map<String, Integer> maxIdLengthInScope = new HashMap<String, Integer>();
    Map<Integer, String> ids2scope = new HashMap<Integer, String>();
    Map<Integer, Integer> ids2interval = new HashMap<Integer, Integer>();
    Set<Integer> notPaddedParenthesis = new HashSet<Integer>();

    public static void main(String[] args) throws Exception {
        String input = Service.readFile(SqlEarley.class, "test.sql");
        input = Service.readFile(Format.class, "test.sql");
        Program.timing = 10000 < input.length();
        SqlEarley.visualize = false;
        SqlEarley.main(new String[]{input});
        Format format = new Format(){};
        String output = format.format(input);
        if (input.length() < 100000) {
            System.out.println("----------------- output: ------------------");
            System.out.println(output);
        }
    }

    public static void setDefaultOptions() {
        options.put(singleLineComments, (Object)InlineComments.CommentsUnchanged);
        options.put(kwCase, (Object)Case.UPPER);
        options.put(idCase, (Object)Case.lower);
        options.put(formatThreshold, 1);
        options.put(alignTypeDecl, true);
        options.put(alignNamedArgs, true);
        options.put(alignEquality, false);
        options.put(alignAssignments, false);
        options.put(identSpaces, 4);
        options.put(useTab, false);
        options.put(breaksComma, (Object)Breaks.After);
        options.put(breaksConcat, (Object)Breaks.Before);
        options.put(breaksAroundLogicalConjunctions, (Object)Breaks.BeforeAndAfter);
        options.put(breaksAfterSelect, true);
        options.put(breaksAfterFrom, true);
        options.put(breaksAfterWhere, true);
        options.put(commasPerLine, 1);
        options.put(breakOnSubqueries, true);
        options.put(breakAnsiiJoin, false);
        options.put(breakParenCondition, false);
        options.put(maxCharLineSize, 128);
        options.put(forceLinebreaksBeforeComment, false);
        options.put(extraLinesAfterSignificantStatements, (Object)BreaksX2.X2);
        options.put(breakAfterCase, false);
        options.put(breakAfterWhen, false);
        options.put(breakAfterThen, false);
        options.put(breakAfterElse, false);
        options.put(breakAfterIf, false);
        options.put(breakAfterElseif, false);
        options.put(breakAfterWhile, false);
        options.put(spaceAroundOperators, true);
        options.put(spaceAfterCommas, false);
        options.put(spaceAroundBrackets, (Object)Space.NoSpace);
        options.put(formatProgramURL, "default");
    }

    public static void setOptions(Map<String, Object> changed) {
        for (String key : changed.keySet()) {
            options.put(key, changed.get(key));
        }
    }

    public static void resetProgramInstance(String prg) {
        options.put(formatProgramURL, prg);
        programInstance = null;
    }

    public String getActiveFormatProgram() throws IOException {
        return this.getActiveFormatProgram(true);
    }

    public String getActiveFormatProgram(boolean rewrite) throws IOException {
        String ret = Service.readFile(Format.class, "/oracle/dbtools/app/format.prg");
        String customURL = (String)options.get(formatProgramURL);
        if (!"default".equals(customURL)) {
            try {
                ret = Service.readFile(customURL);
            }
            catch (IOException e) {
                System.out.println("Failed to read custom formatting program " + customURL);
                System.out.println(e.getMessage());
            }
        }
        if (rewrite) {
            ret = this.rewrite(ret);
        }
        return ret;
    }

    private String rewrite(String input) {
        String ret = input;
        for (String option : options.keySet()) {
            Object value = options.get(option);
            if (!(value instanceof Boolean)) continue;
            ret = this.reconcile(ret, option);
        }
        return ret;
    }

    private String reconcile(String input, String option) {
        boolean value = (Boolean)options.get(option);
        String pattern = "/*+" + option;
        String ret = input;
        int pos = ret.indexOf(pattern);
        while (0 < pos) {
            int eol = ret.indexOf("\r\n", pos);
            if (eol < 0) {
                eol = ret.indexOf("\n", pos);
            }
            if (eol < 0) {
                eol = ret.length();
            }
            int eoc = ret.indexOf("*/", pos);
            if (pos + pattern.length() == eoc && !value) {
                ret = ret.substring(0, pos) + pattern + ret.substring(pos + pattern.length() + 2, eol) + "*/" + ret.substring(eol);
            } else if (eol - 2 <= eoc && value) {
                ret = ret.substring(0, pos) + pattern + "*/" + ret.substring(pos + pattern.length(), eol - 2) + ret.substring(eol);
            }
            pos = ret.indexOf(pattern, pos + 3);
        }
        return ret;
    }

    public synchronized String format(String input) throws IOException {
        this.initCallbackScaffolds();
        StringBuilder output = new StringBuilder();
        this.outputPos = -1;
        Parsed target = null;
        if (programInstance == null) {
            String formaterArboriCode = this.getActiveFormatProgram();
            programInstance = new SqlProgram(formaterArboriCode);
        }
        try {
            List<LexerToken> src = LexerToken.parse(input);
            target = new Parsed(input, src, (Earley)SqlEarley.getInstance(), new String[]{"sql_statements", "subprg_body", "expr", "sql_stmt", "basic_d"});
            programInstance.eval(target, this);
            if (this.inputPos < 1) {
                this.outputPos = output.length();
            }
        }
        catch (SyntaxError e) {
            this.outputPos = e.end;
            if (this.rethrowSyntaxError) {
                throw e;
            }
            return input;
        }
        int unary_add_op = SqlEarley.getInstance().getSymbol("unary_add_op");
        int compound_expression822 = SqlEarley.getInstance().getSymbol("compound_expression[8,22)");
        int sql_statement = SqlEarley.getInstance().getSymbol("sql_statement");
        int numeric_literal = SqlEarley.getInstance().getSymbol("numeric_literal");
        int exp = SqlEarley.getInstance().getSymbol("\".exp.\"");
        List<LexerToken> fullCode = LexerToken.parse(input, true);
        int pos = -1;
        String priorIdent = null;
        LexerToken prior = null;
        int cumulativeChars = 0;
        int lastNewLine = -1;
        for (LexerToken t : fullCode) {
            if (this.outputPos < 0 && this.inputPos <= t.begin) {
                this.outputPos = t.begin;
            }
            if (t.type == Token.WS) {
                if (!"\n".equals(t.content)) continue;
                if (prior != null && prior.end < lastNewLine && lastNewLine < t.begin && options.get(extraLinesAfterSignificantStatements) == BreaksX2.Keep) {
                    output.append("\n");
                }
                lastNewLine = t.end;
                continue;
            }
            if (t.type == Token.COMMENT || t.type == Token.LINE_COMMENT || t.type == Token.MACRO_SKIP || t.type == Token.SQLPLUSLINECONTINUE_SKIP) {
                if (((Boolean)options.get(forceLinebreaksBeforeComment)).booleanValue() && prior != null && lastNewLine < prior.end) {
                    output.append("\n    ");
                }
                if (prior != null) {
                    output.append(input.substring(prior.end, t.begin));
                }
                if (t.content.endsWith("\r")) {
                    t.content = t.content.substring(0, t.content.length() - 1) + '\n';
                }
                String pureContent = t.content;
                boolean endsWNL = false;
                if (pureContent.endsWith("\n")) {
                    pureContent = pureContent.substring(0, pureContent.length() - 1);
                    endsWNL = true;
                }
                if (pureContent.startsWith("--")) {
                    pureContent = pureContent.substring(2);
                } else if (pureContent.startsWith("/*") && pureContent.endsWith("*/")) {
                    pureContent = pureContent.substring(2, pureContent.length() - 2);
                }
                if (!pureContent.contains("\n")) {
                    if (options.get(singleLineComments) == InlineComments.MultiLine) {
                        output.append("/*" + pureContent + "*/");
                        if (endsWNL) {
                            output.append("\n");
                        }
                    } else if (options.get(singleLineComments) == InlineComments.SingleLine) {
                        output.append("--" + pureContent);
                        output.append("\n");
                    } else {
                        output.append(t.content);
                    }
                } else {
                    output.append(t.content);
                }
                prior = t;
                cumulativeChars = 0;
                continue;
            }
            ParseNode node = target.getRoot().leafAtPos(++pos);
            String ident = this.newlinePositions.get(pos);
            if (node.contains("'SELECT'") && prior != null && ("UNION".equals(prior.content.toUpperCase()) || "ALL".equals(prior.content.toUpperCase()) || "MINUS".equals(prior.content.toUpperCase()))) {
                ident = priorIdent;
            }
            if (ident != null) {
                output.append(ident);
                priorIdent = ident;
                cumulativeChars = 0;
            } else {
                String scope;
                if (prior != null && prior.type == Token.LINE_COMMENT) {
                    if (priorIdent != null) {
                        output.append(priorIdent);
                    } else {
                        output.append("\n");
                    }
                }
                if (null != (scope = this.ids2scope.get(pos))) {
                    int maxLen = this.maxIdLengthInScope.get(scope);
                    LexerToken startToken = target.getSrc().get(this.ids2interval.get(pos));
                    int idLength = prior.end - startToken.begin;
                    int pad = maxLen + 3 - idLength;
                    if (pad < 1) {
                        pad = 1;
                    }
                    output.append(Service.padln("", pad));
                } else {
                    String separator = "";
                    if (!(prior == null || (prior.type == Token.OPERATION || ",".equals(t.content) || ";".equals(t.content) || ".".equals(t.content) || "%".equals(t.content) || "@".equals(t.content)) && (prior.type != Token.OPERATION || ".".equals(prior.content) || ":".equals(prior.content) || "%".equals(prior.content) || "@".equals(prior.content) || t.type == Token.OPERATION))) {
                        if (!(Format.isOpenParen(prior) && (0 >= pos || this.notPaddedParenthesis.contains(pos - 1)) && options.get(spaceAroundBrackets) != Space.Inside || Format.isCloseParen(t) && this.notPaddedParenthesis.contains(pos) && options.get(spaceAroundBrackets) != Space.Inside || Format.isOpenParen(t) && this.notPaddedParenthesis.contains(pos) && options.get(spaceAroundBrackets) != Space.Outside)) {
                            ParseNode priorLeaf = target.getRoot().leafAtPos(pos - 1);
                            ParseNode parent = target.getRoot().leafAtPos(pos).parent();
                            if (!(0 >= pos || priorLeaf != null && (priorLeaf.contains(unary_add_op) || priorLeaf.contains(compound_expression822) && priorLeaf.contains("'+'") || priorLeaf.contains(compound_expression822) && priorLeaf.contains("'-'")) || parent.contains(numeric_literal) && parent.from != node.from || parent.contains(exp))) {
                                separator = " ";
                            }
                        }
                    } else if (prior != null && prior.type == Token.OPERATION && Format.isOpenParen(t) || prior != null && Format.isCloseParen(prior) && t.type == Token.OPERATION && !";".equals(t.content) && !".".equals(t.content) && !",".equals(t.content)) {
                        separator = " ";
                    }
                    if ("/".equals(t.content) && node.parent() != null && node.parent().contains(sql_statement)) {
                        separator = "\n";
                        cumulativeChars = 0;
                    }
                    if ((Integer)options.get(maxCharLineSize) < cumulativeChars) {
                        separator = "\n";
                        cumulativeChars = 0;
                    }
                    output.append(separator);
                }
            }
            String word = t.content;
            if (t.type == Token.IDENTIFIER) {
                word = this.adjustCase(word, options.get(kwCase));
            }
            if (node != null && this.casedIds.containsKey(node.interval())) {
                word = this.casedIds.get(node.interval());
            }
            output.append(word);
            cumulativeChars += word.length();
            prior = t;
        }
        if (pos < (Integer)options.get(formatThreshold)) {
            return input;
        }
        String ret = output.toString();
        if (ret.startsWith("\n")) {
            ret = ret.substring(1);
        }
        if (options.get(breaksComma) == Breaks.Before) {
            ret = this.moveComma(ret);
        }
        if (options.get(breaksConcat) == Breaks.After) {
            ret = this.moveConcat(ret, true);
        }
        if (options.get(breaksConcat) == Breaks.None) {
            ret = this.moveConcat(ret, false);
        }
        if (options.get(breaksAroundLogicalConjunctions) == Breaks.After) {
            ret = this.trimBreaksBeforeConjunctions(ret);
        }
        if (options.get(breaksAroundLogicalConjunctions) == Breaks.Before) {
            ret = this.trimBreaksAfterConjunctions(ret);
        }
        if (!((Boolean)options.get(spaceAfterCommas)).booleanValue()) {
            ret = this.trimSpacesAfterOperations(ret, ",");
        }
        if (!((Boolean)options.get(spaceAroundOperators)).booleanValue()) {
            ret = this.trimSpacesAroundOperations(ret);
        }
        if (options.get(extraLinesAfterSignificantStatements) != BreaksX2.Keep) {
            ret = ret.replace("\n\n\n", "\n\n");
        }
        int index = -1;
        while ((index = ret.indexOf(";/", index + 1)) >= 0) {
            if (ret.indexOf("*", index + 1) == index + 2) continue;
            ret = ret.substring(0, index) + ";\n/" + ret.substring(index + 2);
        }
        this.inputPos = -1;
        return ret;
    }

    private String adjustCase(String word, Object changeCase) {
        if (!word.startsWith("\"") && changeCase == Case.lower) {
            word = word.toLowerCase();
        }
        if (!word.startsWith("\"") && changeCase == Case.UPPER) {
            word = word.toUpperCase();
        }
        if (!word.startsWith("\"") && changeCase == Case.InitCap) {
            char[] converted = new char[word.length()];
            int prior1 = 37;
            for (int i = 0; i < converted.length; ++i) {
                char current = word.charAt(i);
                converted[i] = i == 0 || prior1 == 95 ? Character.toUpperCase(current) : Character.toLowerCase(current);
                prior1 = current;
            }
            word = new String(converted);
        }
        return word;
    }

    private String moveComma(String input) {
        String ret = input;
        for (int i = 10; 0 <= i; --i) {
            String ident_;
            String ident = this.spaceSequence(i);
            String ident1 = "";
            if (0 < i) {
                ident1 = this.spaceSequence(i - 1);
            }
            if (1 < (ident_ = ident).length() && options.get(breaksComma) == Breaks.Before) {
                ident_ = ident_.substring(1);
            }
            if (2 < ident_.length() && options.get(breaksComma) == Breaks.Before && options.get(spaceAfterCommas) == Boolean.TRUE) {
                ident_ = ident_.substring(1);
            }
            ret = ret.replace("\n" + ident1 + ",\n" + ident, "\n" + ident_ + ", ");
        }
        return ret;
    }

    private String moveConcat(String input, boolean brk) {
        String ret = input;
        for (int i = 10; 0 <= i; --i) {
            String ident = this.spaceSequence(i);
            ret = ret.replace("\n" + ident + " " + "||" + " ", " ||" + (brk ? "\n" + ident : ""));
        }
        return ret;
    }

    private String trimBreaksAfterConjunctions(String input) {
        String ret = input;
        ret = this.trimBreaksAfterKeyword(ret, "OR");
        ret = this.trimBreaksAfterKeyword(ret, "AND");
        return ret;
    }

    private String trimBreaksBeforeConjunctions(String input) {
        String ret = input;
        ret = this.trimBreaksBeforeKeyword(ret, "OR");
        ret = this.trimBreaksBeforeKeyword(ret, "AND");
        return ret;
    }

    private String trimBreaksAfterKeyword(String input, String keyword) {
        String ret = input;
        String keyWord = this.adjustCase(keyword, options.get(kwCase));
        for (int i = 10; 0 <= i; --i) {
            String ident = this.spaceSequence(i);
            ret = ret.replace(keyWord + "\n" + ident, keyWord + " ");
        }
        return ret;
    }

    private String trimBreaksBeforeKeyword(String input, String keyword) {
        String ret = input;
        String keyWord = this.adjustCase(keyword, options.get(kwCase));
        for (int i = 10; 0 <= i; --i) {
            String ident = this.spaceSequence(i);
            ret = ret.replace("\n" + ident + keyWord, " " + keyWord);
        }
        return ret;
    }

    private String trimSpacesAfterOperations(String input, String oper) {
        String ret = input;
        ret = ret.replace(oper + " ", oper);
        return ret;
    }

    private String trimSpacesAroundOperations(String input, String oper) {
        String ret = input;
        ret = ret.replace(" " + oper + " ", oper);
        return ret;
    }

    private String trimSpacesAroundOperations(String input) {
        String ret = input;
        ret = this.trimSpacesAroundOperations(ret, "=");
        ret = this.trimSpacesAroundOperations(ret, "+");
        ret = this.trimSpacesAroundOperations(ret, "-");
        ret = this.trimSpacesAroundOperations(ret, "*");
        ret = this.trimSpacesAroundOperations(ret, "/");
        ret = this.trimSpacesAroundOperations(ret, "<");
        ret = this.trimSpacesAroundOperations(ret, "<=");
        ret = this.trimSpacesAroundOperations(ret, ">");
        ret = this.trimSpacesAroundOperations(ret, ">=");
        ret = this.trimSpacesAroundOperations(ret, ":=");
        ret = this.trimSpacesAroundOperations(ret, "||");
        return ret;
    }

    private static boolean isOpenParen(LexerToken t) {
        return "(".equals(t.content) || "[".equals(t.content);
    }

    private static boolean isCloseParen(LexerToken t) {
        return ")".equals(t.content) || "]".equals(t.content);
    }

    String spaceSequence(int level) {
        String output = "";
        if (((Boolean)options.get(useTab)).booleanValue()) {
            for (int i = 0; i < level; ++i) {
                output = output + "\t";
            }
        } else {
            for (int i = 0; i < level * (Integer)options.get(identSpaces); ++i) {
                output = output + " ";
            }
        }
        return output;
    }

    private void initCallbackScaffolds() {
        this.posDepths = new HashMap<Integer, Integer>();
        this.commasCount = 0;
        this.newlinePositions = new HashMap<Integer, String>();
        this.casedIds = new HashMap<String, String>();
        this.maxIdLengthInScope = new HashMap<String, Integer>();
        this.ids2scope = new HashMap<Integer, String>();
        this.ids2interval = new HashMap<Integer, Integer>();
        this.notPaddedParenthesis = new HashSet<Integer>();
    }

    public void closestPrecursorDescendant(Parsed target, Map<String, ParseNode> tuple) {
        String m = new Object(){}.getClass().getEnclosingMethod().getName();
        System.out.println(m + ".  " + MaterializedPredicate.tupleMnemonics(tuple, target.getSrc()));
    }

    public void ancestorDescendant(Parsed target, Map<String, ParseNode> tuple) {
        String m = new Object(){}.getClass().getEnclosingMethod().getName();
        System.out.println(m + ".  " + MaterializedPredicate.tupleMnemonics(tuple, target.getSrc()));
    }

    public void indentedNodes1(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("node");
        if (node == null) {
            throw new AssertionError((Object)"node == null");
        }
        if (this.skipNode(node)) {
            return;
        }
        if (node.contains("'('")) {
            if (((Boolean)options.get(breakParenCondition)).booleanValue()) {
                node = node.parent();
            } else {
                return;
            }
        }
        for (int i = node.from; i < node.to; ++i) {
            Integer posDepth = this.posDepths.get(i);
            if (posDepth == null) {
                posDepth = -1;
            }
            Integer n = posDepth;
            Integer n2 = posDepth = Integer.valueOf(posDepth + 1);
            this.posDepths.put(i, posDepth);
        }
    }

    public void indentedNodes2(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("node");
        Integer depth = this.depth(node.from);
        if (depth == null) {
            depth = 0;
        }
        int pos = node.from;
        if (",".equals(target.getSrc().get((int)node.from).content) && options.get(breaksComma) != Breaks.Before) {
            ++pos;
        }
        if (this.skipNode(node)) {
            return;
        }
        if (node.contains("'('")) {
            ParseNode parent = node.parent();
            if (parent == null) {
                return;
            }
            if (!parent.contains("compound_condition")) {
                return;
            }
            if (!((Boolean)options.get(breakParenCondition)).booleanValue()) {
                return;
            }
            node = parent;
        }
        String listAlignmentPadding = "";
        boolean skipFirstOffset = false;
        if (!(((Boolean)options.get(breaksAfterSelect)).booleanValue() && ((Boolean)options.get(breaksAfterFrom)).booleanValue() && ((Boolean)options.get(breaksAfterWhere)).booleanValue())) {
            ParseNode parent = node.parent();
            if (parent == null) {
                return;
            }
            ParseNode firstChild = null;
            Iterator<ParseNode> i$ = parent.children().iterator();
            if (i$.hasNext()) {
                ParseNode n;
                firstChild = n = i$.next();
            }
            if (!((Boolean)options.get(breaksAfterSelect)).booleanValue() && (node.contains("select_term") || node.contains("'*'"))) {
                if (firstChild.to == node.from || firstChild == node) {
                    skipFirstOffset = true;
                }
                listAlignmentPadding = Service.padln(" ", "select ".length() - (Integer)options.get(identSpaces));
            } else if (!((Boolean)options.get(breaksAfterFrom)).booleanValue() && node.contains("table_reference")) {
                if (!(firstChild.to != node.from && firstChild != node || parent.contains("\"inner_cross_join_clause\""))) {
                    skipFirstOffset = true;
                }
                listAlignmentPadding = Service.padln(" ", "from ".length() - (Integer)options.get(identSpaces));
            } else if (!((Boolean)options.get(breaksAfterWhere)).booleanValue() && node.contains("condition")) {
                if (!(firstChild.to != node.from && firstChild != node || parent.contains("on_using_condition"))) {
                    skipFirstOffset = true;
                }
                if (parent.contains("where_clause")) {
                    listAlignmentPadding = Service.padln(" ", "from ".length() - (Integer)options.get(identSpaces));
                }
            }
        }
        LexerToken nextToken = null;
        if (node.to < target.getSrc().size()) {
            nextToken = target.getSrc().get(node.to);
        }
        boolean skipSecondOffset = false;
        if (options.get(breaksComma) == Breaks.None) {
            if (nextToken != null && ",".equals(nextToken.content)) {
                skipSecondOffset = true;
            }
            LexerToken priorToken = null;
            if (1 < node.from) {
                priorToken = target.getSrc().get(node.from - 1);
            }
            if (priorToken != null && ",".equals(priorToken.content)) {
                skipFirstOffset = true;
            }
        }
        if (!skipFirstOffset) {
            this.newlinePositions.put(pos, "\n" + this.spaceSequence(depth) + listAlignmentPadding);
        }
        if (nextToken == null) {
            return;
        }
        pos = node.to;
        if (",".equals(nextToken.content) && options.get(breaksComma) != Breaks.Before || ";".equals(nextToken.content)) {
            ++pos;
        }
        if (!skipSecondOffset) {
            this.newlinePositions.put(pos, "\n" + this.spaceSequence(this.depth(pos)));
        }
    }

    private boolean skipNode(ParseNode node) {
        ParseNode parent;
        if (options.get(breaksAroundLogicalConjunctions) == Breaks.None) {
            if (node.contains("condition") && !node.contains("compound_condition") && (parent = node.parent()).contains("compound_condition")) {
                return true;
            }
            if (node.contains("rel") && (parent = node.parent()).contains("pls_expr")) {
                return true;
            }
        }
        if (!((Boolean)options.get(breakOnSubqueries)).booleanValue()) {
            ParseNode grandParent;
            if ((node.contains("select_term") || node.contains("query_table_expression") || node.contains("condition")) && node.to < node.from + 10 && (grandParent = node.parent().parent()) != null && grandParent.contains("subquery")) {
                return true;
            }
            if (node.contains("subquery")) {
                return true;
            }
        }
        return !((Boolean)options.get(breakAnsiiJoin) != false || !node.contains("table_reference") && !node.contains("condition") || (parent = node.parent()) == null || !parent.contains("on_using_condition") && !parent.contains("\"inner_cross_join_clause\"") && !parent.contains("outer_join_clause") && !parent.contains("cross_outer_apply_clause"));
    }

    private int depth(int pos) {
        Integer ret = this.posDepths.get(pos);
        if (ret == null) {
            return 0;
        }
        return ret;
    }

    public void sameLevel(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("node");
        int depth = this.depth(node.from);
        this.newlinePositions.put(node.from, "\n" + this.spaceSequence(depth) + " ");
        int pos = node.to;
        this.newlinePositions.put(pos, " ");
    }

    public void identifiers(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("identifier");
        String id = target.getSrc().get((int)node.from).content;
        if ("TO_CHAR".equals(id.toUpperCase()) || "TO_DATE".equals(id.toUpperCase()) || "DECODE".equals(id.toUpperCase()) || "SYSDATE".equals(id.toUpperCase()) || "REF".equals(id.toUpperCase()) || "VARCHAR".equals(id.toUpperCase()) || "NULL".equals(id.toUpperCase()) || "RAISE".equals(id.toUpperCase()) || "EXIT".equals(id.toUpperCase())) {
            return;
        }
        id = this.adjustCase(id, options.get(idCase));
        this.casedIds.put(node.interval(), id);
    }

    public void paddedIdsInScope(Parsed target, Map<String, ParseNode> tuple) {
        String name;
        ParseNode properties = tuple.get("scope");
        Integer maxLen = this.maxIdLengthInScope.get(properties.interval());
        if (maxLen == null) {
            maxLen = 0;
        }
        ParseNode id = tuple.get("id");
        ParseNode id1 = tuple.get("id+1");
        if (id1 != null) {
            if (!((Boolean)options.get(alignTypeDecl)).booleanValue() && id1.contains("datatype")) {
                return;
            }
            if (!((Boolean)options.get(alignTypeDecl)).booleanValue() && id.contains("decl_id")) {
                return;
            }
            if (options.get(breaksComma) == Breaks.None && id.contains("decl_id")) {
                return;
            }
            if (!((Boolean)options.get(alignNamedArgs)).booleanValue() && id1.contains("'='") && properties.contains("paren_expr_list")) {
                return;
            }
            if (!((Boolean)options.get(alignAssignments)).booleanValue() && id1.contains("':'")) {
                return;
            }
            if (!((Boolean)options.get(alignEquality)).booleanValue() && id1.contains("'='") && properties.contains("where_clause")) {
                return;
            }
            if (!((Boolean)options.get(alignEquality)).booleanValue() && id1.contains("'='") && properties.contains("on_using_condition")) {
                return;
            }
        }
        if (0 < (name = target.getInput().substring(target.getSrc().get((int)id.from).begin, target.getSrc().get((int)(id.to - 1)).begin)).indexOf(10)) {
            return;
        }
        int idLen = 0;
        for (int i = id.from; i < id.to; ++i) {
            idLen += target.getSrc().get((int)i).content.length();
        }
        if (maxLen < idLen) {
            maxLen = idLen;
        }
        this.maxIdLengthInScope.put(properties.interval(), maxLen);
        this.ids2scope.put(id.to, properties.interval());
        this.ids2interval.put(id.to, id.from);
    }

    public void extraLines(Parsed target, Map<String, ParseNode> tuple) {
        if (options.get(extraLinesAfterSignificantStatements) != BreaksX2.X2) {
            return;
        }
        ParseNode node = tuple.get("node");
        String padding = this.newlinePositions.get(node.to);
        if (padding == null) {
            this.newlinePositions.put(node.to, "\n\n");
        } else {
            this.newlinePositions.put(node.to, "\n" + padding);
        }
        padding = this.newlinePositions.get(node.from);
    }

    public void notPaddedParenthesis(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode paren = tuple.get("paren");
        this.notPaddedParenthesis.add(paren.from);
    }

    static {
        Format.setDefaultOptions();
        programInstance = null;
    }

    public static enum InlineComments {
        CommentsUnchanged,
        SingleLine,
        MultiLine;

    }

    public static enum BreaksX2 {
        X1,
        X2,
        Keep;

    }

    public static enum Breaks {
        Before,
        After,
        None,
        BeforeAndAfter;

    }

    public static enum Space {
        Inside,
        Outside,
        NoSpace;

    }

    public static enum Case {
        UPPER,
        lower,
        InitCap,
        NoCaseChange;

    }
}

