/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.app.Obfuscator;
import oracle.dbtools.app.SqlId;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.parser.plsql.StackParser;
import oracle.dbtools.util.Service;

public abstract class Rewrite {
    public int fileCnt = 0;
    private Set<String> fileExtensions;

    public Rewrite(Set<String> fileExtensions) {
        this.fileExtensions = fileExtensions;
    }

    public void walkDir(File file) throws FileNotFoundException, Exception {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                this.walkDir(child);
            }
        } else {
            this.rewrite(file);
        }
    }

    public void rewrite(File file) throws FileNotFoundException, Exception {
        int dotPos;
        String fileName = file.getName();
        if (fileName.length() > 4 && (dotPos = fileName.lastIndexOf(46)) >= 0 && dotPos < fileName.length() - 3) {
            String suffix = "*" + fileName.substring(dotPos).toLowerCase();
            if (this.fileExtensions.contains("*.*") || this.fileExtensions.contains(suffix)) {
                ParseNode root;
                List<LexerToken> src;
                String input = Service.readFile(new FileInputStream(file));
                String output = this.transform(input, src = LexerToken.parse(input), (LazyNode)(root = StackParser.getInstance().parse((List)src)));
                if (output != null) {
                    FileWriter fstream = new FileWriter(file);
                    BufferedWriter out = new BufferedWriter(fstream);
                    out.write(output.toString());
                    out.close();
                }
                ++this.fileCnt;
            }
        }
    }

    public abstract String transform(String var1, List<LexerToken> var2, LazyNode var3);

    protected abstract String found();

    protected abstract String changed();

    public String log() {
        return "Processed " + this.fileCnt + " files, " + this.found() + this.changed();
    }

    public static void main(String[] args) throws Exception {
        String usage = "Usage: java -jar <utils-nodeps.jar> \n<command> (e.g. \"sqlid\", \"obfuscate\") \n<directory> <sqlid_prefix>) \ne.g. \njava -jar C:\\sqld\\sqldeveloper\\lib\\oracle.sqldeveloper.utils-nodeps.jar\nobfuscate . \njava -jar C:\\sqld\\sqldeveloper\\lib\\oracle.sqldeveloper.utils-nodeps.jar\nsqlid C:\\Apex_code APEX";
        switch (args.length) {
            default: {
                System.out.println(usage);
                return;
            }
            case 2: 
            case 3: 
        }
        File dir = new File(args[1]);
        HashSet<String> fileExts = new HashSet<String>();
        fileExts.add("*.plb");
        fileExts.add("*.pls");
        fileExts.add("*.pkb");
        if (!dir.exists()) {
            System.out.println("Specified directory does not exist.");
        }
        Rewrite instance = null;
        if ("sqlid".equalsIgnoreCase(args[0]) && args.length == 3) {
            instance = new SqlId(args[2], fileExts);
        } else if ("obfuscate".equalsIgnoreCase(args[0]) && args.length == 2) {
            instance = new Obfuscator(fileExts);
        } else {
            System.out.println(usage);
            return;
        }
        instance.walkDir(dir);
        System.out.println(instance.log());
    }
}

