/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.util.Map;
import java.util.Set;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.parser.ParseNode;

abstract class Attribute {
    String name;

    Attribute() {
    }

    static ParseNode getPredecessor(ParseNode self, ParseNode parent) {
        ParseNode prior = null;
        for (ParseNode child : parent.children()) {
            if (child == self) {
                return prior;
            }
            prior = child;
        }
        return null;
    }

    static ParseNode getSuccessor(ParseNode self, ParseNode parent) {
        ParseNode prior = null;
        for (ParseNode child : parent.children()) {
            if (prior == self) {
                return child;
            }
            prior = child;
        }
        return null;
    }

    protected static String referredTo(String attr) {
        int pos = attr.indexOf(60);
        if (0 < pos) {
            String postfix = attr.substring(pos + 1).trim();
            if (postfix.charAt(0) == '=') {
                postfix = postfix.substring(1);
            }
            if (postfix.indexOf(46) < 0 & postfix.indexOf(93) < 0) {
                return postfix;
            }
        }
        if (0 < (pos = attr.indexOf(61))) {
            return attr.substring(pos + 1);
        }
        if (attr.endsWith("^")) {
            return attr.substring(0, attr.length() - 1);
        }
        if (attr.endsWith("+1") || attr.endsWith("-1")) {
            return attr.substring(0, attr.length() - 2);
        }
        pos = attr.lastIndexOf(46);
        if (0 < pos) {
            return attr.substring(0, pos);
        }
        return null;
    }

    boolean isDependent(String primaryVar, Map<String, Attribute> varDefs) {
        if (primaryVar.equals(this.name)) {
            return true;
        }
        Attribute ref = this.referredTo(varDefs);
        if (ref == null) {
            return false;
        }
        return ref.isDependent(primaryVar, varDefs);
    }

    public String toString() {
        return this.name;
    }

    abstract Set<Tuple> eval(Map<String, Integer> var1, Set<Tuple> var2, ParseNode var3);

    abstract Attribute referredTo(Map<String, Attribute> var1);
}

