/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.arbori.Attribute;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Oper;
import oracle.dbtools.arbori.Predicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;

class CompositeExpr
implements Predicate {
    Predicate lft;
    Predicate rgt;
    Oper oper;

    public CompositeExpr(Predicate lft, Predicate rgt, Oper oper) {
        this.lft = lft;
        this.rgt = rgt;
        this.oper = oper;
    }

    @Override
    public boolean eval(Map<String, Integer> attributePositions, ParseNode[] tuple, List<LexerToken> src) {
        if (this.oper == Oper.CONJUNCTION) {
            return this.lft.eval(attributePositions, tuple, src) && this.rgt.eval(attributePositions, tuple, src);
        }
        if (this.oper == Oper.DISJUNCTION) {
            return this.lft.eval(attributePositions, tuple, src) || this.rgt.eval(attributePositions, tuple, src);
        }
        if (this.oper == Oper.NEGATION) {
            return !this.lft.eval(attributePositions, tuple, src);
        }
        throw new AssertionError((Object)"Unexpected case");
    }

    public String toString() {
        return this.toString(0);
    }

    @Override
    public String toString(int depth) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < depth; ++i) {
            sb.append("  ");
        }
        sb.append(this.oper.toString().substring(0, 4) + '\n');
        sb.append(this.lft.toString(depth + 1));
        if (this.rgt != null) {
            sb.append(this.rgt.toString(depth + 1));
        }
        return sb.toString();
    }

    @Override
    public void variables(Set<String> ret, boolean optimizeEqs) {
        if (this.rgt == null) {
            this.lft.variables(ret, this.oper == Oper.CONJUNCTION);
            return;
        }
        this.lft.variables(ret, this.oper == Oper.CONJUNCTION);
        this.rgt.variables(ret, this.oper == Oper.CONJUNCTION);
    }

    @Override
    public void signature(Set<String> ret) {
        if (this.rgt == null) {
            this.lft.signature(ret);
            return;
        }
        if (this.oper == Oper.CONJUNCTION) {
            this.lft.signature(ret);
            this.rgt.signature(ret);
        } else if (this.oper == Oper.DISJUNCTION) {
            HashSet<String> first = new HashSet<String>();
            this.lft.signature(first);
            HashSet<String> second = new HashSet<String>();
            this.rgt.signature(second);
            first.retainAll(second);
            ret.addAll(first);
        } else if (this.oper == Oper.DIFFERENCE) {
            this.lft.signature(ret);
        }
    }

    @Override
    public MaterializedPredicate eval(Parsed target) {
        if (this.oper == Oper.DISJUNCTION) {
            MaterializedPredicate l = this.lft.eval(target);
            if (l == null) {
                return null;
            }
            MaterializedPredicate r = this.rgt.eval(target);
            if (r == null) {
                return null;
            }
            return MaterializedPredicate.union(l, r);
        }
        if (this.oper == Oper.CONJUNCTION) {
            MaterializedPredicate l = this.lft.eval(target);
            if (l == null) {
                return null;
            }
            MaterializedPredicate r = this.rgt.eval(target);
            if (r == null) {
                return null;
            }
            return MaterializedPredicate.join(l, r);
        }
        if (this.oper == Oper.DIFFERENCE) {
            MaterializedPredicate l = this.lft.eval(target);
            if (l == null) {
                return null;
            }
            MaterializedPredicate r = this.rgt.eval(target);
            if (r == null) {
                return null;
            }
            return MaterializedPredicate.difference(l, r);
        }
        return null;
    }

    @Override
    public Predicate isRelated(String var1, String var2, Map<String, Attribute> varDefs) {
        if (this.oper != Oper.CONJUNCTION && this.oper != Oper.DISJUNCTION && this.oper != Oper.NEGATION) {
            return null;
        }
        Predicate l = this.lft.isRelated(var1, var2, varDefs);
        Predicate r = null;
        if (this.oper != Oper.NEGATION) {
            r = this.rgt.isRelated(var1, var2, varDefs);
        }
        if (l != null && r != null) {
            return new CompositeExpr(l, r, this.oper);
        }
        if (l == null && r != null && this.oper == Oper.CONJUNCTION) {
            return r;
        }
        if (l != null && r == null && this.oper == Oper.CONJUNCTION) {
            return l;
        }
        if (l != null && r == null && this.oper == Oper.NEGATION) {
            return this;
        }
        return null;
    }

    @Override
    public Map<String, Boolean> dependencies() {
        if (this.oper == Oper.CONJUNCTION) {
            Map<String, Boolean> ret = this.lft.dependencies();
            ret.putAll(this.rgt.dependencies());
            return ret;
        }
        if (this.oper == Oper.DIFFERENCE) {
            Map<String, Boolean> ret = this.lft.dependencies();
            for (String s : this.rgt.dependencies().keySet()) {
                ret.put(s, false);
            }
            return ret;
        }
        if (this.oper == Oper.DISJUNCTION) {
            if (this.rgt instanceof MaterializedPredicate && ((MaterializedPredicate)this.rgt).cardinality() == 0) {
                return this.lft.dependencies();
            }
            if (this.lft instanceof MaterializedPredicate && ((MaterializedPredicate)this.lft).cardinality() == 0) {
                return this.rgt.dependencies();
            }
            HashMap<String, Boolean> ret = new HashMap<String, Boolean>();
            for (String s : this.lft.dependencies().keySet()) {
                ret.put(s, false);
            }
            for (String s : this.rgt.dependencies().keySet()) {
                ret.put(s, false);
            }
            return ret;
        }
        if (this.oper == Oper.NEGATION) {
            HashMap<String, Boolean> ret = new HashMap<String, Boolean>();
            for (String s : this.lft.dependencies().keySet()) {
                ret.put(s, false);
            }
            return ret;
        }
        throw new AssertionError((Object)"Unexpected case");
    }

    @Override
    public Predicate copy(Program prg) {
        CompositeExpr ret = new CompositeExpr(this.lft, this.rgt, this.oper);
        ret.lft = this.lft.copy(prg);
        if (this.rgt != null) {
            ret.rgt = this.rgt.copy(prg);
        }
        return ret;
    }
}

