/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.utils;

public final class StringUtils {
    public static void main(String[] args) {
        String s = "           This is a #weird String         ";
        System.out.println(s);
        System.out.println("ltrim >" + StringUtils.ltrim(s) + "<");
        System.out.println("rtrim >" + StringUtils.rtrim(s) + "<");
        System.out.println("nonalpha >" + StringUtils.getFirstNonAlpha(s) + "<");
        System.out.println(StringUtils.initCapSingle("tYPE bODY"));
        System.out.println(StringUtils.initCap("tYPE bODY"));
        System.out.println(StringUtils.initCapSingle("tYPE bODY"));
    }

    public static String ltrim(String s) {
        int i;
        for (i = 0; i < s.length() && Character.isWhitespace(s.charAt(i)); ++i) {
        }
        return s.substring(i);
    }

    public static String rtrim(String s) {
        int i;
        for (i = s.length() - 1; i >= 0 && Character.isWhitespace(s.charAt(i)); --i) {
        }
        return s.substring(0, i + 1);
    }

    public static String getFirstNonAlpha(String str) {
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            char c = str.charAt(i);
            if (Character.isAlphabetic(c) || Character.isDigit(c) || Character.isSpaceChar(c)) continue;
            return Character.toString(c);
        }
        return null;
    }

    public static String initCap(String line) {
        String[] arr = line.split(" ");
        StringBuilder sb = new StringBuilder();
        for (String word : arr) {
            word = word.toUpperCase().replace(word.substring(1), word.substring(1).toLowerCase());
            sb.append(word + " ");
        }
        return sb.toString().trim();
    }

    public static Object initCapSingle(String objectType) {
        if (objectType.length() > 1) {
            return objectType.toUpperCase().substring(0, 1) + objectType.toLowerCase().substring(1);
        }
        return objectType.toUpperCase();
    }
}

