/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Icon;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.util.Array;
import oracle.dbtools.util.Pair;
import oracle.dbtools.util.Service;

public class ParseNode
implements Comparable {
    public int from;
    public int to;
    public ParseNode parent;
    ParseNode lft = null;
    ParseNode rgt = null;
    private int[] symbols = new int[0];
    public Set<ParseNode> topLevel = null;
    private Parser parser;
    public static String ignoreMarkers = null;

    public boolean contains(int symbol) {
        return this.symbols[Array.indexOf(this.symbols, symbol)] == symbol;
    }

    public boolean contains(String symbol) {
        if (this.parser == null) {
            throw new AssertionError((Object)"ParseNode.parser == null");
        }
        Integer code = this.parser.symbolIndexes.get(symbol);
        if (code == null) {
            throw new AssertionError((Object)("No such symbol `" + symbol + "` in the grammar"));
        }
        return this.contains(code);
    }

    public List<ParseNode> descendants() {
        ArrayList<ParseNode> ret = new ArrayList<ParseNode>();
        ret.add(this);
        for (ParseNode n : this.children()) {
            ret.addAll(n.descendants());
        }
        return ret;
    }

    public ParseNode parent() {
        if (this.parent == null) {
            return null;
        }
        if (!this.parent.isAuxiliary()) {
            return this.parent;
        }
        ParseNode ret = this.parent.parent();
        if (ret == null) {
            return this.parent;
        }
        return ret;
    }

    public ParseNode childAt(int head, int tail) {
        if (this.topLevel != null) {
            for (ParseNode child : this.children()) {
                if (child.from > head || tail > child.to) continue;
                return child;
            }
            return null;
        }
        if (this.lft != null && this.lft.from <= head && tail <= this.lft.to) {
            return this.lft;
        }
        if (this.rgt != null && this.rgt.from <= head && tail <= this.rgt.to) {
            return this.rgt;
        }
        return null;
    }

    public int compareTo(Object obj) {
        ParseNode src = (ParseNode)obj;
        if (this.from != src.from) {
            return this.from - src.from;
        }
        return this.to - src.to;
    }

    public String toString() {
        return this.toString(0);
    }

    public ArrayList<Pair<ParseNode, ParseNode>> descendants(ParseNode parent) {
        ArrayList<Pair<ParseNode, ParseNode>> ret = new ArrayList<Pair<ParseNode, ParseNode>>();
        ret.add(new Pair<ParseNode, ParseNode>(this, parent));
        for (ParseNode n : this.children()) {
            ret.addAll(n.descendants(this));
        }
        return ret;
    }

    public List<ParseNode> ancestors(int pos) {
        return this.intermediates(pos, pos + 1);
    }

    public List<ParseNode> intermediates(int head, int tail) {
        ArrayList<ParseNode> ret = new ArrayList<ParseNode>();
        if (this.from <= head && tail <= this.to) {
            ret.add(this);
        }
        for (ParseNode n : this.children()) {
            if (n.from > head || tail > n.to) continue;
            ret.addAll(n.intermediates(head, tail));
        }
        return ret;
    }

    @Deprecated
    public ParseNode ancestor(int head, int tail, int content) {
        throw new AssertionError((Object)"Deprecated");
    }

    public ParseNode ancestor(int content) {
        if (this.contains(content)) {
            return this;
        }
        if (this.parent() == null) {
            return null;
        }
        return this.parent().ancestor(content);
    }

    public ParseNode descendant(int head, int tail, int content) {
        if (this.contains(content)) {
            return this;
        }
        for (ParseNode child : this.children()) {
            if (child.from > head || tail > child.to) continue;
            if (child.contains(content)) {
                return child;
            }
            return child.descendant(head, tail, content);
        }
        return null;
    }

    @Deprecated
    public ParseNode parent(int head, int tail) {
        ParseNode lastNotAux = null;
        ParseNode current = this;
        do {
            if (!current.isAuxiliary()) {
                lastNotAux = current;
            }
            if ((current = current.childAt(head, tail)) != null) continue;
            return null;
        } while (current.from != head || current.to != tail);
        return lastNotAux;
    }

    void print(int depth) {
        System.out.println(this.toString(depth));
    }

    public ParseNode leafAtPos(int pos) {
        if (this.children().size() == 0 && pos == this.from) {
            return this;
        }
        for (ParseNode child : this.children()) {
            if (child.from > pos || pos >= child.to) continue;
            return child.leafAtPos(pos);
        }
        return null;
    }

    private void calculateDepth(Map<Long, Integer> depthMap, int depth) {
        depthMap.put(Service.lPair(this.from, this.to), depth);
        for (ParseNode child : this.children()) {
            child.calculateDepth(depthMap, depth + 1);
        }
    }

    Map<Long, Integer> calculateDepth() {
        TreeMap<Long, Integer> depthMap = new TreeMap<Long, Integer>();
        this.calculateDepth(depthMap, 0);
        return depthMap;
    }

    public void printTree() {
        Map<Long, Integer> depthMap = this.calculateDepth();
        boolean i = false;
        for (ParseNode n : this.descendants()) {
            int depth = depthMap.get(Service.lPair(n.from, n.to));
            n.print(depth);
        }
    }

    public void printBinaryTree(int depth) {
        this.print(depth);
        if (this.lft != null) {
            this.lft.printBinaryTree(depth + 1);
        }
        if (this.rgt != null) {
            this.rgt.printBinaryTree(depth + 1);
        }
        if (this.topLevel != null) {
            for (ParseNode n : this.topLevel) {
                n.printBinaryTree(depth + 1);
            }
        }
    }

    public String tree() {
        StringBuilder ret = new StringBuilder();
        Map<Long, Integer> depthMap = this.calculateDepth();
        boolean i = false;
        for (ParseNode n : this.descendants()) {
            int depth = depthMap.get(Service.lPair(n.from, n.to));
            ret.append(n.toString(depth, "["));
            ret.append("\n");
        }
        return ret.toString();
    }

    public String content(List<LexerToken> src) {
        StringBuilder sb = new StringBuilder();
        try {
            int lastEnd = -1;
            for (int i = this.from; i < this.to; ++i) {
                LexerToken t = src.get(i);
                if (this.from < i && lastEnd < t.begin) {
                    sb.append(' ');
                }
                sb.append(t.content);
                lastEnd = t.end;
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("src out of sync with parse tree?");
            e.printStackTrace();
        }
        return sb.toString();
    }

    public int[] content() {
        return this.symbols;
    }

    public void addContent(int symbol) {
        this.symbols = Array.insert(this.symbols, symbol);
    }

    public void addContent(String symbol) {
        Integer s = this.parser.symbolIndexes.get(symbol);
        if (s == null) {
            System.err.println(symbol + " not found");
        }
        this.addContent(s);
    }

    public void addTopLevel(ParseNode child) {
        if (this.topLevel == null) {
            this.topLevel = new TreeSet<ParseNode>();
        }
        this.topLevel.add(child);
    }

    public ParseNode(int begin, int end, int sIn, int sOut, Parser c) {
        this.from = begin;
        this.to = end;
        this.addContent(sIn);
        this.addContent(sOut);
        this.parser = c;
    }

    protected String toString(int depth) {
        if (ignoreMarkers != null) {
            return this.toString(depth, ignoreMarkers);
        }
        return this.toString(depth, "");
    }

    protected String toString(int depth, String auxMarkers) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < depth; ++i) {
            sb.append("  ");
        }
        sb.append(this.interval() + " ");
        int[] arr$ = this.content();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer i = arr$[i$];
            if (i == -1) continue;
            String symbol = this.parser.allSymbols[i];
            boolean skip = false;
            for (char c : auxMarkers.toCharArray()) {
                if (0 > symbol.indexOf(c)) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            sb.append("  " + symbol);
        }
        return sb.toString();
    }

    public String interval() {
        return "[" + this.from + "," + this.to + ")";
    }

    public long id() {
        return Service.lPair(this.from, this.to);
    }

    public boolean isAuxiliary() {
        return this.symbols[0] == -1;
    }

    public Set<ParseNode> children() {
        TreeSet<ParseNode> ret = new TreeSet<ParseNode>();
        if (this.topLevel != null) {
            for (ParseNode child : this.topLevel) {
                if (child.isAuxiliary()) {
                    ret.addAll(child.children());
                    continue;
                }
                ret.add(child);
            }
            return ret;
        }
        if (this.lft == null) {
            return ret;
        }
        if (this.lft.isAuxiliary()) {
            ret.addAll(this.lft.children());
        } else {
            ret.add(this.lft);
        }
        if (this.rgt == null) {
            return ret;
        }
        if (this.rgt.isAuxiliary()) {
            ret.addAll(this.rgt.children());
        } else {
            ret.add(this.rgt);
        }
        return ret;
    }

    public void moveInterval(int offset) {
        this.from += offset;
        this.to += offset;
        if (this.topLevel != null) {
            for (ParseNode p : this.topLevel) {
                p.moveInterval(offset);
            }
        } else {
            if (this.lft != null) {
                this.lft.moveInterval(offset);
            }
            if (this.rgt != null) {
                this.rgt.moveInterval(offset);
            }
        }
    }

    public int treeDepth() {
        int ret = 0;
        for (ParseNode child : this.children()) {
            int tmp = child.treeDepth();
            if (ret >= tmp) continue;
            ret = tmp;
        }
        return ret + 1;
    }

    public Icon getIcon() {
        return null;
    }
}

