/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.util.Set;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.plsql.SqlEarley;

public class ExportGrammar {
    private static Set<RuleTuple> origRules;

    public static void main(String[] args) throws Exception {
        boolean isJS = false;
        if (isJS) {
            ExportGrammar.copyGrammar(isJS, "C:\\AceOracle\\WebContent\\src\\parser\\sqlgrammar.js");
            ExportGrammar.copyGrammar(isJS, "C:\\sql_developer_web\\js\\oracle\\oracle.grammar.js");
        } else {
            ExportGrammar.copyGrammar(isJS, "C:\\Temp\\sqlgrammar.txt");
        }
    }

    private static void copyGrammar(boolean isJS, String fname) throws IOException {
        File file = new File(fname);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileWriter fw = new FileWriter(file.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        if (isJS) {
            bw.write("function sqlGrammar() {\n");
            bw.write("    var sql = [];\n");
        }
        for (RuleTuple rule : origRules) {
            if (isJS) {
                bw.write("sql.push({head:\"");
                bw.write(rule.head.replace("\"", "\\\""));
                bw.write("\",rhs:[\"");
                int pos = -1;
                for (String t : rule.rhs) {
                    if (0 < ++pos) {
                        bw.write("\",\"");
                    }
                    bw.write(t.replace("\"", "\\\""));
                }
                bw.write("\"]});\n");
                continue;
            }
            bw.write(rule.toString() + "\n");
        }
        if (isJS) {
            bw.write("  return sql;\n");
            bw.write("}\n");
        }
        bw.close();
    }

    private static void saveGrammar() throws Exception {
        Class.forName("oracle.jdbc.OracleDriver");
        Connection conn = DriverManager.getConnection("jdbc:oracle:thin:@llg00hon.uk.oracle.com:1521/DB12201", "hr", "hr");
        PreparedStatement stmt = conn.prepareStatement("insert into sql122_grammar values(?,?)");
        for (RuleTuple rule : origRules) {
            String r = rule.toString();
            int semiColPos = r.indexOf(58);
            String rhs = r.substring(semiColPos + 1);
            stmt.setString(1, rule.head);
            stmt.setString(2, rhs);
            stmt.execute();
            System.out.println(r);
        }
    }

    static {
        SqlEarley.getInstance();
        origRules = SqlEarley.origRules;
    }
}

