/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.util.Service;

public class UnitTest {
    static int testNo = 0;
    private static TreeSet<Integer> failedTests = new TreeSet();
    private static int output = -1;
    private static int tree = -1;
    private static int node = -1;
    private static int range = -1;
    private static int digits = -1;
    private static int label = -1;
    private static int assertion = -1;
    public static int query = -1;
    private static int atest = -1;
    private static int sql_fragment = -1;
    private static int comment = -1;
    public static Earley testParser = null;
    static Random random;
    protected static boolean introduceRandomError;
    static SqlEarley parser;

    public static void main(String[] args) throws Exception {
        String testFile = "unit.test";
        UnitTest.test(testFile);
    }

    public static void test(String testFile) throws Exception {
        String input = Service.readFile(UnitTest.class, testFile);
        List<LexerToken> src = LexerToken.parse(input, "`");
        Visual visual = null;
        Matrix matrix = new Matrix(testParser);
        testParser.parse(src, matrix);
        SyntaxError s = SyntaxError.checkSyntax(input, new String[]{"atest"}, src, testParser, matrix);
        if (s != null) {
            if (visual != null) {
                visual.draw(matrix);
            }
            System.err.println("Syntax Error");
            System.err.println("at line#" + s.line);
            System.err.println(s.code);
            System.err.println(s.marker);
            System.err.println("Expected:  ");
            for (String tmp : s.getSuggestions()) {
                System.out.print(tmp + ',');
            }
            throw new Exception(">>>> syntactically invalid code fragment <<<<");
        }
        ParseNode root = testParser.forest(src, matrix);
        UnitTest.atest(root, src, input);
        if (failedTests.size() == 0) {
            System.out.println("*** ALL " + testNo + " TESTS are OK *** ---> ");
        } else {
            System.err.println("*** FAILED " + failedTests.size() + " tests *** ");
        }
        int cnt = -1;
        for (int testNo : failedTests) {
            if (++cnt < 10) {
                System.err.print(testNo + ",");
                continue;
            }
            if (cnt == 10) {
                System.err.print(" ... ");
                continue;
            }
            if (failedTests.size() - 10 >= cnt) continue;
            System.err.print("," + testNo);
        }
        if (0 < failedTests.size()) {
            System.exit(2);
        }
    }

    private static Set<RuleTuple> getRules() throws Exception {
        String input = Service.readFile(UnitTest.class, "unitTest.grammar");
        List<LexerToken> src = LexerToken.parse(input, false, 1);
        ParseNode root = Grammar.parseGrammarFile(src, input);
        TreeSet<RuleTuple> ret = new TreeSet<RuleTuple>();
        Grammar.grammar(root, src, ret);
        return ret;
    }

    private static void atest(ParseNode root, List<LexerToken> src, String input) throws Exception {
        if (root.contains(assertion)) {
            UnitTest.assertion(root, src, input);
            return;
        }
        if (root.contains(output)) {
            Iterator<ParseNode> i$ = root.children().iterator();
            if (i$.hasNext()) {
                ParseNode child = i$.next();
                ParseNode out = UnitTest.query(child, src, input);
                System.out.println("TEST#" + testNo + ":  ---> ");
                out.printTree();
                return;
            }
            return;
        }
        if (root.contains(comment)) {
            UnitTest.comment(root, src, input);
        }
        for (ParseNode child : root.children()) {
            UnitTest.atest(child, src, input);
        }
    }

    private static ParseNode comment(ParseNode root, List<LexerToken> src, String input) throws Exception {
        String testNum = input.substring(src.get((int)(root.from + 2)).begin, src.get((int)(root.to - 1)).end - 1);
        testNo = Integer.parseInt(testNum);
        return null;
    }

    private static ParseNode query(ParseNode root, List<LexerToken> src, String input) {
        return UnitTest.parse(UnitTest.sql_fragment(root, src, input));
    }

    private static ParseNode parse(String q) {
        int pos;
        List<LexerToken> src1 = LexerToken.parse(q);
        if (introduceRandomError && 10 < (pos = random.nextInt(src1.size() - 1))) {
            LexerToken t = src1.get(pos);
            t.type = Token.OPERATION;
            t.content = "';'";
        }
        return parser.parse(src1);
    }

    private static String sql_fragment(ParseNode root, List<LexerToken> src, String input) {
        String ret = input.substring(src.get((int)root.from).begin, src.get((int)(root.to - 1)).end);
        if (ret.charAt(0) == '\"') {
            ret = ret.substring(1, ret.length() - 1);
        }
        if (ret.charAt(0) == '`') {
            ret = ret.substring(1, ret.length() - 1);
        }
        return " " + ret + " ";
    }

    private static ParseNode assertion(ParseNode root, List<LexerToken> src, String input) throws Exception {
        ParseNode output = null;
        ParseNode cmp = null;
        for (ParseNode child : root.children()) {
            if (child.contains(query)) {
                output = UnitTest.query(child, src, input);
                continue;
            }
            if (child.from + 1 == child.to && ("-".equals(child.content(src)) || ">".equals(child.content(src)) || ";".equals(child.content(src))) || !child.contains(tree)) continue;
            cmp = UnitTest.tree(UnitTest.nodeList(child, src, input));
        }
        boolean test = UnitTest.isSubtree(cmp, output);
        if (!test) {
            failedTests.add(testNo);
            System.out.println("TEST#" + testNo + ":  broken");
        }
        return null;
    }

    private static ParseNode tree(Set<ParseNode> nodeList) {
        for (ParseNode parent : nodeList) {
            for (ParseNode grandchild : nodeList) {
                if ((parent.from >= grandchild.from || grandchild.to > parent.to) && (parent.from > grandchild.from || grandchild.to >= parent.to)) continue;
                boolean isAdjacent = true;
                for (ParseNode child : nodeList) {
                    if ((parent.from >= child.from || child.to > parent.to) && (parent.from > child.from || child.to >= parent.to) || (child.from >= grandchild.from || grandchild.to > child.to) && (child.from > grandchild.from || grandchild.to >= child.to)) continue;
                    isAdjacent = false;
                    break;
                }
                if (!isAdjacent) continue;
                parent.addTopLevel(grandchild);
            }
        }
        return UnitTest.root(nodeList);
    }

    private static ParseNode root(Set<ParseNode> nodeList) {
        ParseNode ret = null;
        for (ParseNode candidate : nodeList) {
            if (ret == null) {
                ret = candidate;
                continue;
            }
            if ((candidate.from >= ret.from || ret.to > candidate.to) && (candidate.from > ret.from || ret.to >= candidate.to)) continue;
            ret = candidate;
        }
        return ret;
    }

    private static boolean isSubtree(ParseNode a, ParseNode b) {
        if (a.from != b.from || a.to != b.to) {
            System.out.println("Mismatching intervals: [" + a.from + "," + a.to + ") and [" + b.from + "," + b.to + ")");
            return false;
        }
        Integer mismatch = UnitTest.contentIsSubsetWithOneExc(a, b);
        if (mismatch != null) {
            System.out.println("Different content at nodes [" + a.from + "," + a.to + ") ");
            System.out.println("Not found:" + UnitTest.parser.allSymbols[mismatch]);
            return false;
        }
        if (a.topLevel == null && b.children().size() == 0) {
            return true;
        }
        if (a.topLevel.size() != b.children().size()) {
            System.out.println("Children count mismatch at nodes [" + a.from + "," + a.to + ")");
            System.out.println("a.topLevel.size()=" + a.topLevel.size() + ", b.children().size()=" + b.children().size());
            for (ParseNode n : a.topLevel) {
                System.out.println(n.toString());
            }
            for (ParseNode n : b.children()) {
                System.out.println(n.toString());
            }
            return false;
        }
        for (ParseNode ca : a.topLevel) {
            boolean matched = false;
            for (ParseNode cb : b.children()) {
                if (ca.from != cb.from || ca.to != cb.to || !UnitTest.isSubtree(ca, cb)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    private static Integer contentIsSubsetWithOneExc(ParseNode a, ParseNode b) {
        if (a instanceof LazyNode && !(b instanceof LazyNode) || !(a instanceof LazyNode) && b instanceof LazyNode) {
            throw new AssertionError((Object)(a.getClass() + "!=" + b.getClass()));
        }
        if (a instanceof LazyNode && b instanceof LazyNode) {
            String contentA = ((LazyNode)a).startToken;
            if (contentA == null) {
                return null;
            }
            return contentA.equals(((LazyNode)b).startToken) ? null : Integer.valueOf(-1);
        }
        int i = 0;
        if (a.content()[0] == -1) {
            ++i;
        }
        for (int j = 0; i < a.content().length && j < b.content().length; ++i, ++j) {
            while (j < b.content().length && a.content()[i] != b.content()[j]) {
                ++j;
            }
            if (j != b.content().length) continue;
            return a.content()[i];
        }
        return null;
    }

    private static Set<ParseNode> nodeList(ParseNode root, List<LexerToken> src, String input) {
        TreeSet<ParseNode> ret = new TreeSet<ParseNode>();
        for (ParseNode child : root.children()) {
            if (child.contains(node)) {
                ret.add(UnitTest.node(child, src, input));
            }
            if (!child.contains(tree)) continue;
            ret.addAll(UnitTest.nodeList(child, src, input));
        }
        if (ret == null) {
            ret = null;
        }
        return ret;
    }

    private static ParseNode node(ParseNode root, List<LexerToken> src, String input) {
        ParseNode ret = null;
        if (root.contains(range)) {
            long rng = UnitTest.range(root, src, input);
            if (parser instanceof SqlEarley) {
                ret = new ParseNode(Service.lX(rng), Service.lY(rng), -1, -1, SqlEarley.getInstance());
            } else {
                ret = new LazyNode(Service.lX(rng), null, src);
                ret.to = Service.lY(rng);
            }
            return ret;
        }
        for (ParseNode child : root.children()) {
            if (child.contains(label)) {
                String symbol = src.get((int)child.from).content;
                ((ParseNode)ret).addContent(symbol);
                continue;
            }
            if (!child.contains(node)) continue;
            ret = UnitTest.node(child, src, input);
        }
        if (ret == null) {
            ret = null;
        }
        return ret;
    }

    private static long range(ParseNode root, List<LexerToken> src, String input) {
        int x = -1;
        int y = -1;
        for (ParseNode child : root.children()) {
            if (!child.contains(digits)) continue;
            if (x == -1) {
                x = Integer.parseInt(src.get((int)child.from).content);
                continue;
            }
            y = Integer.parseInt(src.get((int)child.from).content);
        }
        return Service.lPair(x, y);
    }

    static {
        try {
            testParser = new Earley((Set)UnitTest.getRules()){

                @Override
                protected boolean isIdentifier(int y, List<LexerToken> src, int symbol, Integer suspect) {
                    LexerToken token = src.get(y);
                    return symbol == this.identifier && token.type == Token.IDENTIFIER || symbol == this.identifier && token.type == Token.DQUOTED_STRING || symbol == this.identifier && token.type == Token.BQUOTED_STRING;
                }
            };
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        output = (Integer)UnitTest.testParser.symbolIndexes.get("output");
        tree = (Integer)UnitTest.testParser.symbolIndexes.get("tree");
        assertion = (Integer)UnitTest.testParser.symbolIndexes.get("assertion");
        query = (Integer)UnitTest.testParser.symbolIndexes.get("query");
        atest = (Integer)UnitTest.testParser.symbolIndexes.get("atest");
        node = (Integer)UnitTest.testParser.symbolIndexes.get("node");
        range = (Integer)UnitTest.testParser.symbolIndexes.get("range");
        label = (Integer)UnitTest.testParser.symbolIndexes.get("label");
        digits = (Integer)UnitTest.testParser.symbolIndexes.get("digits");
        sql_fragment = (Integer)UnitTest.testParser.symbolIndexes.get("sql_fragment");
        comment = (Integer)UnitTest.testParser.symbolIndexes.get("comment");
        random = new Random();
        introduceRandomError = false;
        parser = SqlEarley.getInstance();
    }
}

