/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.objects;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.objects.LargeBinary;
import oracle.dbtools.util.encoding.EncodingException;
import oracle.dbtools.util.encoding.EncodingType;
import oracle.sql.Datum;

public class LongBinary
extends LargeBinary {
    public LongBinary() {
    }

    protected LongBinary(LongBinary source) {
        super(source);
    }

    protected LongBinary(Object object) {
        super(object);
    }

    public LongBinary(byte[] value) {
        super(value);
    }

    public LongBinary(File value) {
        super(value);
    }

    public LongBinary(InputStream istream) throws IOException {
        this(istream, 32768);
    }

    public LongBinary(InputStream istream, int cutOverLen) throws IOException {
        this(LongBinary.getBuilder(EncodingType.ENCODING_NONE, cutOverLen).write(istream).build());
    }

    public LongBinary(CharSequence hex) throws IOException, EncodingException {
        this(hex, 32768);
    }

    public LongBinary(CharSequence hex, int cutOverLen) throws IOException, EncodingException {
        this(LongBinary.getBuilder(EncodingType.ENCODING_HEX, cutOverLen).write(new StringReader(hex.toString())).build());
    }

    public LongBinary(char[] chars) throws IOException, EncodingException {
        this(chars, 32768);
    }

    public LongBinary(char[] chars, int cutOverLen) throws IOException, EncodingException {
        this(LongBinary.getBuilder(EncodingType.ENCODING_HEX, cutOverLen).write(new CharArrayReader(chars)).build());
    }

    public LongBinary(Reader reader) throws IOException, EncodingException {
        this(reader, 32768);
    }

    public LongBinary(Reader reader, int cutOverLen) throws IOException, EncodingException {
        this(LongBinary.getBuilder(EncodingType.ENCODING_HEX, cutOverLen).write(reader).build());
    }

    public static LongBinary constructFrom(Object value) throws IOException, SQLException, EncodingException {
        return LongBinary.constructFrom(value, 32768);
    }

    public static LongBinary constructFrom(Object value, int cutOverLen) throws IOException, SQLException, EncodingException {
        if (value instanceof byte[]) {
            return new LongBinary((byte[])value);
        }
        if (value instanceof InputStream) {
            return new LongBinary((InputStream)value, cutOverLen);
        }
        if (value instanceof File) {
            return new LongBinary((File)value);
        }
        if (value instanceof char[]) {
            return new LongBinary((char[])value, cutOverLen);
        }
        if (value instanceof CharSequence) {
            return new LongBinary((CharSequence)value, cutOverLen);
        }
        if (value instanceof Reader) {
            return new LongBinary((Reader)value, cutOverLen);
        }
        if (value instanceof Datum) {
            Datum datumValue = (Datum)value;
            return new LongBinary(datumValue.stringValue(), cutOverLen);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public long getLength() throws SQLException {
        if (this.getValue() instanceof File) {
            return ((File)this.getValue()).length();
        }
        if (this.getValue() instanceof byte[]) {
            return ((byte[])this.getValue()).length;
        }
        return 0L;
    }

    @Override
    public boolean equals(Object obj) {
        boolean isEqual;
        boolean bl = isEqual = this == obj;
        if (!isEqual && obj instanceof LongBinary) {
            isEqual = super.equals(obj);
        }
        return isEqual;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void customFinalize(Object value, boolean deleteOnFinalize) throws Throwable {
        try {
            if (deleteOnFinalize && value instanceof File) {
                ((File)value).delete();
            }
        }
        finally {
            super.customFinalize(value, deleteOnFinalize);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException, SQLException {
        if (this.getValue() instanceof File) {
            return new FileInputStream((File)this.getValue());
        }
        if (this.getValue() instanceof byte[]) {
            return new ByteArrayInputStream((byte[])this.getValue());
        }
        return null;
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider connectionProvider, ValueType valueType, Object target) throws IOException, SQLException {
        switch (valueType) {
            case JDBC: {
                return this.getInputStream();
            }
        }
        return super.customTypedValue(connectionProvider, valueType, target);
    }

    public static LongBinaryBuilder getBuilder() {
        return LongBinary.getBuilder(32768);
    }

    public static LongBinaryBuilder getBuilder(EncodingType encoding, int cutOverLen) {
        return new LongBinary().getBuilder0(encoding, cutOverLen);
    }

    public static LongBinaryBuilder getBuilder(EncodingType encoding) {
        return LongBinary.getBuilder(encoding, 32768);
    }

    public static LongBinaryBuilder getBuilder(int cutOverLen) {
        return new LongBinary().getBuilder0(EncodingType.ENCODING_BASE64, cutOverLen);
    }

    private LongBinaryBuilder getBuilder0(EncodingType encoding, int cutOverLen) {
        return new LongBinaryBuilder(encoding, cutOverLen);
    }

    public class LongBinaryBuilder
    extends LargeBinary.LargeBinaryBuilder {
        protected LongBinaryBuilder(EncodingType encodingType, int cutOverLen) {
            super(encodingType, cutOverLen);
        }

        @Override
        public LongBinary build() throws IOException {
            this.switchableStream.flush();
            this.switchableStream.close();
            if (LongBinary.this.getValue() != null && LongBinary.this.getValue() instanceof File) {
                File file = (File)LongBinary.this.getValue();
                file.setReadOnly();
            } else {
                LongBinary.this.setValue(((ByteArrayOutputStream)this.ostream).toByteArray(), false);
            }
            return LongBinary.this;
        }

        @Override
        public LongBinaryBuilder write(Reader reader) throws IOException, EncodingException {
            return (LongBinaryBuilder)super.write(reader);
        }

        @Override
        public LongBinaryBuilder write(InputStream istream) throws IOException {
            byte[] buf = new byte[2400];
            int len = istream.read(buf);
            while (len != -1) {
                this.write(buf, 0, len);
                len = istream.read(buf);
            }
            return this;
        }

        @Override
        protected void cutOver() throws IOException {
            this.ostream.flush();
            this.ostream.close();
            ByteArrayInputStream sr = new ByteArrayInputStream(((ByteArrayOutputStream)this.ostream).toByteArray());
            File tempFile = File.createTempFile("sqldev", ".tmp");
            tempFile.deleteOnExit();
            FileOutputStream fw = new FileOutputStream(tempFile);
            LargeBinary.copyBytes(sr, fw);
            LongBinary.this.setValue(tempFile, true);
            this.ostream = fw;
        }
    }
}

