/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.objects;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import oracle.dbtools.raptor.datatypes.objects.OraTemporalDatum;
import oracle.dbtools.raptor.nls.FormatType;
import oracle.dbtools.raptor.nls.OraDATEFormat;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.i18n.util.OraLocaleInfo;
import oracle.sql.DATE;
import oracle.sql.Datum;

public class OraDATE
extends OraTemporalDatum {
    public static OraDATE getInstance() {
        OraDATE instance = OraDATE.getInstance(Calendar.getInstance());
        if (instance != null) {
            instance.setNow();
        }
        return instance;
    }

    public static OraDATE getInstance(Calendar calendar) {
        return calendar != null ? new OraDATE(new OraDATEImpl(UTC, calendar, null)) : null;
    }

    public static OraDATE getInstance(DATE date) {
        return date != null ? new OraDATE(new OraDATEImpl(UTC, (Datum)date)) : null;
    }

    public static OraDATE getInstance(Date date) {
        return date != null ? new OraDATE(new OraDATEImpl(UTC, date instanceof Timestamp ? (Timestamp)date : new Timestamp(date.getTime()))) : null;
    }

    protected OraDATE(OraDATEImpl impl) {
        super(impl);
    }

    @Override
    public boolean nanosSupported() {
        return false;
    }

    @Override
    public boolean timeZoneOverlayed() {
        return true;
    }

    @Override
    public void setTimeZone(TimeZone timezone) {
        this.datumImpl.overlayTimeZone(timezone);
    }

    @Override
    public void setSessionTimeZone(TimeZone sessionTimeZone) {
        if (sessionTimeZone == null) {
            this.setTimeZone(UTC);
            this.sessionTimeZoneAdjusted = false;
        } else {
            this.setTimeZone(sessionTimeZone);
            this.sessionTimeZoneAdjusted = true;
        }
    }

    public DATE getDatum() {
        byte[] bytes = new byte[7];
        this.datumImpl.packDatumBytes(bytes);
        return new DATE(bytes);
    }

    public String toString() {
        try {
            OraDATEFormat formatter = new OraDATEFormat(new OracleNLSProvider(null).getDateFormat(FormatType.GENERIC), OraLocaleInfo.getInstance((Locale)Locale.US));
            return formatter.format(this.getDatum());
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    protected static class OraDATEImpl
    extends OraTemporalDatum.OraTemporalDatumImpl {
        protected OraDATEImpl(TimeZone datumTimeZone, Calendar calendar, Integer nanos) {
            super(datumTimeZone, calendar, nanos);
            this.setFractionalPrecision(0);
        }

        protected OraDATEImpl(TimeZone datumTimeZone, Datum date) {
            super(datumTimeZone, date);
            this.setFractionalPrecision(0);
        }

        protected OraDATEImpl(TimeZone datumTimeZone, Timestamp timestamp) {
            super(datumTimeZone, timestamp);
            this.setFractionalPrecision(0);
        }

        @Override
        protected int getDatumLength(int nanos) {
            return 7;
        }

        @Override
        protected boolean isDatumLengthValid(int length) {
            return length == 7;
        }
    }
}

