/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.objects;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import oracle.dbtools.raptor.datatypes.objects.OraTemporalDatum;
import oracle.dbtools.raptor.nls.FormatType;
import oracle.dbtools.raptor.nls.OraConversions;
import oracle.dbtools.raptor.nls.OraTIMESTAMPFormat;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.i18n.util.OraLocaleInfo;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMP;

public class OraTIMESTAMP
extends OraTemporalDatum {
    public static OraTIMESTAMP getInstance() {
        OraTIMESTAMP instance = OraTIMESTAMP.getInstance(Calendar.getInstance());
        if (instance != null) {
            instance.setNow();
        }
        return instance;
    }

    public static OraTIMESTAMP getInstance(Calendar calendar, Integer nanos) {
        return calendar != null ? new OraTIMESTAMP(new OraTIMESTAMPImpl(UTC, calendar, nanos)) : null;
    }

    public static OraTIMESTAMP getInstance(Calendar calendar) {
        return OraTIMESTAMP.getInstance(calendar, null);
    }

    public static OraTIMESTAMP getInstance(TIMESTAMP date) {
        return date != null ? new OraTIMESTAMP(new OraTIMESTAMPImpl(UTC, (Datum)date)) : null;
    }

    public static OraTIMESTAMP getInstance(Date date) {
        return date != null ? new OraTIMESTAMP(new OraTIMESTAMPImpl(UTC, date instanceof Timestamp ? (Timestamp)date : new Timestamp(date.getTime()))) : null;
    }

    protected OraTIMESTAMP(OraTIMESTAMPImpl impl) {
        super(impl);
    }

    @Override
    public boolean timeZoneOverlayed() {
        return true;
    }

    @Override
    public void setTimeZone(TimeZone timezone) {
        this.datumImpl.overlayTimeZone(timezone);
    }

    @Override
    public void setSessionTimeZone(TimeZone sessionTimeZone) {
        if (sessionTimeZone == null) {
            this.setTimeZone(UTC);
            this.sessionTimeZoneAdjusted = false;
        } else {
            this.setTimeZone(sessionTimeZone);
            this.sessionTimeZoneAdjusted = true;
        }
    }

    public TIMESTAMP getDatum() {
        byte[] bytes = new byte[this.datumImpl.getNanos() > 0 ? 11 : 7];
        this.datumImpl.packDatumBytes(bytes);
        return new TIMESTAMP(bytes);
    }

    public String toString() {
        try {
            OraTIMESTAMPFormat formatter = new OraTIMESTAMPFormat(new OracleNLSProvider(null).getTimeStampFormat(FormatType.GENERIC), OraLocaleInfo.getInstance((Locale)Locale.US));
            return formatter.format(this.getDatum());
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    protected static class OraTIMESTAMPImpl
    extends OraTemporalDatum.OraTemporalDatumImpl {
        protected OraTIMESTAMPImpl(TimeZone datumTimeZone, Calendar calendar, Integer nanos) {
            super(datumTimeZone, calendar, nanos);
        }

        protected OraTIMESTAMPImpl(TimeZone datumTimeZone, Datum date) {
            super(datumTimeZone, date);
        }

        protected OraTIMESTAMPImpl(TimeZone datumTimeZone, Timestamp timestamp) {
            super(datumTimeZone, timestamp);
        }

        @Override
        protected int getDatumLength(int nanos) {
            return nanos > 0 ? 11 : 7;
        }

        @Override
        protected boolean isDatumLengthValid(int length) {
            return length == 11 || length == 7;
        }

        @Override
        protected void unpackDatumBytes(byte[] bytes) {
            super.unpackDatumBytes(bytes);
            if (bytes.length > 7) {
                this.setNanos(OraTIMESTAMPImpl.unpackNanos(bytes));
            }
        }

        @Override
        protected void packDatumBytes(byte[] bytes) {
            super.packDatumBytes(bytes);
            int nanos = this.getNanos();
            if (nanos > 0 || bytes.length > 7) {
                OraTIMESTAMPImpl.packNanos(bytes, nanos);
            }
        }

        private static int unpackNanos(byte[] bytes) {
            return OraConversions.convertNanos(bytes);
        }

        private static void packNanos(byte[] bytes, int nanos) {
            bytes[7] = (byte)(nanos >> 24 & 0xFF);
            bytes[8] = (byte)(nanos >> 16 & 0xFF);
            bytes[9] = (byte)(nanos >> 8 & 0xFF);
            bytes[10] = (byte)(nanos & 0xFF);
        }
    }
}

