/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.objects;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import oracle.dbtools.raptor.datatypes.objects.OraTIMESTAMP;
import oracle.dbtools.raptor.datatypes.objects.OraTemporalDatum;
import oracle.dbtools.raptor.nls.FormatType;
import oracle.dbtools.raptor.nls.OraTIMESTAMPLTZFormat;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.i18n.util.OraLocaleInfo;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMPLTZ;

public class OraTIMESTAMPLTZ
extends OraTemporalDatum {
    private TimeZone dbTimeZone;

    public static OraTIMESTAMPLTZ getInstance() {
        return OraTIMESTAMPLTZ.getInstance(TimeZone.getDefault());
    }

    public static OraTIMESTAMPLTZ getInstance(TimeZone sessionTimeZone, TimeZone dbTimeZone) {
        OraTIMESTAMPLTZ instance = OraTIMESTAMPLTZ.getInstance(Calendar.getInstance(sessionTimeZone), null, sessionTimeZone, dbTimeZone);
        if (instance != null) {
            instance.setNow();
        }
        return instance;
    }

    public static OraTIMESTAMPLTZ getInstance(TimeZone sessionTimeZone) {
        return OraTIMESTAMPLTZ.getInstance(sessionTimeZone, sessionTimeZone);
    }

    public static OraTIMESTAMPLTZ getInstance(Calendar calendar, Integer nanos, TimeZone sessionTimeZone, TimeZone dbTimeZone) {
        OraTIMESTAMPLTZ instance;
        OraTIMESTAMPLTZ oraTIMESTAMPLTZ = instance = calendar != null ? new OraTIMESTAMPLTZ(new OraTIMESTAMPLTZImpl(dbTimeZone, calendar, nanos)) : null;
        if (instance != null) {
            instance.setSessionTimeZone(sessionTimeZone);
        }
        return instance;
    }

    public static OraTIMESTAMPLTZ getInstance(Calendar calendar, Integer nanos, TimeZone sessionTimeZone) {
        return OraTIMESTAMPLTZ.getInstance(calendar, nanos, sessionTimeZone, sessionTimeZone);
    }

    public static OraTIMESTAMPLTZ getInstance(Calendar calendar, Integer nanos) {
        return OraTIMESTAMPLTZ.getInstance(calendar, nanos, TimeZone.getDefault());
    }

    public static OraTIMESTAMPLTZ getInstance(Calendar calendar, TimeZone sessionTimeZone, TimeZone dbTimeZone) {
        return OraTIMESTAMPLTZ.getInstance(calendar, null, sessionTimeZone, dbTimeZone);
    }

    public static OraTIMESTAMPLTZ getInstance(Calendar calendar, TimeZone sessionTimeZone) {
        return OraTIMESTAMPLTZ.getInstance(calendar, sessionTimeZone, sessionTimeZone);
    }

    public static OraTIMESTAMPLTZ getInstance(Calendar calendar) {
        return OraTIMESTAMPLTZ.getInstance(calendar, TimeZone.getDefault());
    }

    public static OraTIMESTAMPLTZ getInstance(TIMESTAMPLTZ date, TimeZone sessionTimeZone, TimeZone dbTimeZone) {
        OraTIMESTAMPLTZ instance;
        OraTIMESTAMPLTZ oraTIMESTAMPLTZ = instance = date != null ? new OraTIMESTAMPLTZ(new OraTIMESTAMPLTZImpl(dbTimeZone, (Datum)date)) : null;
        if (instance != null) {
            instance.setSessionTimeZone(sessionTimeZone);
        }
        return instance;
    }

    public static OraTIMESTAMPLTZ getInstance(TIMESTAMPLTZ date, TimeZone sessionTimeZone) {
        return OraTIMESTAMPLTZ.getInstance(date, sessionTimeZone, sessionTimeZone);
    }

    public static OraTIMESTAMPLTZ getInstance(TIMESTAMPLTZ date) {
        return OraTIMESTAMPLTZ.getInstance(date, TimeZone.getDefault());
    }

    public static OraTIMESTAMPLTZ getInstance(Date date, TimeZone sessionTimeZone, TimeZone dbTimeZone) {
        OraTIMESTAMPLTZ instance;
        OraTIMESTAMPLTZ oraTIMESTAMPLTZ = date != null ? new OraTIMESTAMPLTZ(new OraTIMESTAMPLTZImpl(dbTimeZone, date instanceof Timestamp ? (Timestamp)date : new Timestamp(date.getTime()))) : (instance = null);
        if (instance != null) {
            instance.setSessionTimeZone(sessionTimeZone);
        }
        return instance;
    }

    public static OraTIMESTAMPLTZ getInstance(Date date, TimeZone sessionTimeZone) {
        return OraTIMESTAMPLTZ.getInstance(date, sessionTimeZone, sessionTimeZone);
    }

    public static OraTIMESTAMPLTZ getInstance(Date date) {
        return OraTIMESTAMPLTZ.getInstance(date, TimeZone.getDefault());
    }

    protected OraTIMESTAMPLTZ(OraTIMESTAMPLTZImpl impl) {
        super(impl, true);
        this.dbTimeZone = impl.getTimeZone();
    }

    @Override
    public Object clone() {
        OraTIMESTAMPLTZ other = (OraTIMESTAMPLTZ)super.clone();
        other.dbTimeZone = this.dbTimeZone;
        return other;
    }

    @Override
    public void replicate(OraTemporalDatum value) {
        super.replicate(value);
        if (value instanceof OraTIMESTAMPLTZ) {
            this.setDBTimeZone(((OraTIMESTAMPLTZ)value).getDBTimeZone());
        }
    }

    @Override
    public void setSessionTimeZone(TimeZone sessionTimeZone) {
        this.setTimeZone(sessionTimeZone);
    }

    public final TimeZone getDBTimeZone() {
        return this.dbTimeZone;
    }

    public final void setDBTimeZone(TimeZone dbTimeZone) {
        this.dbTimeZone = dbTimeZone;
    }

    public TIMESTAMPLTZ getDatum(TimeZone dbTimeZone) {
        byte[] bytes = new byte[this.datumImpl.getNanos() > 0 ? 11 : 7];
        OraTIMESTAMPLTZImpl dbImpl = (OraTIMESTAMPLTZImpl)this.datumImpl;
        if (!OraTIMESTAMPLTZ.areEqual(dbTimeZone, dbImpl.getTimeZone())) {
            dbImpl = (OraTIMESTAMPLTZImpl)dbImpl.clone();
            dbImpl.setTimeZone(dbTimeZone);
        }
        dbImpl.packDatumBytes(bytes);
        return new TIMESTAMPLTZ(bytes);
    }

    public TIMESTAMPLTZ getDatum() {
        return this.getDatum(this.getDBTimeZone());
    }

    public String toString() {
        try {
            OraTIMESTAMPLTZFormat formatter = new OraTIMESTAMPLTZFormat(new OracleNLSProvider(null).getTimeStampWithTimeZoneFormat(FormatType.GENERIC), OraLocaleInfo.getInstance((Locale)Locale.US), this.getDBTimeZone(), this.getSessionTimeZone());
            return formatter.format(this.getDatum());
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    protected static class OraTIMESTAMPLTZImpl
    extends OraTIMESTAMP.OraTIMESTAMPImpl {
        protected OraTIMESTAMPLTZImpl(TimeZone dbTimeZone, Calendar calendar, Integer nanos) {
            super(dbTimeZone, calendar, nanos);
        }

        protected OraTIMESTAMPLTZImpl(TimeZone dbTimeZone, Datum date) {
            super(dbTimeZone, date);
        }

        protected OraTIMESTAMPLTZImpl(TimeZone dbTimeZone, Timestamp timestamp) {
            super(dbTimeZone, timestamp);
        }
    }
}

