/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.xml;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Map;
import javax.xml.transform.sax.TransformerHandler;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeMarshallingException;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.marshal.DataValueMarshalHandler;
import oracle.dbtools.raptor.datatypes.xml.XMLUtil;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.dbtools.util.encoding.BASE64Encoding;
import oracle.dbtools.util.encoding.EncodingException;
import oracle.dbtools.util.encoding.EncodingFactory;
import oracle.dbtools.util.encoding.EncodingType;
import oracle.dbtools.util.encoding.MimeType;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DataValueXMLMarshalHandler
implements DataValueMarshalHandler {
    protected TransformerHandler hd;
    protected Writer marshallWriter;

    public DataValueXMLMarshalHandler(TransformerHandler hd) {
        this.hd = hd;
        this.marshallWriter = new MarshallWriter(hd);
    }

    @Override
    public StringType getStringType() {
        return StringType.GENERIC;
    }

    @Override
    public void marshal(DataValue value, String name) {
        value.marshal(this, name);
    }

    @Override
    public final void marshal(DataValue value) {
        value.marshal(this);
    }

    @Override
    public void startDataValue(DataType datatype, String name, boolean isNull, Map<String, Object> propertyMap) {
        AttributesImpl atts = new AttributesImpl();
        if (propertyMap != null) {
            for (Map.Entry<String, Object> entry : propertyMap.entrySet()) {
                if (entry.getValue() == null) continue;
                XMLUtil.setAttribute(atts, entry.getKey(), entry.getValue().toString());
            }
        }
        if (isNull) {
            XMLUtil.markNull(atts);
        }
        if (name != null) {
            XMLUtil.setName(atts, name);
        }
        try {
            XMLUtil.startDataValueElement(this.hd, atts);
        }
        catch (SAXException e) {
            throw new DataTypeMarshallingException(name, datatype, e);
        }
    }

    @Override
    public void startDataValue(DataType datatype, String name, boolean isNull) {
        this.startDataValue(datatype, name, isNull, null);
    }

    @Override
    @Deprecated
    public void bodyDataValue(DataType datatype, String name, String value) {
        if (value != null) {
            this.bodyDataValue(datatype, name, value.toCharArray(), 0, value.length());
        }
    }

    @Override
    public void bodyDataValue(DataType datatype, String name, Readable text) {
        BufferedWriter writer = new BufferedWriter(this.marshallWriter, 2400);
        try {
            DataTypesUtil.copyCharacters(text, writer);
        }
        catch (IOException e) {
            throw new DataTypeMarshallingException(name, datatype, e.getCause() instanceof SAXException ? e.getCause() : e);
        }
        try {
            writer.flush();
        }
        catch (IOException e) {
            throw new DataTypeMarshallingException(name, datatype, e);
        }
    }

    @Override
    public void bodyDataValue(DataType datatype, String name, InputStream bytes) {
        BASE64Encoding b64Enc = (BASE64Encoding)EncodingFactory.getEncoder(EncodingType.ENCODING_BASE64, MimeType.MIME_TEXT);
        BufferedWriter writer = new BufferedWriter(this.marshallWriter, 2400);
        try {
            b64Enc.encode(bytes, writer);
        }
        catch (EncodingException e) {
            throw new DataTypeMarshallingException(name, datatype, e);
        }
        catch (IOException e) {
            throw new DataTypeMarshallingException(name, datatype, e.getCause() instanceof SAXException ? e.getCause() : e);
        }
        try {
            writer.flush();
        }
        catch (IOException e) {
            throw new DataTypeMarshallingException(name, datatype, e);
        }
    }

    @Override
    public void bodyDataValue(DataType datatype, String name, char[] ch, int start, int length) {
        if (ch != null) {
            try {
                this.hd.characters(ch, start, length);
            }
            catch (SAXException e) {
                throw new DataTypeMarshallingException(name, datatype, e);
            }
        }
    }

    @Override
    public void endDataValue(DataType datatype, String name, boolean isNull) {
        try {
            XMLUtil.endDataValueElement(this.hd);
        }
        catch (SAXException e) {
            throw new DataTypeMarshallingException(name, datatype, e);
        }
    }

    protected class MarshallWriter
    extends Writer {
        public MarshallWriter(TransformerHandler hd) {
            super(hd);
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            try {
                ((TransformerHandler)this.lock).characters(cbuf, off, len);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

