/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.utils.IListPrinter;
import oracle.dbtools.raptor.utils.ListPrinter;
import oracle.jdbc.OracleConnection;

public class ApexCmd
extends CommandListener
implements IHelp {
    private static final String PADDING = "                                                                                                                    ";
    static QueryXMLSupport s_xml = null;
    private static IListPrinter _listPrinter = new ListPrinter();

    protected static synchronized QueryXMLSupport getXMLQueries() {
        if (s_xml == null) {
            s_xml = QueryXMLSupport.getQueryXMLSupport(new MetaResource(ApexCmd.class.getClassLoader(), "oracle/dbtools/raptor/newscriptrunner/commands/describe.xml"));
        }
        return s_xml;
    }

    @Override
    public String getCommand() {
        return "APEX";
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getSql().toLowerCase().startsWith("apex")) {
            String filter;
            String[] parts = cmd.getSql().trim().split(" ");
            String base = parts[0];
            String subCmd = parts.length > 1 && parts[1] != null ? parts[1] : "list";
            String string = filter = parts.length > 2 && parts[2] != null ? parts[2] : null;
            if (subCmd.trim().equalsIgnoreCase("")) {
                subCmd = "list";
            }
            if (conn == null) {
                ctx.write(Messages.getString("ApexCmd.7"));
                ctx.errorLog(ctx.getSourceRef(), Messages.getString("ApexCmd.7"), cmd.getSql());
                return true;
            }
            String report = null;
            if (subCmd.equalsIgnoreCase("list")) {
                report = "apex.list";
                this.printList(conn, ctx, report);
            } else if (subCmd.equalsIgnoreCase("log")) {
                report = "apex.log";
                this.printList(conn, ctx, report);
            } else if (subCmd.equalsIgnoreCase("export") && filter != null) {
                try {
                    int x = Integer.parseInt(filter);
                    ctx.write(this.getDDL(conn, filter));
                }
                catch (NumberFormatException e) {
                    ctx.write(Messages.getString("ApexCmd.0"));
                }
            }
            return true;
        }
        return false;
    }

    private void printList(Connection conn, ScriptRunnerContext ctx, String report) {
        Properties props = ((OracleConnection)conn).getProperties();
        Query colSQL = ApexCmd.getXMLQueries().getQuery(report, conn);
        DBUtil dbUtil = DBUtil.getInstance(conn);
        HashMap binds = new HashMap();
        List<List<?>> rows = dbUtil.executeReturnListofList(colSQL.getSql(), binds);
        _listPrinter.printListofList(ctx, rows);
    }

    public String getDDL(Connection conn, String filter) {
        SQLException e;
        DBUtil dbUtil = DBUtil.getInstance(conn);
        HashMap<String, String> binds = new HashMap<String, String>();
        binds.put("APPLICATION_ID", filter);
        String worspaceId = dbUtil.executeReturnOneCol("select workspace_id from apex_applications where application_id = :APPLICATION_ID", binds);
        binds.put("WORKSPACE_ID", worspaceId);
        String OWA_INIT = "declare  nm     owa.vc_arr;    vl     owa.vc_arr;    begin   nm(1) := 'WEB_AUTHENT_PREFIX';  vl(1) := 'WEB$';  owa.init_cgi_env( 1, nm, vl );  sys.htp.htbuf_len := 84;  end;";
        dbUtil.execute(OWA_INIT);
        dbUtil.execute("begin apex_util.export_application(p_application_id=>:APPLICATION_ID,p_workspace_id=>:WORKSPACE_ID); end; ", binds);
        String ret = this.getOWA(conn);
        if (ret != null && ret.indexOf("\n\n") > -1) {
            ret = ret.substring(ret.indexOf("\n\n"));
        }
        if ((e = DBUtil.getInstance(conn).getLastException()) != null) {
            return "\n" + e.getMessage();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOWA(Connection conn) {
        CallableStatement cs = null;
        String parcialContent = null;
        try {
            String GET_PAGE = "declare    l_buf  varchar2(32767);    l_clob CLOB;    l_lines htp.htbuf_arr;    l_num   number := 999999;  begin    dbms_lob.createtemporary(l_clob, TRUE);    OWA.GET_PAGE(l_lines, l_num);    for i in 1..l_num loop      dbms_lob.append(l_clob,l_lines(i));    end loop;    ? := l_clob; end;";
            cs = conn.prepareCall(GET_PAGE);
            cs.registerOutParameter(1, 2005);
            cs.execute();
            Clob clob = cs.getClob(1);
            parcialContent = clob.getSubString(1L, (int)clob.length());
        }
        catch (SQLException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        finally {
            if (cs != null) {
                try {
                    cs.close();
                }
                catch (Exception exception) {}
            }
        }
        return parcialContent;
    }

    public static void setListPrinter(IListPrinter listprinter) {
        _listPrinter = listprinter;
    }
}

