/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Set;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowPrefixNameNewline;

public class SetDDLSettings
extends CommandListener
implements IHelp,
IShowCommand,
IShowPrefixNameNewline {
    private static final Object DDL = "ddl";
    private static final Object ON = "on";
    private static final Object OFF = "off";

    @Override
    public String[] getShowAliases() {
        return new String[]{"DDL"};
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getDDLOptions() != null) {
            Set<String> options = ctx.getDDLOptions().keySet();
            if (ctx.getDDLOptions().get("DEFAULT").equals("ON")) {
                ctx.write("DEFAULT : ON\n");
            } else {
                for (String option : options) {
                    if (option.equals("DEFAULT")) continue;
                    ctx.write(MessageFormat.format("{0} : {1}\n", option, ctx.getDDLOptions().get(option)));
                }
            }
        }
        return true;
    }

    @Override
    public String getCommand() {
        return "DDL";
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getSql().trim().toLowerCase().replaceAll(" ", "").startsWith("setddl")) {
            String[] cmds = cmd.getSQLOrig().toLowerCase().split("\\s+");
            int length = cmds.length;
            if (length == 3 && cmds[1].toLowerCase().equals(DDL) && cmds[2].toLowerCase().equals(OFF)) {
                String defaultsql = "begin dbms_metadata.set_transform_param(dbms_metadata.session_transform,'DEFAULT',true); end;";
                DBUtil dbUtil = DBUtil.getInstance(conn);
                dbUtil.execute(defaultsql);
                ctx.setDDLOptions("DEFAULT", "ON");
                ctx.write("DDL default generation reset\n");
                return true;
            }
            if (length == 4) {
                if (cmds[1].toLowerCase().equals(DDL) && (cmds[3].toLowerCase().equals(ON) || cmds[3].toLowerCase().equals(OFF))) {
                    String on = cmds[3].toLowerCase().equals(ON) ? "true" : "false";
                    String option = cmds[2].toUpperCase();
                    String optionSQL = "";
                    optionSQL = on.equals("true") ? "begin dbms_metadata.set_transform_param(dbms_metadata.session_transform,:OPTION,true); end;" : "begin dbms_metadata.set_transform_param(dbms_metadata.session_transform,:OPTION,false); end;";
                    HashMap<String, String> binds = new HashMap<String, String>();
                    binds.put("OPTION", option);
                    try {
                        DBUtil dbUtil = DBUtil.getInstance(conn);
                        dbUtil.execute(optionSQL, binds);
                        ctx.write(MessageFormat.format("DDL Option {0} {1}\n", option, cmds[3].toLowerCase()));
                        ctx.setDDLOptions(option, cmds[3].toUpperCase());
                        if (cmds[3].toUpperCase().equals("OFF")) {
                            ctx.setDDLOptions("DEFAULT", "OFF");
                        }
                    }
                    catch (Exception e) {
                        ctx.write("Not a valid transform option\n");
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }
}

