/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import oracle.dbtools.raptor.format.FormatRegistry;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;

public class SetSQLFormat
extends CommandListener
implements IShowCommand {
    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getSql().trim().toLowerCase().replaceAll(" ", "").startsWith("setsqlformat")) {
            String[] parts = cmd.getSQLOrig().split(" ");
            if (parts.length < 3 || parts.length == 3 && parts[2].equalsIgnoreCase("default")) {
                ctx.write(Messages.getString("SQLFORMATCLEARED"));
                ctx.putProperty("sql.format", null);
                return true;
            }
            String format = parts[2].trim();
            if (format == null || !this.isValid(format) || FormatRegistry.getFormatter(format) == null) {
                ctx.write(Messages.getString("SQLFORMATBAD"));
                return true;
            }
            ctx.putProperty("sql.format", format);
            ctx.putProperty("sql.format.full", parts);
            return true;
        }
        return false;
    }

    private boolean isValid(String format) {
        boolean valid = false;
        ArrayList list = (ArrayList)FormatRegistry.getAllTypes();
        for (int i = 0; i < list.size(); ++i) {
            if (!((String)list.get(i)).equalsIgnoreCase(format)) continue;
            return true;
        }
        return valid;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String format = null;
        format = ctx.getProperties().containsKey("sql.format") && ctx.getProperties().get("sql.format") != null ? (String)ctx.getProperties().get("sql.format") : "Default";
        ctx.write("");
        ctx.write(MessageFormat.format(Messages.getString("SQLFORMAT"), format) + "\n");
        return true;
    }

    @Override
    public String[] getShowAliases() {
        return new String[]{"sqlformat"};
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }
}

