/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.Show;
import oracle.dbtools.raptor.newscriptrunner.commands.StoreRegistry;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.jdbc.OracleConnection;

public class ShowHeading
implements IShowCommand,
IStoreCommand {
    private static final String[] SHOWHEADING = new String[]{"hea", "head", "headi", "headin", "heading"};

    @Override
    public String[] getShowAliases() {
        return SHOWHEADING;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() == null || ctx.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowHeading(conn, ctx, cmd);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private boolean doShowHeading(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String onoroff = (String)ctx.getProperty("script.runner.setheading");
        if (onoroff.matches("(?i:on|off)")) {
            String str = MessageFormat.format(Messages.getString("HEADING"), onoroff) + Show.m_lineSeparator;
            ctx.write(str);
        }
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        return StoreRegistry.getCommand("heading", (String)ctx.getProperty("script.runner.setheading"));
    }
}

