/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowPrefixNameNewline;
import oracle.jdbc.OracleConnection;

public class ShowInternalErrors
implements IShowCommand,
IShowPrefixNameNewline {
    private static final String[] SHOWINTERNALERROR = new String[]{"internalerrors"};

    @Override
    public String[] getShowAliases() {
        return SHOWINTERNALERROR;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() == null || ctx.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowInternalError(conn, ctx, cmd);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    private boolean doShowInternalError(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        try {
            for (String val : new String[]{"sqldev.error", "sqldev.error.any.in", "script.runner.autocommit.errorFlag", "sqldev.last.err.message", "sqldev.last.err.message.forsqlcode"}) {
                if (ctx.getProperty(val) != null) {
                    ctx.write(val.toLowerCase() + " \"" + ctx.getProperty(val).toString() + "\"\n");
                    continue;
                }
                ctx.write(val.toLowerCase() + " \"\" \n");
            }
        }
        catch (Exception e) {
            ctx.write(e.getLocalizedMessage());
        }
        return true;
    }
}

