/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.StoreRegistry;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.jdbc.OracleConnection;

public class ShowTrimout
implements IShowCommand,
IStoreCommand {
    private static final String[] SHOWTRIMOUT = new String[]{"trim", "trimo", "trimou", "trimout"};

    @Override
    public String[] getShowAliases() {
        return SHOWTRIMOUT;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() == null || ctx.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowTrimout(conn, ctx, cmd);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private boolean doShowTrimout(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        Boolean setting = (Boolean)ctx.getProperty("script.runner.settrimout");
        if (setting != null && setting.equals(Boolean.TRUE)) {
            ctx.write("trimout ON\n");
        } else {
            ctx.write("trimout OFF\n");
        }
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        Boolean setting = (Boolean)ctx.getProperty("script.runner.settrimout");
        if (setting != null && setting.equals(Boolean.TRUE)) {
            return StoreRegistry.getCommand("trimout", "ON");
        }
        return StoreRegistry.getCommand("trimout", "OFF");
    }
}

