/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ssh.core;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import oracle.dbtools.raptor.ssh.core.HostConnection;
import oracle.dbtools.raptor.ssh.core.TunnelDescriptor;

public final class Tunnel {
    private final HostConnection mOwningConnection;
    private final TunnelDescriptor mDesc;
    private int mPort = -1;

    private static String getForwarding(TunnelDescriptor desc) {
        int origin = desc.getPort();
        String hostname = desc.getHostname();
        int hostport = desc.getHostport();
        return (origin < 0 ? 0 : origin) + ":" + hostname + ":" + hostport;
    }

    Tunnel(HostConnection conn, TunnelDescriptor desc) {
        this.mOwningConnection = conn;
        this.mDesc = desc;
    }

    public int getPort() {
        return this.mPort;
    }

    public HostConnection getConnection() {
        return this.mOwningConnection;
    }

    public TunnelDescriptor getDescriptor() {
        return this.mDesc;
    }

    synchronized int connect() throws JSchException {
        Session session = this.mOwningConnection.getSession();
        String conf = Tunnel.getForwarding(this.mDesc);
        switch (this.mDesc.getType()) {
            case LOCAL: {
                this.mPort = session.setPortForwardingL(conf);
                break;
            }
            case REMOTE: {
                this.mPort = session.setPortForwardingR(conf);
                break;
            }
            default: {
                this.mPort = -1;
            }
        }
        return this.mPort;
    }

    synchronized void disconnect() throws JSchException {
        Session session = this.mOwningConnection.getSession();
        if (this.mPort > 0) {
            switch (this.mDesc.getType()) {
                case LOCAL: {
                    session.delPortForwardingL(this.mPort);
                    break;
                }
                case REMOTE: {
                    session.delPortForwardingR(this.mPort);
                }
            }
            this.mPort = -1;
        }
    }
}

