/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.utils.IListPrinter;
import oracle.dbtools.raptor.utils.NLSUtils;

public class ListPrinter
implements IListPrinter {
    @Override
    public String getValue(Map<String, ?> m, String key) {
        if (m.get(key) == null) {
            return "";
        }
        return m.get(key).toString();
    }

    @Override
    public int getWidest(List<Map<String, ?>> cols, String string) {
        int ret = string.length();
        for (Map<String, ?> m : cols) {
            if (m.get(string) == null) continue;
            int l = m.get(string).toString().length();
            ret = l > ret ? (ret = l) : ret;
        }
        return ret;
    }

    @Override
    public void print(ScriptRunnerContext ctx, List<Map<String, ?>> rows) {
        if (rows.size() > 0) {
            int[] widths = new int[rows.get(0).size()];
            String[] colName = new String[rows.get(0).size()];
            int i = 0;
            Iterator<Object> i$ = rows.get(0).keySet().iterator();
            while (i$.hasNext()) {
                String string;
                colName[i] = string = i$.next();
                widths[i] = this.getWidest(rows, string) + 2;
                ++i;
            }
            i = 0;
            for (String string : rows.get(0).keySet()) {
                this.writeBoldUnderlineFormat(ctx, string, widths[i]);
                ++i;
            }
            ctx.write("\n");
            for (Map map : rows) {
                i = 0;
                for (String col : colName) {
                    ctx.write(String.format("%-" + widths[i] + "s", this.getValue(map, col)));
                    ++i;
                }
                ctx.write("\n");
            }
            ctx.write("\n");
        } else {
            ctx.write("No Data Found.");
        }
    }

    @Override
    public void printListofList(ScriptRunnerContext ctx, List<List<?>> rows) {
        try {
            this.print(ctx.getOutputStream(), ctx.getCurrentConnection(), rows);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void printListofList(ScriptRunnerContext ctx, String title, List<List<?>> rows) {
        if (title != null) {
            ctx.write(title + "\n");
        }
        this.printListofList(ctx, rows);
    }

    @Override
    public void print(OutputStream outStream, Connection conn, List<List<?>> rows) throws IOException {
        this.print(outStream, conn, rows, 0);
    }

    @Override
    public void print(OutputStream outStream, Connection conn, List<List<?>> rows, int pageSize) throws IOException {
        this.print(outStream, conn, rows, pageSize, "");
    }

    @Override
    public void print(OutputStream outStream, Connection conn, List<List<?>> rows, int pageSize, String nullDisplay) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(outStream);
        if (rows != null && rows.size() > 0) {
            int i;
            int[] widths = new int[rows.get(0).size()];
            for (List<?> row : rows) {
                for (i = 0; i < row.size(); ++i) {
                    if (row.get(i) == null || widths[i] >= row.get(i).toString().length() + 2) continue;
                    widths[i] = row.get(i).toString().length() + 2;
                }
            }
            int j = 0;
            List<?> headers = rows.get(0);
            rows.remove(0);
            i = 0;
            for (List<?> row : rows) {
                int ii = 0;
                if (i == 0 || pageSize != 0 && i % pageSize == 0) {
                    this.printHeaders(out, widths, j, headers);
                }
                for (Object col : row) {
                    String val = NLSUtils.format(conn, col);
                    if (val == null) {
                        String string = val = nullDisplay != null ? nullDisplay : "";
                    }
                    if (col != null && col.toString().indexOf("@|") >= 0 && col.toString().indexOf("|@") > 0) {
                        try {
                            this.printValue(out, widths[ii], val);
                        }
                        catch (IllegalArgumentException e) {
                            out.write(e.getLocalizedMessage());
                        }
                    } else {
                        out.write(String.format("%-" + widths[ii] + "s", val));
                    }
                    ++ii;
                }
                out.write("\n");
                ++i;
            }
            out.write("\n");
        } else {
            out.write("No Data Found.");
        }
        out.flush();
    }

    @Override
    public void printHeaders(OutputStreamWriter out, int[] widths, int j, List<?> headers) throws IOException {
        for (Object col : headers) {
            if (col.toString().indexOf("@|") >= 0 && col.toString().indexOf("|@") > 0) {
                out.write(String.format("%-" + widths[j] + "s", col.toString()));
            } else {
                out.write(String.format("%-" + widths[j] + "s", col.toString()));
            }
            ++j;
        }
        out.write("\n");
    }

    @Override
    public void writeBoldUnderlineFormat(ScriptRunnerContext ctx, String col, int i) {
        ctx.write(String.format("%-" + i + "s", col));
    }

    @Override
    public void printValue(OutputStreamWriter out, int i, String val) throws IOException {
        out.write(String.format("%-" + i + "s", val));
    }
}

