/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.xml;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import oracle.dbtools.util.Logger;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public final class MetadataManifest {
    public static final String METADATA_FILE = "META-INF/metadata.json";
    private Collection<String> types;
    private Collection<String> viewers;
    private Collection<String> commonQueries;
    private Collection<DDLInfo> oracleddlinfo;

    public static MetadataManifest createManifest(InputStream in) throws IOException {
        MetadataManifest mf = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            mf = (MetadataManifest)mapper.readValue(in, MetadataManifest.class);
        }
        catch (JsonProcessingException e) {
            Logger.severe(MetadataManifest.class, e.getLocalizedMessage());
        }
        return mf;
    }

    public Collection<String> types() {
        return this.types;
    }

    public Collection<String> viewers() {
        return this.viewers;
    }

    public Collection<String> commonQueries() {
        return this.commonQueries;
    }

    public Collection<DDLInfo> getOracleDDLInfo() {
        return this.oracleddlinfo;
    }

    public static class DDLInfo
    implements Comparable<DDLInfo> {
        String clazz;
        String objectType;
        String ddlId;
        String queryXML;
        Collection<Bind> binds;

        public String getObjectType() {
            return this.objectType;
        }

        public String getQueryXML() {
            return this.queryXML;
        }

        public String getClazz() {
            return this.clazz;
        }

        public String getDdlId() {
            return this.ddlId;
        }

        public Collection<Bind> getBinds() {
            return this.binds;
        }

        public String toString() {
            return this.getObjectType();
        }

        public int hashCode() {
            return this.getObjectType().hashCode();
        }

        @Override
        public int compareTo(DDLInfo ddlInfo) {
            return this.getObjectType().compareTo(ddlInfo.getObjectType());
        }
    }

    public static class Bind
    implements Comparable<Bind> {
        String name;
        String value;

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.getName() + "->" + this.getValue();
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        @Override
        public int compareTo(Bind bind) {
            return this.toString().compareTo(bind.toString());
        }
    }
}

