/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dependency.index;

import java.net.URL;
import oracle.ide.Ide;
import oracle.ide.dependency.IdDeclaration;
import oracle.ide.dependency.SourceDeclaration;
import oracle.ide.dependency.SourceUtils;
import oracle.ide.dependency.index.DependencyCriteria;
import oracle.ide.index.IndexingContext;
import oracle.ide.index.QueryCriteria;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;

public abstract class IndexDeclaration
extends IdDeclaration
implements SourceDeclaration {
    private Workspace workspace;
    private Project project;
    private URL url;
    private int startOffset;
    private int endOffset;

    public IndexDeclaration(String id, IndexingContext context, int startOffset, int endOffset) {
        this(id, Ide.getActiveWorkspace(), context.getProject(), context.getURL(), startOffset, endOffset);
    }

    public IndexDeclaration(String id, Workspace workspace, Project project, URL url, int startOffset, int endOffset) {
        super(id);
        this.workspace = workspace;
        this.project = project;
        this.url = url;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    @Override
    public Workspace getWorkspace() {
        return this.workspace;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public void show() {
        SourceUtils.openSourceFile(this.getWorkspace(), this.getProject(), this.getURL(), this.getStartOffset(), this.getEndOffset());
    }

    public QueryCriteria getQueryCriteria() {
        return DependencyCriteria.getDeclarationCriteria(this.id);
    }
}

