/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.awt.Component;
import java.awt.Container;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

class FocusHelper {
    private Container _container;
    private boolean _methodsAvailable;
    private Object _focusPolicy;
    private Method _isRoot;
    private Method _setRoot;
    private Method _getPolicy;
    private Method _setPolicy;

    public FocusHelper(Container cont) {
        this._container = cont;
        this._initialize();
    }

    public void remove(Component c) {
        if (this._methodsAvailable) {
            this._remove(c);
        } else {
            this._container.remove(c);
        }
    }

    private void _remove(Component c) {
        Object wasFocusCycleRoot = null;
        Object focusPolicy = null;
        try {
            wasFocusCycleRoot = this._isRoot.invoke((Object)this._container, (Object[])null);
            focusPolicy = this._getPolicy.invoke((Object)this._container, (Object[])null);
            this._setRoot.invoke((Object)this._container, Boolean.TRUE);
            this._setPolicy.invoke((Object)this._container, this._focusPolicy);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._container.remove(c);
        try {
            if (wasFocusCycleRoot != null) {
                this._setRoot.invoke((Object)this._container, wasFocusCycleRoot);
            }
            if (focusPolicy != null) {
                this._setPolicy.invoke((Object)this._container, focusPolicy);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void _initialize() {
        try {
            Class<?> c = Class.forName("oracle.bali.inspector.FocusPolicy");
            Class[] constructorParams = new Class[]{Component.class};
            Constructor<?> constructor = c.getConstructor(constructorParams);
            if (constructor != null) {
                Object[] args = new Object[]{this._container};
                this._focusPolicy = constructor.newInstance(args);
            }
            this._isRoot = Container.class.getMethod("isFocusCycleRoot", null);
            this._getPolicy = Container.class.getMethod("getFocusTraversalPolicy", null);
            Class[] setRootClasses = new Class[]{Boolean.TYPE};
            this._setRoot = Container.class.getMethod("setFocusCycleRoot", setRootClasses);
            Class[] setPolicyClasses = new Class[]{Class.forName("java.awt.FocusTraversalPolicy")};
            this._setPolicy = Container.class.getMethod("setFocusTraversalPolicy", setPolicyClasses);
            this._methodsAvailable = this._focusPolicy != null && this._isRoot != null && this._getPolicy != null && this._setRoot != null && this._setPolicy != null;
        }
        catch (Exception e) {
            this._methodsAvailable = false;
        }
        catch (NoClassDefFoundError ncdfe) {
            this._methodsAvailable = false;
        }
    }
}

