/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.beans.PropertyChangeListener;
import java.text.Collator;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import oracle.bali.inspector.IntVector;
import oracle.bali.inspector.PropertyExpansionState;
import oracle.bali.inspector.PropertyGroup;
import oracle.bali.inspector.PropertyInspector;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.Sort;
import oracle.bali.share.sort.StringComparator;
import oracle.bali.share.util.IntegerUtils;

class PropertyFilterer
extends PropertyModel
implements TableModelListener {
    public static final int SORT_MODE_NONE = 0;
    public static final int SORT_MODE_ALPHABETIZED = 1;
    public static final int SORT_MODE_CATEGORIZED = 2;
    private static final Object[] _FILTERED_COLUMNS = new Object[]{COLUMN_EDITOR_FACTORY, COLUMN_IS_WRITABLE, COLUMN_IS_READABLE};
    private static final Object[] _FILTERED_VALUES = new Object[]{null, Boolean.FALSE, Boolean.FALSE};
    private static final Object[] _COLUMN_DEFAULTS = new Object[]{null, Boolean.TRUE, Boolean.TRUE};
    private transient TableModelListener _drilledModelListener = new DrillDSListen();
    private PropertyInspector _inspector;
    private transient int _nameColumnIndex;
    private transient int _levelColumnIndex;
    private transient int _drillableColumnIndex;
    private transient int[] _filteredIndices;
    private Object[] _filteredValues;
    private Object[] _filteredColumns;
    private Object[] _filteredDefaults;
    private Object[] _columnMapping;
    private boolean _useIntersection = false;
    private PropertyModel _filteredModel;
    private boolean _readOnlyIncluded = false;
    private boolean _writeOnlyIncluded = false;
    private int _sortMode = 2;
    private transient Hashtable _propertyModels = new Hashtable();
    private transient Hashtable _isModelExpanded = new Hashtable();
    private transient Vector _groups = new Vector();
    private transient BitSet _isGroupExpanded = new BitSet();
    private transient int[] _groupedNewToOld;
    private transient int[] _groupedOldToNew;
    private transient int[] _sortedNewToOld;
    private transient int[] _sortedOldToNew;
    private transient int[] _filteredNewToOld;
    private transient int[] _filteredOldToNew;
    private boolean _alphabetize;

    protected PropertyFilterer(PropertyModel filteredModel, PropertyInspector inspector) {
        if (filteredModel == null) {
            throw new IllegalArgumentException();
        }
        this._filteredColumns = (Object[])_FILTERED_COLUMNS.clone();
        this._filteredValues = (Object[])_FILTERED_VALUES.clone();
        this._filteredDefaults = (Object[])_COLUMN_DEFAULTS.clone();
        this._filteredModel = filteredModel;
        this._inspector = inspector;
        filteredModel.addTableModelListener(this);
        this._updateColumnInfo();
    }

    public boolean isPropertyCommon(int rowIndex) {
        return this._filteredModel.isPropertyCommon(rowIndex);
    }

    public Object[] getColumnMapping() {
        return this._columnMapping;
    }

    public void disposeFilterer() {
        this._filteredModel.removeTableModelListener(this);
    }

    public void setFilteredModel(PropertyModel newFilteredModel) {
        if (this._filteredModel != newFilteredModel) {
            this._filteredModel = newFilteredModel;
        }
    }

    public PropertyModel getFilteredModel() {
        return this._filteredModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setExpansionState(int rowIndex, boolean isExpanded) {
        int[] newToOld = this._getReorderedNewToOld();
        int oldIndex = newToOld[rowIndex];
        if (oldIndex < 0) {
            BitSet isGroupExpanded = this._isGroupExpanded;
            int groupIndex = -oldIndex - 1;
            if (isGroupExpanded.get(groupIndex) != isExpanded) {
                PropertyGroup[] oldGroups = this.getGroups(true);
                PropertyFilterer propertyFilterer = this;
                synchronized (propertyFilterer) {
                    if (isExpanded) {
                        isGroupExpanded.set(groupIndex);
                    } else {
                        isGroupExpanded.clear(groupIndex);
                    }
                    this._invalidateGroupedMapping();
                }
                this._invalidateModel();
                this._inspector.firePropertyChange("expandedGroups", oldGroups, this.getGroups(true));
                return true;
            }
        } else {
            int offset = this._getDrillDown(newToOld, rowIndex);
            if (offset == 0) {
                if (this._filteredModel.isPropertyDrillable(oldIndex)) {
                    PropertyModel ds;
                    boolean expanded;
                    Object id = this._filteredModel.getPropertyID(oldIndex);
                    Boolean b = (Boolean)this._isModelExpanded.get(id);
                    boolean bl = expanded = b != null && b != false;
                    if (expanded != isExpanded && (ds = this._getDrilledModel(id, oldIndex)) != null) {
                        b = isExpanded ? Boolean.TRUE : Boolean.FALSE;
                        this._isModelExpanded.put(id, b);
                        this._invalidateRowMapping();
                        this._invalidateModel();
                        return true;
                    }
                }
            } else {
                Object id = this._filteredModel.getPropertyID(oldIndex);
                if (id != DOES_NOT_EXIST) {
                    boolean changed;
                    PropertyFilterer ds = (PropertyFilterer)this._getDrilledModel(id, oldIndex);
                    boolean bl = changed = ds == null ? true : ds.setExpansionState(offset - 1, isExpanded);
                    if (changed) {
                        this._invalidateRowMapping();
                        this._invalidateModel();
                    }
                    return changed;
                }
            }
        }
        return false;
    }

    public boolean getExpansionState(int rowIndex) {
        int[] newToOld = this._getReorderedNewToOld();
        int oldIndex = newToOld[rowIndex];
        if (oldIndex < 0) {
            int groupIndex = -oldIndex - 1;
            return this._isGroupExpanded.get(groupIndex);
        }
        int offset = this._getDrillDown(newToOld, rowIndex);
        if (offset == 0) {
            Object id;
            if (this._filteredModel.isPropertyDrillable(oldIndex) && (id = this._filteredModel.getPropertyID(oldIndex)) != DOES_NOT_EXIST) {
                Boolean b = (Boolean)this._isModelExpanded.get(id);
                return b != null && b != false;
            }
        } else {
            Object id = this._filteredModel.getPropertyID(oldIndex);
            if (id != DOES_NOT_EXIST) {
                PropertyFilterer ds = (PropertyFilterer)this._getDrilledModel(id, oldIndex);
                return ds == null ? false : ds.getExpansionState(offset - 1);
            }
        }
        return false;
    }

    public PropertyGroup[] getGroups(boolean expanded) {
        BitSet bits = this._isGroupExpanded;
        Vector v = new Vector();
        for (int i = 0; i < bits.size(); ++i) {
            if (bits.get(i)) {
                if (!expanded) continue;
                v.addElement(this._groups.elementAt(i));
                continue;
            }
            if (expanded) continue;
            v.addElement(this._groups.elementAt(i));
        }
        Object[] groups = null;
        int count = v.size();
        if (count != 0) {
            groups = new PropertyGroup[count];
            v.copyInto(groups);
        }
        return groups;
    }

    public void setGroups(PropertyGroup[] groups, boolean expanded) {
        PropertyGroup[] oldGroups = this.getGroups(true);
        BitSet bits = this._isGroupExpanded;
        Vector groupsVector = this._groups;
        boolean changed = false;
        int size = groupsVector.size();
        for (int i = 0; i < size; ++i) {
            PropertyGroup group = (PropertyGroup)groupsVector.elementAt(i);
            boolean set = false;
            for (int j = 0; j < groups.length; ++j) {
                if (groups[j] != group) continue;
                set = true;
                break;
            }
            if (set) {
                if (expanded && !bits.get(i)) {
                    bits.set(i);
                    changed = true;
                    continue;
                }
                if (expanded || !bits.get(i)) continue;
                bits.clear(i);
                changed = true;
                continue;
            }
            if (expanded) {
                if (!bits.get(i)) continue;
                bits.clear(i);
                changed = true;
                continue;
            }
            if (bits.get(i)) continue;
            bits.set(i);
            changed = true;
        }
        if (changed) {
            this._invalidateGroupedMapping();
            this._invalidateModel();
            this._inspector.firePropertyChange("expandedGroups", oldGroups, this.getGroups(true));
        }
    }

    public boolean isGroupExpanded(PropertyGroup group) {
        Vector groups = this._groups;
        BitSet bits = this._isGroupExpanded;
        int size = groups.size();
        for (int i = 0; i < size; ++i) {
            if (groups.elementAt(i) != group) continue;
            return bits.get(i);
        }
        return false;
    }

    public void setGroupExpanded(PropertyGroup group, boolean expanded) {
        Vector groups = this._groups;
        BitSet bits = this._isGroupExpanded;
        int size = groups.size();
        for (int i = 0; i < size; ++i) {
            if (groups.elementAt(i) != group || bits.get(i) == expanded) continue;
            PropertyGroup[] oldGroups = this.getGroups(true);
            if (expanded) {
                bits.set(i);
            } else {
                bits.clear(i);
            }
            this._invalidateGroupedMapping();
            this._invalidateModel();
            this._inspector.firePropertyChange("expandedGroups", oldGroups, this.getGroups(true));
            break;
        }
    }

    public void setSortMode(int newSortMode) {
        if (this._sortMode != newSortMode) {
            if (newSortMode < 0 || newSortMode > 2) {
                throw new IllegalArgumentException();
            }
            this._sortMode = newSortMode;
            this._invalidateModel();
        }
    }

    public int isSorted() {
        return this._sortMode;
    }

    public void setWriteOnlyIncluded(boolean writeOnlyIncluded) {
        if (this._writeOnlyIncluded != writeOnlyIncluded) {
            this._writeOnlyIncluded = writeOnlyIncluded;
            Hashtable models = this._propertyModels;
            Enumeration e = models.keys();
            if (e != null) {
                while (e.hasMoreElements()) {
                    Object key = e.nextElement();
                    PropertyFilterer ds = (PropertyFilterer)models.get(key);
                    ds.setWriteOnlyIncluded(this._writeOnlyIncluded);
                }
            }
            this._setFilterValue(COLUMN_IS_READABLE, writeOnlyIncluded ? DOES_NOT_EXIST : Boolean.FALSE);
        }
    }

    public boolean getWriteOnlyIncluded() {
        return this._writeOnlyIncluded;
    }

    public void setAlphabetizeGroupProperties(boolean alphabetize) {
        if (this._alphabetize != alphabetize) {
            this._alphabetize = alphabetize;
            this._updateFilteredRows();
        }
    }

    public boolean isAlphabetizeGroupProperties() {
        return this._alphabetize;
    }

    public void setReadOnlyIncluded(boolean readOnlyIncluded) {
        if (this._readOnlyIncluded != readOnlyIncluded) {
            this._readOnlyIncluded = readOnlyIncluded;
            Hashtable models = this._propertyModels;
            Enumeration e = models.keys();
            if (e != null) {
                while (e.hasMoreElements()) {
                    Object key = e.nextElement();
                    PropertyFilterer ds = (PropertyFilterer)models.get(key);
                    ds.setReadOnlyIncluded(this._readOnlyIncluded);
                }
            }
            this._setFilterValue(COLUMN_IS_WRITABLE, readOnlyIncluded ? DOES_NOT_EXIST : Boolean.FALSE);
        }
    }

    public boolean getReadOnlyIncluded() {
        return this._readOnlyIncluded;
    }

    public void setUseIntersection(boolean useIntersection) {
        if (useIntersection != this._useIntersection) {
            this._useIntersection = useIntersection;
            this._updateFilteredRows();
        }
    }

    public boolean getUseIntersection() {
        return this._useIntersection;
    }

    public PropertyExpansionState[] getExpandedProperties() {
        Enumeration properties = this._isModelExpanded.keys();
        if (properties == null) {
            return null;
        }
        Vector<PropertyExpansionState> state = new Vector<PropertyExpansionState>(this._isModelExpanded.size());
        while (properties.hasMoreElements()) {
            PropertyFilterer model;
            Object property = properties.nextElement();
            if (!Boolean.TRUE.equals(this._isModelExpanded.get(property)) || (model = (PropertyFilterer)this._propertyModels.get(property)) == null) continue;
            state.add(new PropertyExpansionState(property, model.getExpandedProperties(), true));
        }
        if (state.size() == 0) {
            return null;
        }
        Object[] toRet = new PropertyExpansionState[state.size()];
        state.copyInto(toRet);
        return toRet;
    }

    public void setExpandedProperties(PropertyExpansionState[] properties) {
        Hashtable<Object, Boolean> table = new Hashtable<Object, Boolean>();
        int count = properties == null ? 0 : properties.length;
        for (int i = 0; i < count; ++i) {
            PropertyExpansionState pes = properties[i];
            Object id = pes.getPropertyID();
            int index = this.getFilteredModel().getPropertyIndex(id);
            if (index == -1 || !this.getFilteredModel().isPropertyDrillable(index)) continue;
            PropertyModel ds = this._getDrilledModel(id, index);
            if (ds != null) {
                this._isModelExpanded.put(id, Boolean.TRUE);
            }
            table.put(id, Boolean.TRUE);
        }
        Enumeration keys = this._isModelExpanded.keys();
        while (keys.hasMoreElements()) {
            Object toCheck = keys.nextElement();
            if (table.get(toCheck) != null) continue;
            this._isModelExpanded.put(toCheck, Boolean.FALSE);
        }
        this._invalidateRowMapping();
        this._invalidateModel();
    }

    public void setLocale(Locale locale) {
        this._filteredModel.setLocale(locale);
    }

    public Locale getLocale() {
        return this._filteredModel.getLocale();
    }

    public String getTargetDisplayName() {
        return this._filteredModel.getTargetDisplayName();
    }

    public int getColumnCount() {
        return this._columnMapping.length;
    }

    public void invalidateValueData() {
        this._filteredModel.invalidateValueData();
        Hashtable models = this._propertyModels;
        Enumeration e = models.keys();
        if (e != null) {
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                PropertyFilterer ds = (PropertyFilterer)models.get(key);
                ds.setWriteOnlyIncluded(this._writeOnlyIncluded);
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._filteredModel.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._filteredModel.removePropertyChangeListener(listener);
    }

    public boolean isCellEditable(int row, int col) {
        if (col == this._nameColumnIndex) {
            return super.isCellEditable(row, col);
        }
        int[] newToOld = this._getReorderedNewToOld();
        int oldIndex = newToOld[row];
        if (oldIndex < 0) {
            return false;
        }
        return this.getFilteredModel().isCellEditable(oldIndex, col);
    }

    public int getRowCount() {
        return this._getReorderedNewToOld().length;
    }

    public boolean isDataConflicting(int columnIndex, int rowIndex) {
        int oldIndex = this._getReorderedNewToOld()[rowIndex];
        if (oldIndex >= 0) {
            return this._filteredModel.isDataConflicting(columnIndex, oldIndex);
        }
        return false;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        boolean isLevelColumn = this._levelColumnIndex == columnIndex;
        boolean isDrillableColumn = this._drillableColumnIndex == columnIndex;
        int[] newToOld = this._getReorderedNewToOld();
        int oldIndex = 0;
        oldIndex = rowIndex == -1 || rowIndex >= newToOld.length ? -1 : newToOld[rowIndex];
        if (oldIndex >= 0) {
            int baseLevel = this.isSorted() == 2 ? 1 : 1;
            int offset = this._getDrillDown(newToOld, rowIndex);
            if (offset == 0) {
                Object id;
                boolean drillable;
                if (isLevelColumn) {
                    return IntegerUtils.getInteger((int)baseLevel);
                }
                Object data = this._filteredModel.getValueAt(oldIndex, columnIndex);
                if (isDrillableColumn && (drillable = Boolean.TRUE.equals(data)) && (id = this._filteredModel.getPropertyID(oldIndex)) != DOES_NOT_EXIST) {
                    PropertyFilterer ds = (PropertyFilterer)this._getDrilledModel(id, oldIndex);
                    data = ds == null ? Boolean.FALSE : (ds.getRowCount() > 0 ? Boolean.TRUE : Boolean.FALSE);
                }
                return data;
            }
            Object id = this._filteredModel.getPropertyID(oldIndex);
            if (id != null && id != DOES_NOT_EXIST) {
                Object data;
                PropertyModel ds = this._getDrilledModel(id, oldIndex);
                Object columnIdentifier = this._columnMapping[columnIndex];
                Object object = data = ds == null ? null : ds.getData(columnIdentifier, --offset);
                if (isLevelColumn) {
                    int level = baseLevel;
                    if (data instanceof Integer) {
                        level += ((Integer)data).intValue();
                    }
                    return IntegerUtils.getInteger((int)level);
                }
                return data;
            }
        } else {
            if (isLevelColumn) {
                return IntegerUtils.getInteger((int)0);
            }
            if (columnIndex == this._nameColumnIndex) {
                PropertyGroup group = (PropertyGroup)this._groups.elementAt(-oldIndex - 1);
                return group.getName(this.getLocale());
            }
        }
        return null;
    }

    public PropertyGroup getPropertyGroupAtIndex(int modelIndex) {
        int index = -modelIndex - 1;
        return (PropertyGroup)this._groups.elementAt(index);
    }

    public void setValueAt(Object newValue, int rowIndex, int columnIndex) {
        int[] newToOld = this._getReorderedNewToOld();
        int oldIndex = newToOld[rowIndex];
        int offset = this._getDrillDown(newToOld, rowIndex);
        if (oldIndex >= 0) {
            if (offset == 0) {
                this._filteredModel.setValueAt(newValue, oldIndex, columnIndex);
            } else {
                Object id = this._filteredModel.getPropertyID(oldIndex);
                if (id != null && id != DOES_NOT_EXIST) {
                    Object columnIdentifier;
                    int index;
                    --offset;
                    PropertyModel ds = this._getDrilledModel(id, oldIndex);
                    if (ds != null && (index = ds.getColumnIndex(columnIdentifier = this._columnMapping[columnIndex])) != -1) {
                        ds.setValueAt(newValue, offset, index);
                    }
                }
            }
        }
    }

    public void tableChanged(TableModelEvent e) {
        int type = e.getType();
        switch (type) {
            case 1: {
                if (e.getFirstRow() != -1) {
                    this._rowsAdded(e);
                    break;
                }
                this._columnsAdded(e);
                break;
            }
            case -1: {
                if (e.getFirstRow() != -1) {
                    this._rowsRemoved(e);
                    break;
                }
                this._columnsRemoved(e);
                break;
            }
            case 0: {
                if (e.getFirstRow() != -1) {
                    if (e.getColumn() == -1) {
                        this._invalidateRows(e);
                        break;
                    }
                    this._invalidateCells(e);
                    break;
                }
                this._invalidateColumns(e);
            }
        }
    }

    public boolean isSettable(Object oldValue, Object newValue) {
        return this._filteredModel.isSettable(oldValue, newValue);
    }

    public void startRead() {
        super.startRead();
        this._filteredModel.startRead();
    }

    public void stopRead() {
        super.stopRead();
        this._filteredModel.stopRead();
    }

    public int getModelIndex(int tableIndex) {
        int[] array = this._getReorderedNewToOld();
        return array[tableIndex];
    }

    public void dispose() {
        super.dispose();
    }

    Object[] __getFilteredColumns() {
        return this._filteredColumns;
    }

    Object[] __getFilteredValues() {
        return this._filteredValues;
    }

    Object[] __getFilteredDefaults() {
        return this._filteredDefaults;
    }

    void setFilterInfo(Object[] columns, Object[] values, Object[] defaults) {
        int count = columns.length;
        this._filteredColumns = new Object[count];
        System.arraycopy(columns, 0, this._filteredColumns, 0, count);
        this._filteredValues = new Object[count];
        System.arraycopy(values, 0, this._filteredValues, 0, count);
        this._filteredDefaults = new Object[count];
        System.arraycopy(defaults, 0, this._filteredDefaults, 0, count);
        this._updateFilteredRows();
        Hashtable models = this._propertyModels;
        Enumeration e = models.keys();
        if (e != null) {
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                PropertyFilterer ds = (PropertyFilterer)models.get(key);
                ds.setFilterInfo(columns, values, defaults);
            }
        }
    }

    private void _updateColumnMapping() {
        Object[] filteredColumnMapping = this._filteredModel.getColumnMapping();
        int numFilteredColumns = filteredColumnMapping.length;
        Object[] leveledColumnMapping = new Object[numFilteredColumns + 1];
        System.arraycopy(filteredColumnMapping, 0, leveledColumnMapping, 0, numFilteredColumns);
        leveledColumnMapping[numFilteredColumns] = COLUMN_LEVEL;
        this._columnMapping = leveledColumnMapping;
    }

    private void _updateColumnInfo() {
        this._updateColumnMapping();
        this._nameColumnIndex = this.getColumnIndex(COLUMN_DISPLAY_NAME);
        this._levelColumnIndex = this.getColumnIndex(COLUMN_LEVEL);
        this._drillableColumnIndex = this.getColumnIndex(COLUMN_IS_DRILLABLE);
    }

    private void _columnsAdded(TableModelEvent event) {
        this._filteredIndices = null;
        this._updateColumnInfo();
        this._invalidateModel();
    }

    private void _columnsRemoved(TableModelEvent event) {
        this._filteredIndices = null;
        this._updateColumnInfo();
        if (this.getColumnIndex(COLUMN_MODEL) == -1) {
            this._propertyModels.clear();
            this._isModelExpanded.clear();
        }
        this._invalidateModel();
    }

    private void _invalidateColumns(TableModelEvent event) {
        int startColumn = event.getColumn();
        int count = 1;
        boolean fireTableChanged = false;
        if (startColumn == -1) {
            if (event.getFirstRow() == -1) {
                this._filteredIndices = null;
                this._updateColumnInfo();
                fireTableChanged = true;
            }
            startColumn = 0;
            count = this.getColumnCount();
        }
        if (this._invalidateColumns(startColumn, count)) {
            this._invalidateRowMapping();
        }
        if (fireTableChanged) {
            this.fireTableChanged(event);
        }
        if (this._isModelColumnInvalid(event)) {
            this._clearModelCache(event);
        }
        this._fireColumnEvent(event);
    }

    private void _invalidateCells(TableModelEvent event) {
        int columnCount;
        int startColumnIndex = event.getColumn();
        int n = columnCount = event.getColumn() == -1 ? this.getColumnCount() : 1;
        if (this._invalidateColumns(startColumnIndex, columnCount)) {
            this._invalidateRowMapping();
        }
        if (this._isModelColumnInvalid(event)) {
            this._clearModelCache(event);
        }
        int[] oldToNewMapping = this._getReorderedOldToNew();
        int[] newToOldMapping = this._getReorderedNewToOld();
        int endColumnIndex = startColumnIndex + columnCount;
        int startRowIndex = event.getFirstRow();
        int endRowIndex = event.getLastRow();
        for (int j = startRowIndex; j < endRowIndex; ++j) {
            int rowIndex = oldToNewMapping[j];
            if (rowIndex != -1) {
                rowIndex -= this._getDrillDown(newToOldMapping, rowIndex);
            }
            for (int i = startColumnIndex; i < endColumnIndex; ++i) {
                if (rowIndex == -1) continue;
                this.fireTableCellUpdated(rowIndex, i);
            }
        }
    }

    private void _rowsAdded(TableModelEvent e) {
        this._invalidateRowMapping();
        this._fireRowEvent(e);
    }

    private void _rowsRemoved(TableModelEvent e) {
        int oldRows = this._getReorderedNewToOld().length;
        this._invalidateRowMapping();
        int newRows = this._getReorderedNewToOld().length;
        int count = oldRows - newRows;
        if (count > 0) {
            this.fireTableRowsDeleted(0, count - 1);
        } else if (count < 0) {
            this.fireTableRowsInserted(0, -count - 1);
        }
    }

    private void _invalidateRows(TableModelEvent e) {
        this._invalidateRowMapping();
        this._clearModelCache(e);
        this.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void _buildFilteredMappings() {
        PropertyModel model = this._filteredModel;
        model.startRead();
        try {
            boolean useIntersection = this._useIntersection;
            int numRows = model.getRowCount();
            int[] oldToNew = new int[numRows];
            IntVector newToOld = new IntVector(numRows);
            int[] filteredIndices = this._getFilteredIndices();
            int numFilteredColumns = filteredIndices.length;
            int currNewIndex = -1;
            int idColumn = model.getColumnIndex(COLUMN_ID);
            for (int i = 0; i < numRows; ++i) {
                if (!useIntersection || model.isPropertyCommon(i)) {
                    boolean isIncluded = true;
                    for (int j = 0; j < numFilteredColumns; ++j) {
                        Object filteredValue;
                        if (filteredIndices[j] == -1 || (filteredValue = this._filteredValues[j]) == DOES_NOT_EXIST) continue;
                        Object newValue = model.getValueAt(i, filteredIndices[j]);
                        if (newValue == DOES_NOT_EXIST) {
                            newValue = this._filteredDefaults[j];
                        }
                        if (newValue != filteredValue && (filteredValue == null || !filteredValue.equals(newValue))) continue;
                        isIncluded = false;
                        break;
                    }
                    if (isIncluded) {
                        PropertyModel ds;
                        Boolean expanded;
                        Object id;
                        newToOld.addElement(i);
                        oldToNew[i] = ++currNewIndex;
                        if (idColumn == -1 || (id = model.getValueAt(i, idColumn)) == null || id == DOES_NOT_EXIST || (expanded = (Boolean)this._isModelExpanded.get(id)) == null || !expanded.booleanValue() || (ds = this._getDrilledModel(id, i)) == null) continue;
                        int count = ds.getRowCount();
                        int index = i;
                        for (int k = 0; k < count; ++k) {
                            newToOld.addElement(index);
                            ++currNewIndex;
                        }
                        continue;
                    }
                    oldToNew[i] = currNewIndex;
                    continue;
                }
                oldToNew[i] = currNewIndex;
            }
            int numNew = newToOld.size();
            int[] newToOldArray = new int[numNew];
            newToOld.copyInto(newToOldArray);
            this._filteredNewToOld = newToOldArray;
            this._filteredOldToNew = oldToNew;
        }
        finally {
            model.stopRead();
        }
    }

    private int[] _getFilteredNewToOldMapping() {
        if (this._filteredNewToOld == null) {
            this._buildFilteredMappings();
        }
        return this._filteredNewToOld;
    }

    private int[] _getFilteredOldToNewMapping() {
        if (this._filteredOldToNew == null) {
            this._buildFilteredMappings();
        }
        return this._filteredOldToNew;
    }

    private int[] _buildReorderOldToNewMapping(int[] reorderedNewToOldMapping) {
        int numOldFiltered = this._getFilteredOldToNewMapping().length;
        int[] reorderedOldToNew = new int[numOldFiltered];
        for (int i = 0; i < numOldFiltered; ++i) {
            reorderedOldToNew[i] = -1;
        }
        int numReordered = reorderedNewToOldMapping.length;
        int[] newToOldFiltered = this._getFilteredNewToOldMapping();
        for (int i = 0; i < numReordered; ++i) {
            int filteredIndex = reorderedNewToOldMapping[i];
            if (filteredIndex < 0) continue;
            reorderedOldToNew[newToOldFiltered[filteredIndex]] = i;
        }
        return reorderedOldToNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void _buildGroupedMappings() {
        PropertyModel model = this._filteredModel;
        model.startRead();
        try {
            int[] newToOld = this._getFilteredNewToOldMapping();
            int groupColumnIndex = model.getColumnIndex(PropertyModel.COLUMN_GROUP);
            if (groupColumnIndex != -1) {
                int numFilteredNew = newToOld.length;
                Hashtable<Object, Integer> uniqueGroups = new Hashtable<Object, Integer>(13);
                Vector<IntVector> groupsMapping = new Vector<IntVector>();
                Vector groups = this._groups;
                int numOldGroups = this._groups.size();
                for (int i = 0; i < numOldGroups; ++i) {
                    uniqueGroups.put(groups.elementAt(i), IntegerUtils.getInteger((int)i));
                    groupsMapping.addElement(new IntVector());
                }
                int numGroups = numOldGroups;
                BitSet isGroupExpanded = this._isGroupExpanded;
                for (int i = 0; i < numFilteredNew; ++i) {
                    IntVector currGroupVector;
                    Object currGroup = model.getValueAt(newToOld[i], groupColumnIndex);
                    if (currGroup == PropertyModel.DOES_NOT_EXIST) {
                        if (groupsMapping.size() <= 0) continue;
                        currGroupVector = (IntVector)groupsMapping.elementAt(0);
                        currGroupVector.addElement(i);
                        continue;
                    }
                    Integer groupIndex = (Integer)uniqueGroups.get(currGroup);
                    if (groupIndex == null) {
                        groupIndex = IntegerUtils.getInteger((int)numGroups);
                        uniqueGroups.put(currGroup, groupIndex);
                        currGroupVector = new IntVector();
                        groupsMapping.addElement(currGroupVector);
                        groups.addElement(currGroup);
                        isGroupExpanded.set(numGroups);
                        ++numGroups;
                    } else {
                        currGroupVector = (IntVector)groupsMapping.elementAt(groupIndex);
                    }
                    currGroupVector.addElement(i);
                }
                int numVisibleRows = 0;
                for (int i = 0; i < numGroups; ++i) {
                    int numGroupRows = ((IntVector)groupsMapping.elementAt(i)).size();
                    if (numGroupRows <= 0) continue;
                    ++numVisibleRows;
                    if (!isGroupExpanded.get(i)) continue;
                    numVisibleRows += numGroupRows;
                }
                int[] groupedNewToOld = new int[numVisibleRows];
                int currNew = 0;
                int nameIndex = this.getColumnIndex(COLUMN_DISPLAY_NAME);
                for (int currGroupIndex = 0; currGroupIndex < numGroups; ++currGroupIndex) {
                    int numItems;
                    IntVector currGroup = (IntVector)groupsMapping.elementAt(currGroupIndex);
                    if (this.isAlphabetizeGroupProperties()) {
                        this._sortPropertiesInGroup(currGroup, nameIndex, newToOld);
                    }
                    if ((numItems = currGroup.size()) <= 0) continue;
                    groupedNewToOld[currNew] = -currGroupIndex - 1;
                    ++currNew;
                    if (!isGroupExpanded.get(currGroupIndex)) continue;
                    for (int currItemIndex = 0; currItemIndex < numItems; ++currItemIndex) {
                        groupedNewToOld[currNew] = currGroup.elementAt(currItemIndex);
                        ++currNew;
                    }
                }
                this._groupedOldToNew = this._buildReorderOldToNewMapping(groupedNewToOld);
                for (int i = 0; i < numVisibleRows; ++i) {
                    int filteredIndex = groupedNewToOld[i];
                    if (filteredIndex < 0) continue;
                    groupedNewToOld[i] = newToOld[filteredIndex];
                }
                this._groupedNewToOld = groupedNewToOld;
            } else {
                this._groupedOldToNew = this._getFilteredOldToNewMapping();
                this._groupedNewToOld = newToOld;
            }
        }
        finally {
            model.stopRead();
        }
    }

    private void _sortPropertiesInGroup(IntVector v, int nameIndex, int[] newToOld) {
        int size = v.size();
        int[] array = new int[size];
        v.copyInto(array);
        Object[] names = new Object[size];
        for (int i = 0; i < size; ++i) {
            int newIndex = array[i];
            int oldIndex = newToOld[newIndex];
            names[i] = this._filteredModel.getValueAt(oldIndex, nameIndex);
        }
        StringComparator comparator = new StringComparator(Collator.getInstance(this.getLocale()));
        int[] reorderedArray = Sort.indirectQSort((Object[])names, (int)size, (Comparator)comparator);
        for (int j = 0; j < size; ++j) {
            int reorderedIndex = reorderedArray[j];
            int alphaIndex = array[reorderedIndex];
            v.setElementAt(alphaIndex, j);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void _buildSortedMappings() {
        int[] filteredNewToOld = this._getFilteredNewToOldMapping();
        int numNew = filteredNewToOld.length;
        Object[] nameArray = new Object[numNew];
        PropertyModel model = this._filteredModel;
        model.startRead();
        try {
            int nameIndex = model.getColumnIndex(PropertyModel.COLUMN_DISPLAY_NAME);
            if (nameIndex != -1) {
                for (int i = 0; i < numNew; ++i) {
                    int index = filteredNewToOld[i];
                    nameArray[i] = model.getValueAt(index, nameIndex);
                }
                StringComparator comparator = new StringComparator(Collator.getInstance(this.getLocale()));
                int[] sortedIndices = Sort.indirectQSort((Object[])nameArray, (int)numNew, (Comparator)comparator);
                this._sortedOldToNew = this._buildReorderOldToNewMapping(sortedIndices);
                for (int i = 0; i < numNew; ++i) {
                    sortedIndices[i] = filteredNewToOld[sortedIndices[i]];
                }
                this._sortedNewToOld = sortedIndices;
            } else {
                this._sortedOldToNew = this._getFilteredOldToNewMapping();
                this._sortedNewToOld = filteredNewToOld;
            }
        }
        finally {
            model.stopRead();
        }
    }

    private int[] _getReorderedNewToOld() {
        switch (this._sortMode) {
            case 0: {
                return this._getFilteredNewToOldMapping();
            }
            case 1: {
                if (this._sortedNewToOld == null) {
                    this._buildSortedMappings();
                }
                return this._sortedNewToOld;
            }
            case 2: {
                if (this._groupedNewToOld == null) {
                    this._buildGroupedMappings();
                }
                return this._groupedNewToOld;
            }
        }
        return null;
    }

    private int[] _getReorderedOldToNew() {
        switch (this._sortMode) {
            case 0: {
                return this._getFilteredOldToNewMapping();
            }
            case 1: {
                if (this._sortedOldToNew == null) {
                    this._buildSortedMappings();
                }
                return this._sortedOldToNew;
            }
            case 2: {
                if (this._groupedOldToNew == null) {
                    this._buildGroupedMappings();
                }
                return this._groupedOldToNew;
            }
        }
        return null;
    }

    private void _fireRowEvent(TableModelEvent event) {
        int oldStartIndex = event.getFirstRow();
        int oldEndIndex = event.getLastRow();
        if (oldEndIndex >= this._filteredModel.getRowCount()) {
            oldEndIndex = this._filteredModel.getRowCount() - 1;
        }
        int[] oldToNewMapping = this._getFilteredOldToNewMapping();
        int newEndIndex = oldToNewMapping[oldEndIndex];
        int newStartIndex = oldToNewMapping[oldStartIndex];
        if (newStartIndex == -1) {
            newStartIndex = 0;
        } else if (this._getFilteredNewToOldMapping()[newStartIndex] != oldStartIndex) {
            ++newStartIndex;
        }
        int numNewRowsAffected = newEndIndex - newStartIndex + 1;
        if (numNewRowsAffected > 0) {
            int eventID = event.getType();
            int[] reorderedOldToNew = this._getReorderedOldToNew();
            if (reorderedOldToNew != oldToNewMapping) {
                if (numNewRowsAffected == 1) {
                    newStartIndex = reorderedOldToNew[oldStartIndex];
                } else {
                    int numNewRows = this.getRowCount();
                    if (numNewRowsAffected != numNewRows) {
                        if (eventID == 0) {
                            newStartIndex = 0;
                            numNewRowsAffected = numNewRows;
                        } else {
                            this._updateFilteredRows();
                            return;
                        }
                    }
                }
            }
            if (numNewRowsAffected != 0) {
                int endRow = newStartIndex + numNewRowsAffected - 1;
                if (event.getType() == 0) {
                    this.fireTableRowsUpdated(newStartIndex, endRow);
                } else {
                    this.fireTableRowsInserted(newStartIndex, endRow);
                }
            }
        }
    }

    private void _fireColumnEvent(TableModelEvent event) {
        this.fireTableDataChanged();
    }

    private boolean _invalidateColumns(int startColumn, int columnCount) {
        int endColumn = startColumn + columnCount - 1;
        int groupIndex = this.getColumnIndex(COLUMN_GROUP);
        if (groupIndex >= startColumn && groupIndex <= endColumn) {
            return true;
        }
        int[] filteredIndices = this._getFilteredIndices();
        for (int i = 0; i < filteredIndices.length; ++i) {
            int currFilteredIndex = filteredIndices[i];
            if (this._filteredValues[i] == DOES_NOT_EXIST || currFilteredIndex < startColumn || startColumn > endColumn) continue;
            return true;
        }
        return false;
    }

    private void _updateFilteredRows() {
        this._filteredIndices = null;
        this._invalidateRowMapping();
        this._invalidateModel();
    }

    private synchronized void _invalidateSortedMapping() {
        this._sortedNewToOld = null;
        this._sortedOldToNew = null;
    }

    private synchronized void _invalidateGroupedMapping() {
        this._groupedNewToOld = null;
        this._groupedOldToNew = null;
    }

    private synchronized void _invalidateRowMapping() {
        this._filteredNewToOld = null;
        this._filteredOldToNew = null;
        this._invalidateSortedMapping();
        this._invalidateGroupedMapping();
    }

    private int[] _getFilteredIndices() {
        if (this._filteredIndices == null) {
            PropertyModel model = this._filteredModel;
            Object[] filteredColumns = this._filteredColumns;
            int numFilteredColumns = filteredColumns.length;
            int[] filteredIndices = new int[numFilteredColumns];
            for (int i = 0; i < numFilteredColumns; ++i) {
                filteredIndices[i] = model.getColumnIndex(filteredColumns[i]);
            }
            this._filteredIndices = filteredIndices;
        }
        return this._filteredIndices;
    }

    private int _getFilterIndex(Object columnID) {
        for (int i = 0; i < this._filteredColumns.length; ++i) {
            if (columnID != this._filteredColumns[i]) continue;
            return i;
        }
        return -1;
    }

    public void setColumnFilter(Object columnID, Object filterValue, Object defaultValue) {
        int index = this._getFilterIndex(columnID);
        if (index == -1) {
            int count = this._filteredColumns.length;
            Object[] array = new Object[count + 1];
            System.arraycopy(this._filteredColumns, 0, array, 0, count);
            array[count] = columnID;
            this._filteredColumns = array;
            array = new Object[count + 1];
            System.arraycopy(this._filteredValues, 0, array, 0, count);
            array[count] = filterValue;
            this._filteredValues = array;
            array = new Object[count + 1];
            System.arraycopy(this._filteredDefaults, 0, array, 0, count);
            array[count] = defaultValue;
            this._filteredDefaults = array;
        } else {
            this._filteredValues[index] = filterValue;
            this._filteredDefaults[index] = defaultValue;
        }
        Hashtable models = this._propertyModels;
        Enumeration e = models.keys();
        if (e != null) {
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                PropertyFilterer ds = (PropertyFilterer)models.get(key);
                ds.setColumnFilter(columnID, filterValue, defaultValue);
            }
        }
        this._updateFilteredRows();
    }

    public Object getFilterValue(Object columnID) {
        int index = this._getFilterIndex(columnID);
        return index == -1 ? DOES_NOT_EXIST : this._filteredValues[index];
    }

    public Object getFilterDefaultValue(Object columnID) {
        int index = this._getFilterIndex(columnID);
        return index == -1 ? DOES_NOT_EXIST : this._filteredDefaults[index];
    }

    private void _setFilterValue(Object columnID, Object newValue) {
        int filterIndex = this._getFilterIndex(columnID);
        if (filterIndex != -1 && newValue != this._filteredValues[filterIndex]) {
            this._filteredValues[filterIndex] = newValue;
            this._updateFilteredRows();
        }
    }

    private void _invalidateModel() {
        this.fireTableStructureChanged();
    }

    private int _getDrillDown(int[] array, int index) {
        int toCheck = array[index];
        int count = 0;
        while (index > 0 && array[--index] == toCheck) {
            ++count;
        }
        return count;
    }

    private boolean _isModelColumnInvalid(TableModelEvent e) {
        int groupIndex;
        int column = e.getColumn();
        return column == (groupIndex = this.getColumnIndex(COLUMN_MODEL)) || column == -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _clearModelCache(TableModelEvent event) {
        block7: {
            Hashtable models;
            block6: {
                int startRow = event.getFirstRow();
                models = this._propertyModels;
                if (startRow >= 0) break block6;
                Enumeration e = models.keys();
                if (e == null) break block7;
                while (e.hasMoreElements()) {
                    Object key = e.nextElement();
                    PropertyModel ds = (PropertyModel)models.remove(key);
                    ds.removeTableModelListener(this._drilledModelListener);
                }
                break block7;
            }
            int endRow = event.getLastRow();
            if (endRow >= this._filteredModel.getRowCount()) {
                endRow = this._filteredModel.getRowCount() - 1;
            }
            this._filteredModel.startRead();
            try {
                for (int i = startRow; i <= endRow; ++i) {
                    PropertyModel ds;
                    Object id = this._filteredModel.getPropertyID(i);
                    if (id == null || id == DOES_NOT_EXIST || (ds = (PropertyModel)models.remove(id)) == null) continue;
                    ds.removeTableModelListener(this._drilledModelListener);
                }
            }
            finally {
                this._filteredModel.stopRead();
            }
        }
    }

    private PropertyModel _getDrilledModel(Object id, int rowIndex) {
        PropertyModel ds = (PropertyModel)this._propertyModels.get(id);
        if (ds == null && (ds = this._filteredModel.getPropertyModel(rowIndex)) != null) {
            PropertyFilterer pf = new PropertyFilterer(ds, null);
            pf.setFilterInfo(this._filteredColumns, this._filteredValues, this._filteredDefaults);
            pf.setWriteOnlyIncluded(this.getWriteOnlyIncluded());
            pf.setReadOnlyIncluded(this.getReadOnlyIncluded());
            pf.setSortMode(0);
            ds = pf;
            ds.addTableModelListener(this._drilledModelListener);
            this._propertyModels.put(id, ds);
        }
        return ds;
    }

    private class DrillDSListen
    implements TableModelListener {
        private DrillDSListen() {
        }

        public void tableChanged(TableModelEvent e) {
            PropertyFilterer.this._invalidateRowMapping();
            PropertyFilterer.this._invalidateModel();
        }
    }
}

