/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.editor;

import java.text.MessageFormat;
import oracle.bali.inspector.editor.EditorBundle;
import oracle.bali.inspector.editor.NumberRangeTextFieldEditor;

final class NumberRangeValidator {
    static void validateInput(NumberRangeTextFieldEditor numberEditor) {
        if (numberEditor.isInRange()) {
            return;
        }
        Number number = numberEditor.getNumber();
        Number minimum = numberEditor.getMinimum();
        Number maximum = numberEditor.getMaximum();
        if (minimum == null && maximum == null) {
            return;
        }
        if (minimum != null && maximum == null) {
            String raw = EditorBundle.get("NUMBER_LESS_THAN_MINIMUM");
            String formatted = MessageFormat.format(raw, number, minimum);
            throw new IllegalStateException(formatted);
        }
        if (minimum == null && maximum != null) {
            String raw = EditorBundle.get("NUMBER_GREATER_THAN_MAXIMUM");
            String formatted = MessageFormat.format(raw, number, maximum);
            throw new IllegalStateException(formatted);
        }
        String raw = EditorBundle.get("NUMBER_NOT_IN_RANGE");
        String formatted = MessageFormat.format(raw, number, minimum, maximum);
        throw new IllegalStateException(formatted);
    }

    private NumberRangeValidator() {
    }
}

