/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plugin.api.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.dbtools.plugin.api.security.AuthorizationConstraint;
import oracle.dbtools.plugin.api.servlet.ErrorResponseHandler;
import oracle.dbtools.plugin.api.servlet.HasDynamicAuthorization;
import oracle.dbtools.plugin.api.servlet.SupportsPatch;

public abstract class HttpServletBase
extends HttpServlet
implements HasDynamicAuthorization,
ErrorResponseHandler,
SupportsPatch {
    private static final long serialVersionUID = 7626196072848462225L;

    protected HttpServletBase() {
    }

    @Override
    public void doPatch(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.sendError(405);
    }

    @Override
    public AuthorizationConstraint getConstraint(HttpServletRequest request) throws ServletException, IOException {
        return HasDynamicAuthorization.USE_DEFAULT_CONSTRAINTS;
    }

    @Override
    public boolean onError(HttpServletRequest request, HttpServletResponse response, int statusCode, Throwable cause) throws ServletException, IOException {
        return false;
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = req.getMethod();
        if ("PATCH".equalsIgnoreCase(method)) {
            this.doPatch(req, resp);
        } else {
            super.service(req, resp);
        }
    }
}

