/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Component;
import javax.swing.JTextField;
import oracle.bali.inspector.editor.EditorComponentFactoryRegistry;
import oracle.ide.inspector.PropertyInfo;

public final class DisplayValues {
    public static final String MAX_DISPLAY_VALUE_LENGTH_KEY = "oracle.ide.inspector.maxDisplayValueLength";
    public static final String TRUNC_DISPLAY_VALUE_LENGTH_KEY = "oracle.ide.inspector.truncDisplayValueLength";
    public static final int MAX_DISPLAY_VALUE_LENGTH_DEFAULT = Integer.MAX_VALUE;
    public static final int TRUNC_DISPLAY_VALUE_LENGTH_DEFAULT = Integer.MAX_VALUE;
    private static int MAXIMUM_DISPLAY_VALUE_LENGTH = Integer.MAX_VALUE;
    private static int TRUNCATE_DISPLAY_VALUE_LENGTH = Integer.MAX_VALUE;

    public static String displayValue(PropertyInfo property) {
        Object displayValue = property.displayValue();
        return displayValue == null ? null : displayValue.toString();
    }

    public static void showDisplayValueInInlineEditor(Component inlineEditor, PropertyInfo property) {
        if (!(inlineEditor instanceof JTextField)) {
            return;
        }
        JTextField textEditor = (JTextField)inlineEditor;
        String currentText = textEditor.getText();
        String text = DisplayValues.displayValue(property);
        if (text == null || text.length() == 0) {
            return;
        }
        if (!text.equals(currentText)) {
            textEditor.setText(text);
        }
    }

    public static Component truncateDisplayValue(Component inlineEditor, PropertyInfo property) {
        if (inlineEditor instanceof JTextField) {
            String displayValue = DisplayValues.displayValue(property);
            EditorComponentFactoryRegistry factories = EditorComponentFactoryRegistry.instance();
            if (displayValue != null && displayValue.length() > MAXIMUM_DISPLAY_VALUE_LENGTH) {
                String text = displayValue.substring(0, TRUNCATE_DISPLAY_VALUE_LENGTH) + "...";
                if ((inlineEditor = factories.updateReadOnlyEditor(inlineEditor, text)) == null) {
                    return factories.createReadOnlyEditor(text);
                }
            } else if (!property.writable() || !((JTextField)inlineEditor).isEditable()) {
                if (null == (inlineEditor = factories.updateReadOnlyEditor(inlineEditor, displayValue))) {
                    return factories.createReadOnlyEditor(displayValue);
                }
            } else {
                inlineEditor = factories.updateWritableEditor(inlineEditor, displayValue);
            }
        }
        return inlineEditor;
    }

    private DisplayValues() {
    }

    static {
        int maxDisplayValueLength = Integer.getInteger(MAX_DISPLAY_VALUE_LENGTH_KEY, Integer.MAX_VALUE);
        int truncDisplayValueLength = Integer.getInteger(TRUNC_DISPLAY_VALUE_LENGTH_KEY, Integer.MAX_VALUE);
        MAXIMUM_DISPLAY_VALUE_LENGTH = Math.max(maxDisplayValueLength, truncDisplayValueLength);
        TRUNCATE_DISPLAY_VALUE_LENGTH = Math.min(maxDisplayValueLength, truncDisplayValueLength);
    }
}

