/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.ide.model.Subject;

public class NotObservableSubjectRegistry {
    private final List<Class<? extends Subject>> notObservables = new CopyOnWriteArrayList<Class<? extends Subject>>();

    public void registerNotObservableSubject(Class<? extends Subject> subjectType) {
        if (this.notObservables.contains(subjectType)) {
            return;
        }
        this.notObservables.add(subjectType);
    }

    public void unregisterNotObservableSubject(Class<? extends Subject> subjectType) {
        if (!this.notObservables.contains(subjectType)) {
            return;
        }
        this.notObservables.remove(subjectType);
    }

    public boolean isObservable(Subject subject) {
        if (this.notObservables.isEmpty()) {
            return true;
        }
        for (Class<? extends Subject> type : this.notObservables) {
            if (!type.isInstance(subject)) continue;
            return false;
        }
        return true;
    }

    public static NotObservableSubjectRegistry instance() {
        return SingletonHolder.instance;
    }

    private NotObservableSubjectRegistry() {
    }

    private static class SingletonHolder {
        static NotObservableSubjectRegistry instance = new NotObservableSubjectRegistry();

        private SingletonHolder() {
        }
    }
}

