/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.timesten;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.jdbc.JdbcDatabaseDescriptor;
import oracle.javatools.db.plsql.parser.PlSqlParserFactory;
import oracle.javatools.db.plsql.parser.PlSqlParserFactoryImpl;
import oracle.javatools.db.timesten.TimesTen11g;
import oracle.javatools.db.timesten.TimesTen11gR2;
import oracle.javatools.db.timesten.TimesTen7;
import oracle.javatools.db.timesten.TimesTenDDLGenerator;
import oracle.javatools.db.timesten.TimesTenDatabase;
import oracle.javatools.db.validators.ColumnValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.SynonymValidator;

public class TimesTenDatabaseDescriptor
extends JdbcDatabaseDescriptor {
    public static final int MAX_NAME_LENGTH = 30;
    public static final char QUOTE_IDENTIFIER = '\"';
    private static final Set RESERVED_WORDS = new HashSet<String>(Arrays.asList("AGING", "ALL", "ANY", "AS", "BETWEEN", "BIGINT", "BINARY", "BINARY_DOUBLE_INFINITY", "BINARY_DOUBLE_NAN", "BINARY_FLOAT_INFINITY", "BINARY_FLOAT_NAN", "CASE", "CHAR", "CHARACTER", "COLUMN", "CONNECTION", "CONSTRAINT", "CROSS", "CURSOR", "CURRENT_SCHEMA", "CURRENT_USER", "DATASTORE_OWNER", "DATE", "DEC", "DECIMAL", "DEFAULT", "DESTROY", "DISTINCT", "DOUBLE", "FIRST", "FLOAT", "FOR", "FOREIGN", "FROM", "GROUP", "HAVING", "INNER", "INT", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "IS", "JOIN", "LEFT", "LIKE", "LONG", "MINUS", "NATIONAL", "NCHAR", "NO", "NULL", "NUMERIC", "NVARCHAR", "ON", "ORA_SYSDATE", "ORDER", "PRIMARY", "PROPAGATE", "PUBLIC", "READONLY", "REAL", "RETURN", "RIGHT", "ROWNUM", "ROWS", "SELF", "SELECT", "SESSION_USER", "SET", "SMALLINT", "SOME", "SYSDATE", "SYSTEM_USER", "TIME", "TINYINT", "TT_SYSDATE", "UNION", "UNIQUE", "UPDATE", "USER", "USING", "VARBINARY", "VARCHAR", "VARYING", "WHEN", "WHERE"));
    private static Set RESERVED_WORDS_11G = new HashSet<String>(Arrays.asList("AGING", "ALL", "ANY", "AS", "BETWEEN", "BINARY_DOUBLE_INFINITY", "BINARY_DOUBLE_NAN", "BINARY_FLOAT_INFINITY", "BINARY_FLOAT_NAN", "CASE", "CHAR", "COLUMN", "CONNECTION", "CONSTRAINT", "CROSS", "CURRENT_SCHEMA", "CURRENT_USER", "CURSOR", "DATASTORE_OWNER", "DATE", "DECIMAL", "DEFAULT", "DESTROY", "DISTINCT", "FIRST", "FLOAT", "FOR", "FOREIGN", "FROM", "GROUP", "HAVING", "INNER", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "IS", "JOIN", "LEFT", "LIKE", "LONG", "MINUS", "NULL", "ON", "ORA_SYSDATE", "ORDER", "PRIMARY", "PROPAGATE", "PUBLIC", "READONLY", "RIGHT", "ROWNUM", "ROWS", "SELECT", "SELF", "SESSION_USER", "SET", "SMALLINT", "SOME", "SYSDATE", "SYSTEM_USER", "TO", "TT_SYSDATE", "UID", "UNION", "UNIQUE", "UPDATE", "USER", "USING", "VARCHAR", "WHEN", "WHERE"));
    private final int m_version;

    public TimesTenDatabaseDescriptor(Class<? extends TimesTenDatabase> clazz) {
        super(clazz);
        this.m_version = TimesTen11gR2.class.isAssignableFrom(clazz) ? 112 : (TimesTen11g.class.isAssignableFrom(clazz) ? 110 : (TimesTen7.class.isAssignableFrom(clazz) ? 7 : 6));
    }

    public int getCasePolicy() {
        return 2;
    }

    public String getIdentifierQuoteString() {
        return String.valueOf('\"');
    }

    public int getMaxNameLength(String string) {
        return 30;
    }

    public void validateName(String string, String string2) throws InvalidNameException {
        TimesTenDatabaseDescriptor.validateIdentifier((String)string2, (char)'\"', (int)30, (String)"_$#@", (boolean)true, (Set)((Set)this.getReservedWords()), (int)this.getCasePolicy(), (boolean)this.allowSurrogatesInIdentifierValidation());
    }

    public final String getDatabaseType() {
        return "TimesTen";
    }

    public int getDatabaseVersion() {
        return this.m_version;
    }

    public Collection<String> getReservedWords() {
        if (this.m_version >= 112) {
            Set set = RESERVED_WORDS_11G;
            set.add("WITH");
            return set;
        }
        if (this.m_version >= 110) {
            return RESERVED_WORDS_11G;
        }
        return RESERVED_WORDS;
    }

    public DDLGenerator getDDLGenerator(DBObjectProvider dBObjectProvider) {
        Object object = null;
        if (this.m_version == 6) {
            object = super.getDDLGenerator(dBObjectProvider);
        } else if (this.m_version >= 7) {
            object = new TimesTenDDLGenerator(dBObjectProvider, this.getDatabaseClass());
        }
        return object;
    }

    public Map<String, DBObjectValidator> getValidators(DBObjectProvider dBObjectProvider) {
        Map map = super.getValidators(dBObjectProvider);
        if (this.m_version >= 110) {
            map.put("COLUMN", new ColumnValidator(dBObjectProvider, true));
            map.put("SYNONYM", new SynonymValidator(dBObjectProvider));
        }
        return map;
    }

    public String getInternalName(String string, String string2) {
        String string3 = super.getInternalName(string, string2);
        return string3 == null ? null : string3.toUpperCase();
    }

    public PlSqlParserFactory getPlSqlParserFactory(DBObjectProvider dBObjectProvider) {
        return new PlSqlParserFactoryImpl(dBObjectProvider);
    }
}

