/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideri.importexport;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.controls.checkboxlist.CheckBoxList;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.ideri.importexport.ImportExportInvoker;
import oracle.javatools.dialogs.ExceptionDialog;

class ImportExportWizard
extends JPanel {
    private final Component _parent;
    private final Context _context;
    private final List _invokers;
    private final String _title;
    private final String _label;
    private final String _helpTag;
    private CheckBoxList _list = new CheckBoxList();
    private CheckBoxListModel _listModel = new CheckBoxListModel();
    private int _selectedIndex;
    private JEWTDialog _dlg;

    public ImportExportWizard(Component parent, Context context, List<ImportExportInvoker> invokers, String title, String label, String helpTag) throws Exception {
        this._parent = parent;
        this._context = context;
        this._invokers = invokers;
        this._title = title;
        this._label = label;
        this._helpTag = helpTag;
        this.jbInit();
    }

    public ImportExportInvoker getSelectedWizard() {
        return (ImportExportInvoker)this._listModel.getUserObjectAt(this._selectedIndex);
    }

    public boolean runDialog(final Context context) {
        this._dlg = JEWTDialog.createDialog((Component)this._parent, (String)this._title, (int)7);
        this._dlg.setCenterOver(this._parent);
        this._dlg.setContent((Component)this);
        this._dlg.setInitialFocus((Component)this._list);
        this._dlg.setResizable(true);
        this._dlg.pack();
        this.setOKEnabled();
        this._dlg.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                    boolean wizStatus = false;
                    try {
                        wizStatus = ImportExportWizard.this.getSelectedWizard().invokeWizard(context);
                    }
                    catch (Exception ex) {
                        ExceptionDialog.showExceptionDialog((Window)ImportExportWizard.this._dlg, (Exception)ex);
                        throw new PropertyVetoException("no", evt);
                    }
                    if (!wizStatus) {
                        throw new PropertyVetoException("no", evt);
                    }
                }
            }
        });
        boolean retval = this._dlg.runDialog();
        this._dlg.dispose();
        return retval;
    }

    private void jbInit() throws Exception {
        this.populateListModel(this._invokers);
        this._list.setModel((ListModel)this._listModel);
        JScrollPane scrollPane = new JScrollPane((Component)this._list);
        JLabel listLbl = new JLabel();
        ResourceUtils.resLabel((JLabel)listLbl, (Component)this._list, (String)this._label);
        this.setLayout(new GridBagLayout());
        this.add((Component)listLbl, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._list.setSelectionMode(0);
        this._list.setSelectedIndex(0);
        this._list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ImportExportWizard.this.list_valueChanged();
            }
        });
        this._list.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImportExportWizard.this.list_mouseClicked(e);
            }
        });
        HelpSystem hs = HelpSystem.getHelpSystem();
        if (hs != null) {
            hs.registerTopic((JComponent)this, this._helpTag);
        }
    }

    private void populateListModel(List invokers) throws Exception {
        for (ImportExportInvoker invoker : invokers) {
            this._listModel.addElement((Object)invoker, invoker.getIcon(this._context), invoker.getName(this._context), invoker.getToolTipText(this._context));
        }
        this._listModel.sort();
    }

    private void list_mouseClicked(MouseEvent e) {
        int clickedRow;
        if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && (clickedRow = this._list.locationToIndex(e.getPoint())) != -1) {
            this._selectedIndex = clickedRow;
            this._dlg.closeDialog(false);
        }
    }

    private void list_valueChanged() {
        this._selectedIndex = this._list.getSelectedIndex();
        this.setOKEnabled();
    }

    private void setOKEnabled() {
        this._dlg.setOKButtonEnabled(this._listModel.getSize() > 0 && this._selectedIndex != -1);
    }
}

