/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.di;

import oracle.dbtools.common.di.DependencyConstraints;
import oracle.dbtools.common.util.NullOrEmpty;

public class Dependency {
    private final DependencyConstraints constraints;
    private final Kind kind;
    private final boolean optional;
    private final Class<?> type;

    Dependency(Kind kind, Class<?> type, boolean optional, DependencyConstraints constraints) {
        this.kind = kind;
        this.type = type;
        this.optional = optional;
        this.constraints = constraints;
    }

    public DependencyConstraints constraints() {
        return this.constraints;
    }

    public String description() {
        StringBuilder b = new StringBuilder();
        b.append(" requires ");
        b.append(this.type.getName());
        if (!NullOrEmpty.nullOrEmpty(this.constraints)) {
            b.append(" with constraints: ");
            b.append(this.constraints);
        }
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dependency other = (Dependency)obj;
        if (this.constraints == null ? other.constraints != null : !this.constraints.equals(other.constraints)) {
            return false;
        }
        if (this.kind != other.kind) {
            return false;
        }
        if (this.optional != other.optional) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.constraints == null ? 0 : this.constraints.hashCode());
        result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
        result = 31 * result + (this.optional ? 1231 : 1237);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public String toString() {
        String pkg;
        StringBuilder b = new StringBuilder();
        if (!this.constraints.isEmpty()) {
            b.append(this.constraints);
            b.append(' ');
        }
        if (Kind.USES_VIA_PROVIDER == this.kind) {
            b.append("Provider<");
        }
        String name = this.type.getName();
        Package thePackage = this.type.getPackage();
        if (thePackage != null && !(pkg = thePackage.getName()).isEmpty() && !pkg.startsWith("java")) {
            name = name.substring(pkg.length() + 1);
        }
        b.append(name);
        if (Kind.USES_VIA_PROVIDER == this.kind) {
            b.append(">");
        }
        return b.toString();
    }

    public Class<?> type() {
        return this.type;
    }

    Kind kind() {
        return this.kind;
    }

    static enum Kind {
        USES,
        USES_MULTIPLE,
        USES_VIA_PROVIDER;

    }
}

