/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.di;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.inject.Provider;
import oracle.dbtools.common.builder.BuilderBase;
import oracle.dbtools.common.builder.Version;
import oracle.dbtools.common.builder.Versioned;
import oracle.dbtools.common.di.CyclicDependencyException;
import oracle.dbtools.common.di.Dependency;
import oracle.dbtools.common.di.DependencyConstraints;
import oracle.dbtools.common.di.DependencyInjectionException;
import oracle.dbtools.common.di.Descendants;
import oracle.dbtools.common.di.ProviderDescriptor;
import oracle.dbtools.common.di.TypeDependencies;
import oracle.dbtools.common.di.__Reflections;
import oracle.dbtools.common.graph.DirectedGraph;
import oracle.dbtools.common.graph.DirectedGraphCycleException;
import oracle.dbtools.common.graph.EdgeChecker;
import oracle.dbtools.common.graph.Path;
import oracle.dbtools.common.reflect.Constructors;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.MultiAssociativeArray;
import oracle.dbtools.common.util.MultiAssociativeArrays;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.plugin.api.di.annotations.Optional;

class DependencyGraph
extends Versioned {
    private final DirectedGraph<Class<?>, Dependency> graph;
    private final Set<Class<?>> ignoredServiceTypes;
    private final MultiAssociativeArray<Class<?>, Class<?>> providers;
    private final Set<Class<?>> types;
    static final DirectDependencyChecker DIRECT_DEPENDENCY = new DirectDependencyChecker();
    static final EdgeFormatter EDGE_FORMATTER = new EdgeFormatter();
    static final VertexFormatter VERTEX_FORMATTER = new VertexFormatter();
    private static final Dependency[] NO_DEPENDENCIES = new Dependency[0];
    private static final PriorityComparator PRIORITY_COMPARATOR = new PriorityComparator();
    private static final Constructors CONSTRUCTORS = new Constructors();

    private DependencyGraph(Version version, DirectedGraph.CyclePolicy cyclePolicy, Set<Class<?>> types, Set<Class<?>> ignoredServiceTypes) throws CyclicDependencyException {
        super(version);
        MultiAssociativeArray<Class<?>, Class<?>> providers = this.providers(types, ignoredServiceTypes);
        DirectedGraph<Class<?>, Dependency> graph = this.graph(cyclePolicy, types, providers);
        this.providers = providers;
        this.graph = graph;
        this.types = types;
        this.ignoredServiceTypes = ignoredServiceTypes;
    }

    public Iterable<TypeDependencies> allDependencies(Class<?> type) {
        Descendants descendants = new Descendants(this.graph, type);
        return descendants.arcs();
    }

    public boolean canProvide(Class<?> type, DependencyConstraints constraints) {
        Set<Class<?>> matches = this.constrainedProviders(type, constraints, this.providers);
        return !matches.isEmpty();
    }

    public boolean contains(Class<?> provider) {
        return this.types.contains(provider);
    }

    public <T> Iterable<Class<? extends T>> providers(Class<T> type) {
        TreeSet<Class<T>> matches = new TreeSet<Class<T>>(PRIORITY_COMPARATOR);
        Iterable<Class<?>> candidates = this.providers.values(type);
        if (candidates != null) {
            for (Class<?> candidate : candidates) {
                matches.add(candidate);
            }
        }
        return matches;
    }

    public int size() {
        return this.graph.size();
    }

    @Override
    public String toString() {
        return this.graph.toString();
    }

    Dependency[] constructorDependencies(Class<?> type) {
        Constructor<?> constructor = DependencyGraph.annotatedConstructor(type);
        if (constructor == null) {
            return NO_DEPENDENCIES;
        }
        return this.dependencies(constructor);
    }

    DirectedGraph<Class<?>, Dependency> graph() {
        return this.graph;
    }

    Iterable<Class<?>> types() {
        return this.types;
    }

    private Set<Class<?>> constrainedProviders(Class<?> type, DependencyConstraints constraints, MultiAssociativeArray<Class<?>, Class<?>> providers) {
        TreeSet matches = new TreeSet((Comparator<Class<?>>)((Object)DependencyGraph.priorityComparator()));
        Iterable<Class<?>> candidates = providers.values(type);
        if (candidates != null) {
            for (Class<?> candidate : candidates) {
                Annotation[] annotations = candidate.getDeclaredAnnotations();
                if (!constraints.matches(annotations)) continue;
                matches.add(candidate);
            }
        }
        return matches;
    }

    private Iterable<Dependency> dependencies(Class<?> type) {
        LinkedHashSet<Dependency> dependencies = new LinkedHashSet<Dependency>();
        Constructor<?> annotated = DependencyGraph.annotatedConstructor(type);
        if (annotated != null) {
            Iterables.add(dependencies, Iterables.iterable(this.dependencies(annotated)));
        }
        return dependencies;
    }

    private Dependency[] dependencies(Constructor<?> constructor) {
        Annotation[][] annotations = CONSTRUCTORS.getParameterAnnotations(constructor);
        Type[] types = CONSTRUCTORS.getGenericParameterTypes(constructor);
        return this.dependencies(constructor, types, annotations);
    }

    private Dependency[] dependencies(Constructor<?> constructor, Type[] parameterTypes, Annotation[][] parameterAnnotations) {
        Dependency[] dependencies = new Dependency[parameterTypes.length];
        for (int i = 0; i < dependencies.length; ++i) {
            Dependency dependency;
            String name = constructor.getName() + " arg" + i;
            Type elementType = parameterTypes[i];
            Annotation[] annotations = parameterAnnotations[i];
            dependencies[i] = dependency = this.dependency(name, elementType, annotations);
        }
        return dependencies;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Dependency dependency(String name, Type elementType, Annotation ... annotations) {
        Type indirectType;
        boolean optional = this.optional(annotations);
        Class type = null;
        Dependency.Kind kind = Dependency.Kind.USES;
        if (elementType instanceof ParameterizedType && Provider.class.equals((Object)((ParameterizedType)elementType).getRawType())) {
            indirectType = ((ParameterizedType)elementType).getActualTypeArguments()[0];
            if (!(indirectType instanceof Class)) throw DependencyInjectionException.providerWithGenericTypeParameter(name, indirectType);
            type = (Class)indirectType;
            kind = Dependency.Kind.USES_VIA_PROVIDER;
        } else if (elementType instanceof ParameterizedType && this.isIterable(elementType)) {
            indirectType = ((ParameterizedType)elementType).getActualTypeArguments()[0];
            if (!(indirectType instanceof Class)) throw DependencyInjectionException.iterableWithGenericTypeParameter(name, indirectType);
            type = (Class)indirectType;
            kind = Dependency.Kind.USES_MULTIPLE;
        } else {
            if (!(elementType instanceof Class)) throw DependencyInjectionException.cannotCreateDependency(name, elementType);
            type = (Class)elementType;
        }
        DependencyConstraints constraints = DependencyConstraints.constraints(annotations);
        if (!constraints.isEmpty()) return new Dependency(kind, type, optional, constraints);
        if (Dependency.Kind.USES_MULTIPLE != kind) return new Dependency(kind, type, optional, constraints);
        constraints = DependencyConstraints.ANY_CONSTRAINTS;
        return new Dependency(kind, type, optional, constraints);
    }

    private DirectedGraph<Class<?>, Dependency> graph(DirectedGraph.CyclePolicy cyclePolicy, Set<Class<?>> types, MultiAssociativeArray<Class<?>, Class<?>> providers) throws CyclicDependencyException {
        DirectedGraph.Builder<Class<?>, Dependency> resolved = DirectedGraph.builder();
        resolved.edgeChecker(DIRECT_DEPENDENCY);
        resolved.edgeFormatter(EDGE_FORMATTER);
        resolved.vertexFormatter(VERTEX_FORMATTER);
        resolved.cyclePolicy(cyclePolicy);
        for (Class<?> type : types) {
            Iterable<Dependency> dependencies = this.dependencies(type);
            if (NullOrEmpty.nullOrEmpty(dependencies)) {
                resolved.vertex(type);
                continue;
            }
            for (Dependency dependency : dependencies) {
                Iterable<Class<?>> targets = this.resolve(dependency, providers);
                for (Class<?> target : targets) {
                    resolved.connect(type, target, dependency);
                }
            }
        }
        try {
            return resolved.build();
        }
        catch (DirectedGraphCycleException e) {
            ArrayList paths = new ArrayList();
            Iterator<Path<?, ?>> i$ = e.paths().iterator();
            while (i$.hasNext()) {
                Path<?, ?> path;
                Path<?, ?> cycle = path = i$.next();
                paths.add(cycle);
            }
            throw new CyclicDependencyException(paths);
        }
    }

    private boolean isIterable(Type elementType) {
        return Iterable.class.isAssignableFrom((Class)((ParameterizedType)elementType).getRawType());
    }

    private boolean optional(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            boolean optional = Optional.class.equals(annotation.annotationType());
            if (!optional) continue;
            return true;
        }
        return false;
    }

    private MultiAssociativeArray<Class<?>, Class<?>> providers(Set<Class<?>> types, Set<Class<?>> ignoredServiceTypes) {
        MultiAssociativeArrays.Builder<Class<?>, Class<?>> providers = MultiAssociativeArrays.builder();
        for (Class<?> type : types) {
            ProviderDescriptor descriptor = new ProviderDescriptor(type, ignoredServiceTypes);
            for (Class<?> service : descriptor.provides()) {
                providers.add(service, type);
            }
        }
        return providers.build();
    }

    private Iterable<Class<?>> resolve(Dependency dependency, MultiAssociativeArray<Class<?>, Class<?>> providers) {
        Class<?> type = dependency.type();
        DependencyConstraints constraints = dependency.constraints();
        Set<Class<?>> matches = this.constrainedProviders(type, constraints, providers);
        if (Dependency.Kind.USES_MULTIPLE != dependency.kind() && matches.size() > 1) {
            return Iterables.iterable(Iterables.first(matches));
        }
        if (matches.isEmpty()) {
            matches.add(dependency.type());
        }
        return matches;
    }

    public static Builder builder() {
        return DependencyGraph.builder(null);
    }

    public static Builder builder(DependencyGraph existing) {
        return new Builder(existing);
    }

    static Constructor<?> annotatedConstructor(Class<?> type) {
        Constructor<?>[] constructors = __Reflections.getConstructorsAnnotatedWith(type, Inject.class);
        if (constructors.length == 0) {
            return null;
        }
        if (constructors.length > 1) {
            throw DependencyInjectionException.tooManyConstructors(type);
        }
        Constructor<?> constructor = constructors[0];
        return constructor;
    }

    static PriorityComparator priorityComparator() {
        return PRIORITY_COMPARATOR;
    }

    private static final class VertexFormatter
    implements oracle.dbtools.common.graph.VertexFormatter<Class<?>> {
        private VertexFormatter() {
        }

        @Override
        public String apply(Class<?> type) {
            String pkg;
            StringBuilder b = new StringBuilder("\"");
            String name = type.getName();
            Package thePackage = type.getPackage();
            if (thePackage != null && !(pkg = thePackage.getName()).isEmpty() && !pkg.startsWith("java")) {
                name = name.substring(pkg.length() + 1);
            }
            b.append(name);
            b.append("\"");
            return b.toString();
        }
    }

    private static class PriorityComparator
    extends oracle.dbtools.plugin.api.di.PriorityComparator {
        private PriorityComparator() {
        }

        public int compare(Class<?> o1, Class<?> o2) {
            int diff = super.compare(o1, o2);
            if (diff == 0) {
                diff = o1.getName().compareTo(o2.getName());
            }
            return diff;
        }
    }

    private static final class EdgeFormatter
    implements oracle.dbtools.common.graph.EdgeFormatter<Class<?>, Dependency> {
        private EdgeFormatter() {
        }

        @Override
        public String apply(Dependency value, Class<?> destination) {
            StringBuilder b = new StringBuilder();
            if (destination.equals(value.type())) {
                if (!value.constraints().isEmpty()) {
                    b.append(value.constraints());
                }
            } else {
                b.append(value.toString());
            }
            return b.toString();
        }
    }

    private static final class DirectDependencyChecker
    implements EdgeChecker<Class<?>, Dependency> {
        private DirectDependencyChecker() {
        }

        @Override
        public boolean follow(Class<?> origin, Dependency edge, Class<?> destination) {
            boolean direct = !this.viaProvider(edge);
            return direct;
        }

        private boolean viaProvider(Dependency edge) {
            return Dependency.Kind.USES_VIA_PROVIDER.equals((Object)edge.kind());
        }
    }

    private static class DependencyGraphState {
        DirectedGraph.CyclePolicy cyclePolicy;
        private final Set<Class<?>> ignoredServiceTypes;
        private final Set<Class<?>> types;

        DependencyGraphState(DirectedGraph.CyclePolicy cyclePolicy, Set<Class<?>> types, Set<Class<?>> ignoredServiceTypes) {
            this.cyclePolicy = cyclePolicy;
            this.types = new LinkedHashSet(types);
            this.ignoredServiceTypes = new LinkedHashSet(ignoredServiceTypes);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("DependencyGraphState [types=");
            builder.append(this.types);
            builder.append("]");
            return builder.toString();
        }
    }

    public static class Builder
    extends BuilderBase<DependencyGraph, DependencyGraphState> {
        private Builder(DependencyGraph existing) {
            super(DependencyGraph.class, existing);
        }

        @Override
        public DependencyGraph build() throws CyclicDependencyException {
            return (DependencyGraph)super.build();
        }

        public Builder cyclePolicy(DirectedGraph.CyclePolicy cyclePolicy) {
            ((DependencyGraphState)this.state()).cyclePolicy = cyclePolicy;
            this.modified();
            return this;
        }

        public Builder ignore(Class<?> serviceType) {
            ((DependencyGraphState)this.state()).ignoredServiceTypes.add(serviceType);
            this.modified();
            return this;
        }

        Builder add(Class<?> type) {
            if (!this.contains(type)) {
                ((DependencyGraphState)this.state()).types.add(type);
                this.modified();
            }
            return this;
        }

        Builder add(Iterable<Class<?>> types) {
            for (Class<?> type : types) {
                this.add(type);
            }
            return this;
        }

        boolean contains(Class<?> type) {
            return ((DependencyGraphState)this.state()).types.contains(type);
        }

        Builder remove(Class<?> type) {
            if (this.contains(type)) {
                ((DependencyGraphState)this.state()).types.remove(type);
                this.modified();
            }
            return this;
        }

        @Override
        protected DependencyGraphState existingState(DependencyGraph instance) {
            DependencyGraphState state = new DependencyGraphState(DirectedGraph.CyclePolicy.IGNORE, instance.types, instance.ignoredServiceTypes);
            return state;
        }

        @Override
        protected void modified() {
            super.modified();
        }

        @Override
        protected DependencyGraph newInstance(DependencyGraphState state, Version version) {
            return new DependencyGraph(version, state.cyclePolicy, state.types, state.ignoredServiceTypes);
        }

        @Override
        protected DependencyGraphState newState(DependencyGraphState existing) {
            if (existing == null) {
                return new DependencyGraphState(DirectedGraph.CyclePolicy.REPORT, Collections.emptySet(), Collections.emptySet());
            }
            return new DependencyGraphState(existing.cyclePolicy, existing.types, existing.ignoredServiceTypes);
        }
    }
}

