/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.di;

import oracle.dbtools.common.di.DependencyConstraints;
import oracle.dbtools.common.di.DependencyInjectionException;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.plugin.api.i18n.Translatable;

public class MissingDependencyException
extends DependencyInjectionException {
    private static final long serialVersionUID = -458225827171983451L;

    private MissingDependencyException(Translatable message) {
        super(message);
    }

    protected static MissingDependencyException noProvider(Class<?> type) {
        return MissingDependencyException.noProvider(null, type, null);
    }

    static MissingDependencyException noProvider(String site, Class<?> type, DependencyConstraints constraints) {
        StringBuilder b = new StringBuilder();
        b.append(" requires ");
        b.append(type.getName());
        if (!NullOrEmpty.nullOrEmpty(constraints)) {
            b.append(" with constraints: ");
            b.append(constraints);
        }
        String description = b.toString();
        if (site == null) {
            return new MissingDependencyException(MissingDependencyException.message("NO_PROVIDER_FOUND", "No provider found for: {0}", description));
        }
        return new MissingDependencyException(MissingDependencyException.message("NO_PROVIDER_FOUND_FOR_SITE", "No provider found for: {0} when injecting dependencies for: {1}", description, site));
    }
}

