/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.dbtools.common.graph.Edge;
import oracle.dbtools.common.graph.EdgeImpl;
import oracle.dbtools.common.graph.Vertex;
import oracle.dbtools.common.graph.VertexLookup;

class AdjacencyList<V, E>
implements Vertex<V, E> {
    private final List<Edge<V, E>> edges;
    private boolean hasIncoming = false;
    private final V value;

    AdjacencyList(V value) {
        this.value = value;
        this.edges = new ArrayList<Edge<V, E>>();
    }

    @Override
    public Collection<Edge<V, E>> edges() {
        return this.edges;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vertex other = (Vertex)obj;
        return !(this.value == null ? other.value() != null : !this.value.equals(other.value()));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean isOrphan() {
        return !this.hasIncoming && this.edges.isEmpty();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.value);
        return builder.toString();
    }

    @Override
    public V value() {
        return this.value;
    }

    AdjacencyList<V, E> add(E value, int targetVertex, VertexLookup<V, E> vertices) {
        EdgeImpl<V, E> edge = new EdgeImpl<V, E>(value, targetVertex, vertices);
        if (!this.edges.contains(edge)) {
            this.edges.add(edge);
        }
        return this;
    }

    AdjacencyList<V, E> incoming() {
        this.hasIncoming = true;
        return this;
    }
}

